+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-04-06T12:13:00-04:00"
lastmod = "2015-04-27T18:24:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429843382500/TapestryShow-768x1024.jpg.jpg"
publishDate = "2014-04-06T12:13:00-04:00"
related_articles = ["articles/go-see-this-tapex-metallurgy.md"]
related_companies = ["scene/companies/tapestry-opera.md"]
related_people = ["scene/people/michael-mori.md","scene/people/andrew-love.md","scene/people/andrea-ludwig.md","scene/people/adrian-kramer.md"]
short_description = "I saw something beautiful on Friday night, and I&#039;m not quite sure I can even tell you what it was. I can tell you that it was the inaugural presentation of Tapestry Explorations: Revolutions, and that it left an impression on me. The evening seemed to evolve on its own accord, beginning with understated and subtle entrances by performers Neema Bickersteth, Andrew Love, Andrea Ludwig and Adrian Kramer. "
slug = "in-review-tapex-revolutions"
title = "In Review: Tap:Ex Revolutions"
+++

I saw something beautiful on Friday night, and I'm not quite sure I can even tell you what it was. I _can_ tell you that it was the inaugural presentation of _Tapestry Explorations: Revolutions_, and that it left an impression on me.  The evening seemed to evolve on its own accord, beginning with understated and subtle entrances by performers [Neema Bickersteth](https://tapestryopera.com/node/69), [Andrew Love](/talking-to-singers-andrew-love/), [Andrea Ludwig](https://tapestryopera.com/node/65) and [Adrian Kramer](https://tapestryopera.com/node/66). They began spread out across the space, behind and among the audience. As they moved throughout the space and embodied different "characters" with each piece, they pulled your attention across the room. These four were simply pros. Choreographer [Marie-Josée Chartier](http://www.chartierdanse.com/) provided a beautiful movement aesthetic, always organic to the body but never predictable. The effect of Chartier's movements, exercised by these expert performers, had my rapt attention. At times I felt torn, unable to watch two places at once.  They took the audience through a fluid, riveting experience and I couldn't take my eyes off them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429843578968/Gregory.jpg.jpg)
<figcaption>Pianist Gregory Oh.</figcaption>
</figure>

The first part was pretty fascinating. It started with pianist and Tapestry Music Director [Gregory Oh](http://gregoryoh.com/) playing _Primitive_, by John Cage; it's a work for [prepared piano](http://en.wikipedia.org/wiki/Prepared_piano), and it was performed with movements Neema Bickersteth. I have a soft spot for John Cage, and Gregory's playing was pretty awesome. After that, there were two chorale excerpts by J.S. Bach, "Jesu, meine Freude" and "Ein feste Burg ist unser Gott", which bookended a cool scene of operatic existentialism.

Operatic characters of Gounod, Leoncavallo, Mozart and Puccini were conversing, using just lines from their arias; it culminated in a battle of wits, arranged by Benton Roark, between Tamino (the guy with _The Magic Flute_) and Silvio (of _Pagliacci_ fame). It felt light and clever at the start, and became almost tragic; it's a little heartbreaking to see Tamino start to question if Pamina is real or not.  Finally, when the four singers began the final Bach chorale, it felt like a scene of communal support in crisis; but then the four of them started walking away from each other, finally singing quietly, to themselves, in what felt like a a scared prayer.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429843536527/Neema.jpg.jpg)
<figcaption>Soprano Neema Bickersteth.</figcaption>
</figure>

The second half was just as mesmerizing, and I heard music with which I was almost entirely unfamiliar. Neema Bickersteth began the second part with Rachmaninoff's famous "Vocalise" and she made me hear it differently with movements that felt slightly dangerous; she returned with another vocalise later, this time Reza Jacobs' "Vocalise for Nema". This piece was a selection from [Volcano Theatre's ](http://volcano.ca/productions/beast/beast.php)_[A Moveable Beast](http://volcano.ca/productions/beast/beast.php), _and Neema reminded me of what can be said with simply the sound of the voice.

I had the chance to fall in love a few of the pieces on the program. The most obvious were the three selections by [Georges Aperghis](http://www.aperghis.com/); they were some of the most captivating and charming moments of the night. Andrea Ludwig performed "Recitation #14", and she made me feel as though I'd walked in on someone's most private thoughts. ["Ses muscles"](http://books.google.ca/books?id=Md8kDOCKwGMC&pg=PA56&lpg=PA56&dq=george+aperghis+ses+muscles&source=bl&ots=N5QoUkpGK0&sig=Q080O1SBSOok-CVC7XKtFmuSD5Y&hl=en&sa=X&ei=qW5BU8C7LYiF2QXPvYGIDQ&ved=0CC0Q6AEwAA#v=onepage&q=george%20aperghis%20ses%20muscles&f=false) was done by all four performers, and while I won't pretend to know what it was about, it was delightful and funny for some reason and must have been pretty hard to memorize. In a powerful excerpt of [Andrew Staniland](http://andrewstaniland.com/music/opera-vocal/)'s [_Ashlike on the Cradle of the Wind_](http://www.musiccentre.ca/node/28093) , Adrian Kramer was eery and predatory, and Andrew Love was his half-willing prey. Cool piece, give that link a click.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429843481344/AndrewLove.jpeg)
<figcaption>Baritone Andrew Love.</figcaption>
</figure>

In his first season as Artistic Director of Tapestry New Opera Works, [Michael Mori](https://tapestryopera.com/michael-mori) has already impressed me. _Revolutions_ was, to put it simply, damn creative. It made redundant any questions about choice of repertoire, casting the right singer and being "stylistic". In a quick chat with the audience, Mori spoke about opera's evolution on the large and small scales; with a nod to the "grand" (think [Robert Carsen](http://en.wikipedia.org/wiki/Robert_Carsen), [Robert Lepage](http://en.wikipedia.org/wiki/Robert_Lepage)), he expressed his curiosity with the evolution of the artists themselves:

> Most young and vital operatic performers, such as our extraordinary cast, study and perform mostly hundred year old European opera, although they are expressive and diverse living Canadians! For opera to evolve and to thrive again, the repertoire must converse with current culture and arts, and Tapestry is a willing revolutionary."

_Revolutions_ was refreshing and encouraging to see. I think it might be my favourite Tapestry show so far. Congratulations, guys!
