+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-03-08T12:48:00+00:00"
lastmod = "2016-03-09T09:51:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457464310539/2016-03-08---Barbican-Foyers---pc---Jorge-Royan.jpg.jpg"
primary_image_credit = "The Foyers in the Barbican Centre. Photo: copyright Jorge Royan."
publishDate = "2016-03-09T09:38:00+00:00"
related_articles = ["articles/london-calling.md","articles/he-saidshe-said-mozarts-requiem-at-tso.md","articles/heavy-nights-schoenberg-brahms-the-lpo-and-goerne.md","articles/in-review-lpo-presents-st-luke-passion.md","articles/review-the-personal-side-of-bachs-b-minor-mass.md"]
related_people = ["scene/people/claire-rutter.md","scene/people/stephen-gadd.md"]
short_description = "It&#039;s a piece that contains within it all that&#039;s needed to pack a punch; Brahms can get a reputation for being un-fun, and less imaginative than some of his contemporaries (like Strauss and Wagner), yet there was always something respectful about his music-first approach to telling a story. The City of London Choir and the Philharmonic Orchestra delivered thrilling waves of sound in those fantastic moments of &quot;Denn alles Fleisch...&quot;, and the soloists rang through the Hall like encouraging cries from a mass of bodies."
slug = "in-review-strauss-brahms-at-the-barbican"
title = "In review: Strauss &amp; Brahms at the Barbican"
+++

Monday evening was our inaugural visit to London's [Barbican Centre](http://www.barbican.org.uk/), to hear the City of London Choir, the Royal Philharmonic Orchestra, and soloists [Claire Rutter](/scene/people/claire-rutter/) and [Stephen Gadd](/scene/people/stephen-gadd/) perform some of our favourite music. With a bonus selection of Mendelssohn's *Psalm 98*, the programme was devoted to Richard Strauss' haunting *Vier letzte Lieder*, and Brahms' epic *Ein deutsches Requiem*.

The Barbican Centre seems to house every kind of cultural outing imaginable, right down to the cheerful intermission selection of baguette sandwiches and complicated-sounding scones. The building's Brutalist architecture is predictably hard on the eyes, a sentiment that feels whiny once we read that "it was developed from designs by architects Chamberlin, Powell and Bon as part of a utopian vision to transform an area of London left devastated by bombing during the Second World War." The interior actually reminds us of the music buildings at both Western University (in the other London), and the University of Toronto, and nostalgia seems to trump architectural aesthetics.

The evening's maestro was Hilary Davan Wetton, Artistic Director and Principal Condcutor of the City of London Choir. The opening Mendelssohn Psalm showed off the choir's impressive and uniform attention to detail, and it got our ears used to the new acoustic in the Barbican's Hall. Soprano Claire Rutter was a warm presence as she joined the Philharmonic to sing Strauss; the opening phrase of "Frühling" is unjustly low for most sopranos, but Rutter quickly moved into a sweet spot of her voice. There was steel in her sound, perhaps more than in the usual "Strauss sound"; yet Rutter's voice soared beautifully over the Philharmonic, and she took time to enjoy the great texts by Hesse and Eichendorff. 

Rutter returned in the second half with baritone Stephen Gadd, to sing the solos in Brahms' stunning *Ein deutsches Requiem*. It's a piece that has the capability to lull listeners into a trance with its heaviness, despite the very human text selections from the Lutheran Bible. The program notes included a quote from Brahms himself on his *Requiem*: "I will admit that I could happily omit the 'German' and simply say 'Human'."

It's a piece that contains within it all that's needed to pack a punch; Brahms can get a reputation for being un-fun, and less imaginative than some of his contemporaries (like Strauss and Wagner), yet there was always something respectful about his music-first approach to telling a story. The City of London Choir and the Philharmonic Orchestra delivered thrilling waves of sound in those fantastic moments of "Denn alles Fleisch...", and the soloists rang through the Hall like encouraging cries from a mass of bodies. Gadd and Rutter stood among the choir for the *Requiem*, rather than right downstage as Rutter had been for the Strauss. The acoustic was much kinder upstage, and we loved Gadd's open, honest baritone sound.

Despite the programme of music meant for connection and catharsis, there was something stiff about the night's performances. There seemed to be less listening than there could have been between the orchestra and singers; ensemble was of no issue in the Strauss, yet even with the difficult downstage acoustic, some aural antennae could have helped with the periodic imbalance of sound between Rutter and the players. 

As the *Requiem* unfolded, there grew a disconnect between the choir and orchestra; granted, maestro Wetton had quite a lot of bodies to keep together, and we're curious about the onstage acoustic and how easy it is for the musicians to hear each other. Another consideration is the fact that Wetton is the principal conductor for the City of London Choir, but not the Royal Philharmonic. The orchestra plays well behind the beat, evidently more so than the Choir; perhaps this is what we heard. 

That said, it was a total treat to hear these works performed live; for us, it was the first in-person listening of Brahms' *Requiem*, and it's a special, if at times long-winded, experience.
