+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-03-25T08:00:00-04:00"
lastmod = "2015-04-24T09:47:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429882789900/Stiffelio-764x1024.jpg.jpg"
publishDate = "2014-03-25T08:00:00-04:00"
related_articles = ["articles/in-review-the-mississauga-symphony-presents-carmen.md","articles/verdi-at-204-toscanini-at-150-the-2017-festival-verdi.md","articles/overdue-for-a-chicago-performance-the-haunted-manor.md"]
related_companies = ["scene/companies/voicebox-opera-in-concert.md"]
related_people = ["scene/people/ernesto-ramirez.md","scene/people/laura-albino.md","scene/people/geoffrey-sirett.md"]
short_description = "On Sunday, I attended the final show of the season by Voicebox: Opera in Concert at the St. Lawrence Centre for the Arts. They presented Verdi&#039;s Stiffelio, one of his lesser-known opera written after Nabucco and Ernani, but before La traviata and La forza del destino. I&#039;d certainly never heard of it, so I was curious."
slug = "in-review-stiffelio"
title = "In Review: Stiffelio"
+++

On Sunday, I attended the final show of the season by [Voicebox: Opera in Concert](http://www.operainconcert.com/) at the [St. Lawrence Centre for the Arts](http://www.stlc.com/). They presented Verdi's [_Stiffelio_](http://en.wikipedia.org/wiki/Stiffelio#), one of his lesser-known opera written after _Nabucco_ and _Ernani_, but before _La traviata_ and _La forza del destino_. I'd certainly never heard of it, so I was curious.

For some reason, _Stiffelio_ seemed to me like it had been written much earlier than 1850, but it was really just one year before _Rigoletto_. That 1850 premiere, however, was censored up the wa-zoo, and the textual watering-down made the story kind of lame. But it's worth getting to know the piece; you can start by checking out a score [here](http://sausage.whatbox.ca:15263/imglnks/usimg/1/10/IMSLP24547-PMLP55371-Verdi_-_Stiffelio.pdf) and reading a synopsis [here](http://en.wikipedia.org/wiki/Stiffelio#Synopsis). I sat through the show, fascinated at what felt like the beta-versions of some of Verdi's most famous music. That aria was so _Il trovatore_. That _tutti_ finale was totally Act 2, scene 2 of _La traviata_. And _Stiffelio_ also looked back at composers to whom Verdi owes his genius; I heard distinct moments of _Lucia di Lammermoor_ and what I'm sure were other nods to Donizetti. Neat.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429882974933/Ernesto-Ramirez-1024x1024.jpg.jpg)
<figcaption>Tenor Ernesto Ramìrez.</figcaption>
</figure>

The cast featured three solid singers in the three lead roles. [Ernesto Ramìrez](http://www.edgarernestoramirez.com/) sang the title role beautifully, impressively making his way through the difficult vocal writing. I've heard Ernesto sing periodically throughout the last few seasons, and I really enjoyed him in this kind of role. He's always had a warm, almost sweet quality to his sound, and in the role of Stiffelio, he had the chance to show a more fiery side to his instrument. There were moments when his sound had facets of Pavarotti, with plenty of honest and open singing. This is the kind of role that is difficult to pull off in an in-concert setting; to me, it felt similar to Otello in its high vocal demands, made easier by Verdi's expert dramatic trajectories.

Soprano [Laura Albino](http://www.lauraalbino.com/html/slideshow.php) was lovely and strong as Lina, the adulterous minister's wife (love it). I hadn't yet heard her sing Verdi, and I thought it suited her well; Lina is one of those roles where the female lead does some serious growing up between acts I and III, and Laura paced her singing wisely. She went from silvery and submissive at the top of the show, to a rounder, more assured sound that embraced an ever-widening vocal range. Very Gilda. I'm looking forward to hearing her more in this kind of repertoire.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429883015539/LauraA.jpg.jpg)
<figcaption>Soprano Laura Albino.</figcaption>
</figure>

[Geoffrey Sirett](http://www.geoffreysirett.com/) sang the role of Count Stankar, Lina's father. The role was another fiercely, almost anti-vocal writing; in his Act III aria, "O gioia inesprimibile, che questo core inondi!" Geoff stayed one step ahead of Verdi's incessant and ever-rising lines. To paraphrase a passing post-show comment from Geoff, it was "the hardest thing I ever sang in my life." I believe it. When he wasn't negotiating technical extremes, Geoff showed off his wide colour-palate and dangerous sound, very handy for Verdi baritone roles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429883064429/SIRETT-PHOTONEW2.jpg.jpg)
<figcaption>Baritone Geoffrey Sirett.</figcaption>
</figure>

The singers in three supporting roles were fine, although in a noticeably different class of vocal technique in comparison with the leads.  As Raffaele, Lina's lover, tenor [Hassan Anami](http://www.hassananami.com/biography/) sang with plenty of power. He wasn't at ease, however, in Italian, and more attention to diction details will naturally help his technical development. [Fabián Arciniegas](https://twitter.com/fabiolito) appeared as Federico, cousin to Lina. He too showed a strong instrument and fine stage presence, but he didn't take advantage of the natural aesthetic of the Italian language. If he does, he'll discover a lot more vocal ease. As Lina's other cousin, Dorotea, mezzo-soprano [Dina Shikhman](http://iemusicafirenze.blogspot.ca/2013/11/dina-shikhman-young-canadian-soprano.html) showed a lovely, rich sound. She's quite young at 21 years of age, but has plenty of stage experience already, including her time in the Canadian Children's Opera Chorus. I look forward to hearing her as she grows into her voice.

Under the direction of Robert Cooper, the Voicebox Chorus sang with a precise, stylistic sound. When Cooper joined the chorus to conduct, I thought it was the best music of the afternoon. Music director and pianist [Raisa Nakhmanovich](http://www.operainconcert.com/performers.htm#raisanakhmanovich) played the score confidently, filling out the largeness of sound often needed in Verdi score reductions. Unfortunately, the music suffered from a few missing details, and crucial ones. Nakhmanovich was unsteady in her tempos, and lacked the crisp, precise rhythm that's essential to making Verdi's scores function off the page. At times she didn't take aural cues from the singers who wanted to move a phrase faster, and could have taken more care with balance during some softer moments. But upon a quick glance of the score, it's a bit of a monster to play; performing the piece in one sitting must have felt like an extended piano concerto, and Nakhmanovich showed her experienced piano chops.

I enjoyed myself at Opera in Concert's _Stiffelio_. I liked seeing a new piece by a very familiar composer, and OIC is a good place to catch a lot of Toronto's young operatic talent in one place. They've also just released their 2014/15 season, which looks delightful. It doesn't seem to be on their [website](http://www.operainconcert.com/) yet, but the short of it is this: Manuel de Falla's _La Vida Breve_, Weill's _Street Scene_, Charpentier's _Louise_ and a first reading of _Isis and Osiris_, a new work by composer [Peter-Anthony Togni](http://www.petertogni.com/) and libretto by [Sharon Singer](http://sharonsinger.com/about/), both Canadians.

<div class="intro">Did you catch _Stiffelio_? What did you think? Let us know in the comments below!</div>
