+++
author = ["authors/jenna.md","authors/greg.md"]
categories = "Review"
date = "2017-07-31T12:02:00-04:00"
lastmod = "2017-08-01T12:28:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501600877917/2017-08-01---SOLT-square.jpg.jpg"
primary_image_credit = "A scene from Night Blooming Cereus, SOLT, 2017. Photo: Emily Ding."
publishDate = "2017-08-01T11:31:00-04:00"
related_articles = ["articles/falstaff-he-saidshe-said.md","articles/ariodante-or-the-hebridean-handel.md"]
short_description = "Night Blooming Cereus and A Northern Lights Dream have little in common except the fact that they&#039;re Canadian operas, set in the worlds of small-town Shakespeare, Ontario."
slug = "in-review-solts-canadian-doublebill"
title = "In review: SOLT&#039;s Canadian double-bill"
+++

**Jenna**: On this year's line-up for [Summer Opera Lyric Theatre](http://www.solt.ca/) is a double-bill of Canadian operas, featuring John Beckwith's *Night Blooming Cereus* and Michael Rose's newly commissioned *A Northern Lights Dream*. The two one-acts, sung by two casts until **August 5**, are refreshing, alongside a season of standards that also includes Bizet's *Carmen* (until **August 6**) and Mozart's *The Marriage of Figaro* (until **August 4**).

*Night Blooming Cereus* and *A Northern Lights Dream* have little in common except the fact that they're Canadian operas, set in the worlds of small-town Shakespeare, Ontario. The mention of streets named after trees, and a small handful of easy-to-remember last names ("Smiths, Browns, Whites") create a familiar world for *Night Blooming Cereus*, which tells a slow-burn of a story about family reunions and the mysterious houseplant that centralises the lives of the townsfolk.

**Greg**: Beckwith's *Night Blooming Cereus* is another one of those simple stories that speaks to Canadians due its familiarity of setting and people. Coming from a small town, I can totally relate to the buzz the entire community feels whenever there is in exciting event going on - whether it's the blooming of a rare blossom (once every hundred years) or the arrival of an unknown visitor (a "Come From Away" as we would call them in Cape Breton).

**Jenna**: Beckwith's opera is a tricky combination of driving dissonance in the score, and a static quality to the drama. The scenes felt difficult to carry after a time, as though they ran out of meaningful material. The direction by Guillermo Silva-Marin seemed not to reflect the music; when there was clear motion, the stage was still, and often the naturalistic world of the libretto was at odds with Silva-Marin's overly demonstrative, face-front staging. Beckwith offered up details about the characters in his music, including a stuttering manner of speech in Ben (sung by Logan Hickey), yet those details went unacknowledged.

**Greg**: The score is sparse, utilizing dissonance and resolution to drive the harmonies forward. The vocal lines, some of which were a devil of a diction and patter lesson, were a bit on the static side for me. I felt a longing for a bit more of a melodic development. Music Director Suzy Smith played the score incredibly well, providing wonderful, yet unobtrusive, support to the singers who were performing some very tricky rhythmic and vocal lines. Jenny Cohen, as Mrs. Conrad Brown (one of many "Browns" we learn) sang a beautiful, plaintive role. I could have used a bit more diction to help drive the melancholy of the lonliness Mrs. Brown felt, but her physicality was on point. Grace Quinsey sang the role Alice. She sang with a respectful presence and a bright, flexible tone. I was also particularly taken with Logan Hickey's Ben. One of the more theatrical voices on stage, his characterization of the stuttering shop boy was true and palpable. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501600947431/2017-08-01---image007.jpg.jpg)
<figcaption>Grace Quinsey (left) and Jenny Cohen in *Night Blooming Cereus*, SOLT, 2017. Photo by Emily Ding.</figcaption>
</figure>

**Jenna**: From the piano, music director Suzy Smith deftly led the cast of 9 through the score, demanding impressive clarity of texture and language. Adriene Verschuren and Alida Doornberg gave an energetic start to *Night Blooming Cereus* as the First and Second Girls, acting as foils to the more subdued Alice, sung by Grace Quinsey. Jenny Cohen sang Mrs. Brown, owner of the rare houseplant and a depressive figure onstage. On the one hand a clear picture of a lonely older woman; still, Cohen's sombre presence lacked ebb and flow, and despite her warm mezzo, she seemed unwilling to risk beauty of tone to give us enough text.

**Greg**: The story is a simple one, with stakes that aren't particularly high for anyone other than Alice and Mrs. Brown (and the flower). The story focused on how the current state of affairs made the actors feel, as opposed to telling the story of the actual state of affairs. I think this led to a more subdued staging, but there were choices that left me a little wanting. Maybe a more - for lack of better word - ethereal approach to the staging may have worked better at telling a story of people's feelings rather than people's actions. 

**Jenna**: Michael Rose's *A Northern Lights Dream* was a refreshing second-half change, light-hearted from the start and with a musical aesthetic that had hints of Jason Robert Brown and Stephen Sondheim. The opera makes countless nods towards Shakespeare's *A Midsummer Night's Dream*, the largest of which is the generous scattering of puns throughout the Rose's libretto. Clever one-liners popped out at us continuously, giving personality to the characters and a thoughtful quality to the audience's experience. Shakespeare fans have plenty to do in spotting the connections between *A Northern Lights Dream* and the Bard's tale of magic and confused mortal lovers: donkey costumes, fairy-like figures, people named Helen/Demetrius/Tania, and the mischievous Robin, a hockey-playing source of comedy who stirs up drama, and makes cheeky nods to Canadianism and Shakespeare's Puck. (Get it? because it's a hockey puck?)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501600968834/2017-08-01---Northern-Nights-Dream-4828-Reduced.jpg.jpg)
<figcaption>Avery LaFrentz (Robin) and James Smith (Nick) in *A Northern Lights Dream*, SOLT, 2017. Photo by Emily Ding.</figcaption>
</figure>

**Greg**: Michael Rose's *A Northern Lights Dream* is more of a musical than an opera, not because of its use of spoken dialogue - which the cast managed well - but because of the style of music chosen and presented. Great numbers like Mrs. Duke's treatise on her past marriages, and Taylor's reminisces about his late partner drive this show from curtain to curtain. The musical numbers are laden with Rose's trademark wordplay and puns which made me cackle out loud more than once. The score was equal parts Jason Robert Brown, Stephen Sondheim and with a dash of William Flinn and Stephen Schwartz thrown in for good measure. 

**Jenna**: Within the *Midsummer* references, the story is a tender one of doomed marriages, life as a gay person in a small town, and the hilarious (?) connections between the two. The concurrent stories seemed familiar, and ranked according to heaviness; Nick falls blindly for a Tania (who might be a lesbian), Helen is forced to deal with the fact that her husband Demetrius is gay and closeted, and Taylor lives his life openly, perhaps too affected by the death of his partner to worry about what small-townsfolk may think of him. Some of it felt heavy-handed: the gay tailor, the park meant for hook-ups, the butch hockey player, Helen's aria about her closeted husband - set in an actual closet. Yet the sentiments were heartfelt.

**Greg**: What really got me was the subject matter. *A Northern Lights Dream* is a coming-out story, but told from the other side of the closet door. We see the effect of a man struggling with his sexuality has on the entire community around him - even though we never meet the man himself. It's a refreshing take of non-queer perspectives told through a queer lens. It's also a nice treat for Shakespeare buffs like myself who love seeing how this could possibly be the next act in *A Midsummer Night's Dream*. The use of Puck and the "shop assistants" as a chorus was a brilliant move and provided Rose with a *de facto* girl group to back everyone up that kind of reminded me of the girls on Skid Row in *Little Shop of Horrors*. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501600979003/2017-08-01---Northern-Nights-Dream-4735-Reduced.jpg.jpg)
<figcaption>James Smith (Nick) and Logan Hickey (Taylor) in *A Northern Lights Dream*, SOLT, 2017. Photo by Emily Ding.</figcaption>
</figure>

**Jenna**: The show had a funny balance of organicism and exaggerated theatre, and it was hard to discern whether it came from Rose's score or from Silva-Marin's direction. *A Northern Lights Dream* seemed to bring out the best in the singers we had seen in *Night Blooming Cereus*. Grace Quinsey was a balance of naïve and relatable, and Logan Hickey proved a sympathetic actor as Taylor. Jenny Cohen's stiff delivery was a hilarious fit on Mrs. Duke, the thrice-married woman who spends the show rolling out surprises about herself. With music direction by Suzy Smith, the cast handled well the motion between sung and spoken text, and the score keeps a firm foot in the operatic door with a few unforgiving vocal settings (a few of which were concentrated in Robin's aria, sung impressively by Avery Lafrentz).

**Greg**: The cast seemed a lot more engaged in this particular production. Cohen as Mrs. Duke came alive as the eccentric rich lady with a coterie of ex-husbands and Logan Hickey as Taylor, the gay "tailor" (nice nod to Theseus and the Mechanicals there) provided both comic relief and poignant perspective on the subject at hand. As the struggling young wife, Quinsey showed that her voice may actually be really well suited to "legit" musical theatre (think *The King and I* or *A Light in the Piazza*), and as the Donkey-suited Nick (Bottom), James Smith sang with an easy tone that showed some great growth potential. But it was Avery LaFrentz as the gender-neutral, sexually ambiguous Robin (Goodfellow - aka Puck) that stole the show. Her comedic timing was understated and hilarious. 

**Greg**: SOLT is a great program that teaches singers how to sing a role as a character and the tricks of the trade in an actual theatrical environment. SOLT holds a special place for me, as it was playing Bardolfo in Verdi's *Falstaff* years ago that helped me make the decision to focus on opera as opposed to musical theatre, which is something for which I'll be forever grateful. Give them a shot, you might find the country's next superstar waiting in the wings.

>For details about SOLT's summer line-up, and to purchase tickets, [click here.](http://www.solt.ca/performances.html)
