+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-01-28T10:26:00-05:00"
lastmod = "2016-01-28T17:38:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454001943642/2016-01-28---SiegfriedSquare.jpg.jpg"
primary_image_credit = "Stefan Vinke slaying Fafner the Dragon in the Canadian Opera Company production of Siegfried, 2016.  Photo: Michael Cooper."
publishDate = "2016-01-28T15:36:00-05:00"
related_articles = ["articles/in-review-die-walkre-at-the-coc.md","articles/talking-with-singers-christine-goerke.md","articles/in-review-the-marriage-of-figaro.md","articles/in-review-tristan-and-isolde-at-eno.md","articles/still-incredible-robert-lepages-nightingale.md","articles/antoine-wagner-gesamtkunstwerk-in-2018.md","articles/the-flying-dutchman-a-stellar-homecoming-for-hgo.md","articles/inflatable-beasts-vocal-brilliance-locs-siegfried.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/christine-goerke.md","scene/people/alan-held.md","scene/people/stefan-vinke.md","scene/people/christopher-purves.md","scene/people/johannes-debus.md"]
short_description = "Even since last season&#039;s Die Walküre at the Canadian Opera Company, I&#039;ve been experiencing acute anticipation for Wagner&#039;s Ring Cycle to continue. In Canada, we have to be more patient than most about our Wagner consumption, yet last night I was sated by François Girard&#039;s production of Siegfried."
slug = "in-review-siegfried"
title = "In review: Siegfried"
+++

Even since last season's *Die Walküre* at the Canadian Opera Company, I've been experiencing acute anticipation for Wagner's *Ring Cycle* to continue. In Canada, we have to be more patient than most about our Wagner consumption, yet last night I was sated by François Girard's production of *Siegfried*.

This is a thrilling show, no matter how you look at it. Set and costume designer Michael Levine is a common thread between *Die Walküre* (directed by Atom Egoyan) and *Siegfried*; the destruction-ridden, industrial scene of Valhalla we remembered from *Walküre* was called back right from the top of *Siegfried*. A huge vortex of dead heroes and shattered debris funnels down to a central tree stump, where Siegfried often sits. It was a stunning extension to Levine's Valhalla, as if we had taken an elevator down several levels of stage, to where the gods and mortals meet. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454002017355/Siegfried-0629Resized.jpg.jpg)<figcaption>l-r: Alan Held as the Wanderer, George Molnar as the Bear, Stefan Vinke as Siegfried and Wolfgang Ablinger-Sperrhacke as Mime in the Canadian Opera Company production of *Siegfried*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

Levine's use of perspective always stuns me; at the top of Act II, we saw the same vortex of debris, yet this time we were looking directly down into it, complete with a bird's eye view of Siegfried on his tree-stump seat. The picture couldn't be more clear: Siegfried is the source, the One. 

The entire production had a feeling of Ur-story to it, with non-specific white linen costumes and a dominant black-versus-white aesthetic. Act III cleared the stage of the bodies and debris, focusing like a laser on the doused ring of fire, and the boundaries between Brünnhilde and Siegfried. A black abyss surrounded a white circle, and using Wagner's extraordinary skills in anticipation-building, Girard kept the fated lovers in their own spaces (Siegfried from "the world" and Brünnhilde from above) until the final second of the score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454013497136/Siegfried_Act_2-002Resized.jpg.jpg)
<figcaption>Christopher Purves (right) as Alberich in the Canadian Opera Company production of *Siegfried*, 2016. Photo: Chris Hutcheson.</figcaption>
</figure>

Girard did a beautiful job of letting the story unfold, unobscured. The stunning sets, non-literal as the were, allowed for really human scenes to unfold. Siegfried was still an immature, cocky teen, and Alberich and Mime shared a decent amount of fraternal strife. Even the Wanderer's summoning of Fafner the Dragon seemed less about the magic of it, and it made the story more accessible, even with a few opportunities for comic relief.

The surreal wasn't lost on Levine or Girard, and the scene where Siegfried slays the dragon was a fantastic moment for that; this scene is so hard to stage without it looking cheesy, but I was held rapt by this Fafner. The booming voice of Philip Ens had the dark, enormous quality that Wagner writes so incredibly, and the dragon itself was a floating human pyramid of six flying dancers. The six bodies rise up, unnaturally and in a terrrifying way, to form the enormous head of Fafner; Levine has a really specific aesthetic for the way bodies move in his shows that sends creepy-crawlies down my spine, and it couldn't have been put to better use than in this famous scene.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454012630231/Siegfried-1211Resized.jpg.jpg)<figcaption>l-r: Jacqueline Woodley as the Forest Bird (background) with Stefan Vinke as Siegfried and Wolfgang Ablinger-Sperrhacke as Mime in the Canadian Opera Company production of *Siegfried*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

The singing was spectacular. In the title role, [Stefan Vinke](/scene/people/stefan-vinke/) was unreal; the role seemed written for him, with barely signs of fatigue by the final act. His was perhaps the most humongous sound I've heard in the Four Seasons Centre, and still he was likable as a naïve, often bratty, young hero. As the Wanderer, [Alan Held](/talking-with-singers-alan-held/) was an imposing sight, matching well with his clear, booming sound. He was a calm, collected foil to the agitated dwarves or the ADHD Seigfried, and Wagner's music sits in the sweetest spot of Held's voice. 

As the Nibelung Mime, the blacksmith and not-so-eager adoptive parent to Seigfried, [Wolfgang Ablinger-Sperrhacke](/scene/people/wolfgang-ablinger-sperrhacke/) sang with an immediacy and brightness that made him a vocal chameleon; he was kind when Siegfried was being nasty, and he could turn on a dime to reveal his own nastiness and greed. Baritone [Christopher Purves](/scene/people/christopher-purves/) was a mean-sounding, athletic Alberich, Mime's formidable brother and the cause of this whole *Ring Cycle* business. Purves is a real singing actor, with huge specificity in how he sings (spits, really) his lines. 

Soprano [Jacqueline Woodley](/scene/people/jacqueline-woodley/) made a beautiful Forest Bird. Her voice was like a palate cleanser in its lightness, even as she sang almost entirely suspended in the air. As Erda, contralto Meredith Arwady sounded just like her name suggests, earthy and deep.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454013115760/Siegfried-4492Resized.jpg.jpg)
<figacption>Stefan Vinke as Siegfried and Christine Goerke as Brünnhilde in the Canadian Opera Company production of *Siegfried*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

Again with Wagner's love of anticipation, we waited until Act III to hear [Christine Goerke](/talking-with-singers-christine-goerke/) as Brünnhilde. The scene, an extended duet with her and Siegfried, could have been static in its black and white hues and dearth of cool stage effects; instead, it drew us in, thanks to Goerke's extraordinary singing with Vinke. She has that steel in her top, and mezzo-like warmth in the bottom, both of which are constantly surprising. She's a really human Valkyrie, one who fits Siegfried's eager, love-struck discovery of her sleeping body. It's no small feat to show us a character's history *and* her journey from isolation to finding true love in one act, but it really was like a reunion with Goerke's Brünnhilde; Wagner's anticipation paid off.

This *Siegfried* is a complete stunner, and if you can snag a ticket, it's worth the price. It runs until February 14th at the Four Seasons Centre for the Perfoming Arts. For details and ticket information, follow our box office links below.
