+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-12-07T10:46:00+00:00"
lastmod = "2016-12-07T11:33:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481107373188/2016-12-7---Scenes-from-the-End--Heloise-Werner-Square.jpg.jpg"
primary_image_credit = "Héloïse Werner in Scenes from the End, 2016. Photo by Nick Rutter."
publishDate = "2016-12-07T11:33:00+00:00"
related_articles = ["articles/talking-with-singers-heloise-werner.md","articles/in-review-bluebeards-castle-erwartung.md","articles/in-review-death-desire.md","articles/in-review-the-reimagined-winters-tale.md","articles/4-shows-to-perk-up-the-postholiday-blues.md","articles/dont-miss-the-other-side-of-the-sea.md"]
related_people = ["scene/people/heloise-werner.md"]
short_description = "&quot;Over the past few years, I have experienced grief. It&#039;s impossible to rationally &#039;describe&#039; your experience of grief because death is absurd,&quot; writes Werner in her performer&#039;s notes. &quot;When you lose someone, you find yourself surrounded by people who never talk to you about it - not in person anyway - because they simply can&#039;t. Or, if they think they can, it quickly becomes unhelpful and patronising, in a weird sort of way.&quot;"
slug = "in-review-scenes-from-the-end"
title = "In review: Scenes from the End"
+++

Watching Héloïse Werner perform *Scenes from the End*, a one-woman opera composed by Jonathan Woolgar and brilliantly directed by Emily Burns, was something we'd been anticipating for some time now. After going up at the Camden and Edinburgh Fringe Festivals, [*Scenes from the End*](https://www.tristanbatestheatre.co.uk/whats-on/scenes-from-the-end) has kicked off its London run, playing at the [Tristan Bates Theatre until December 10.](https://www.tristanbatestheatre.co.uk/whats-on/scenes-from-the-end)

"Over the past few years, I have experienced grief. It's impossible to rationally 'describe' your experience of grief because death is absurd," writes Werner in her performer's notes. "When you lose someone, you find yourself surrounded by people who never talk to you about it - not in person anyway - because they simply can't. Or, if they think they can, it quickly becomes unhelpful and patronising, in a weird sort of way."

Grief is the thread that connects the three parts of *Scenes from the End*; part I grieves for the universe, part II for humanity, and part III for a single person. With extraordinary skill, Werner morphed into countless people, some of them archetypes, and some who felt specific and familiar. Her voice holds huge power and broad options; though it was entirely enmeshed in what we saw, Werner's singing left a deep impression.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481107427127/2016-12-7---Scenes-from-the-End-Heloise-Werner-5.jpg.jpg)
<figcaption>Héloïse Werner in *Scenes from the End*, 2016. Photo by Nick Rutter.</figcaption>
</figure>

Woolgar took great care with form in his writing; his aesthetic is a pleasing mix of organic, singer-friendly, and surprisingly disjunct. There were no risible attempts at "mimicking" grief, instead choosing to tell one person's subjective story of her grieving process. Werner's performance was polished and clearly well-constructed; still, there was a sense of spontaneity, even a sense of humour that kept *Scenes from the End* from being utterly dreary.

Werner sang about big ideas: the vastness of the universe, the smallness of humans, climate change, overpopulation, and whether or not there's anyone/anything greater than us who cares when we die. She seemed to satirize the miniscule moments of pride and importance that all people feel, chipping away at our fears about death and meaninglessness. In part III, her storytelling was reduced to silence; she, the grieving person, took us through a devastating, one-sided conversation with those who try to comfort her. Her amazing, chameleon-like face reflected back to us the familiar feelings of disgust, anger, bewilderment, injustice, and loss. It was the best kind of discomfort, to feel Werner's unimpressed eyes boring back at the audience.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481107435815/2016-12-7---Scenes-from-the-End-Heloise-Werner-10.jpg.jpg)
<figcaption>Héloïse Werner in *Scenes from the End*, 2016. Photo by Nick Rutter.</figcaption>
</figure>

*Scenes from the End* is a dense, exhaustive evening, beautifully wrapped in a clean, mobile performance. Go see it! Tickets are a mere £10, and shows run nightly until December 10 (including post-show talks on December 8 and 9). For full details and ticket information, [click here.](https://www.tristanbatestheatre.co.uk/whats-on/scenes-from-the-end)
