+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-04-18T12:27:00+01:00"
lastmod = "2017-04-18T12:44:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492515230628/2017-04-18---London-Handel-Players.jpg.jpg"
publishDate = "2017-04-18T12:44:00+01:00"
related_articles = ["articles/in-review-kitty-whately-joseph-middleton-at-wigmore-hall.md","articles/in-review-classical-operas-il-vologeso.md"]
related_people = ["scene/people/rowan-pierce.md"]
short_description = "The London Handel Players gave us a fresh program of Telemann and Handel, showing us the very long lasting friendship and musical relationship between the two composers. Adrian Butterfield opened the concert by sharing the story of these two law students who much preferred composing music to studying the law - and if you had a musical brain that produced the Messiah, wouldn’t you drop out of law school, too?"
slug = "in-review-rowan-pierce-the-london-handel-players"
title = "In review: Rowan Pierce &amp; the London Handel Players"
+++

Easter is officially over, Christ is risen, and tons of musicians have been performing Bach for the past month. Passion after Passion, St. Matthew after St. John, we are reminded of the quality and quantity of work J.S. Bach composed during his lifetime. Indeed, the big composers of the eighteenth century seem to have written so much work, some of it tends to get lost - minor works by major composers have to fight for the limelight in an early music world dominated by the *Giulio Cesares* and Bach *Magnificats* of the time.

How remarkable is it that during Bach's time, Germany gave us not just one but three composers whose work lists boast a huge quantity and beautiful quality? Georg Philipp Telemann and George Friederic Handel complete the trifecta of German composer-idols, and on Easter Monday we heard a performance of chamber music from both composers given by the London Handel Players at Wigmore Hall.

The London Handel Players gave us a fresh program of Telemann and Handel, showing us the very long lasting friendship and musical relationship between the two composers. Adrian Butterfield opened the concert by sharing the story of these two law students who much preferred composing music to studying the law - and if you had a musical brain that produced the *Messiah*, wouldn’t you drop out of law school, too?

It was easy to spot harpsichordist Laurence Cummings as the backbone of the ensemble, who so masterfully used his articulate continuo playing to shape the playing of the instruments around him. There was truly elegant playing from Adrian Butterfield on violin and Rachel Brown on flute. During the first aria of Telemann's Cantata, "Wandelt in der Liebe," there was such a beauty in the simplicity of their unison playing. This elegance was very welcome, as Handel and Telemann’s music can be stereotyped into something fanciful and faffy - "too many notes."

The real star of the evening was Argentinian gambist Juan Manuel Quintana. With every line that rang out of his instrument we were lifted higher. His phrases soared above the rest of the music in a beautiful timbre we rarely get to enjoy. Quintana truly sparkled throughout the gamba obbligato in Handel's Cantata "Tra le fiamme," his sound representing fire, flight, and joy in the story of Daedalus and Icarus. When Quintana ornamented, we heard inspired and purposeful new music, which gives us hope that this music will continue to stay alive after hundreds of years.

Quintana's ornaments and Cummings' continuo are certainly two ingredients vital in the recipe for keeping early music healthy and relevant. These two factors were so important during the time of Handel and Telemann, and they have the power to make each performance of the same piece radically different and exciting.

Soprano [Rowan Pierce](/scene/people/rowan-pierce/) is clearly a very intelligent singer, and her strong sense of musicality serves this music well. We hope that as her singing develops she becomes daring enough to show an amount of her own dramatic interpretation into performing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492515266443/2017-04-18---Rowan-Pierce-Groves-Artists.jpg.jpg)
<figcaption>Rowan Pierce, soprano. Photo courtesy of Groves Artists.</figcaption>
</figure>

While the lawyers of this world are important, we thank the stars above that Telemann and Handel decided to do away with "serious" profession in order to give us the gift of these cantatas in their huge outputs of work. We also encourage people to keep looking for those hidden gems of these composers while enjoying the greatest hits.

