+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-05-30T10:06:00+01:00"
lastmod = "2016-05-30T16:54:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464599839586/2016-05-31---RHW-L-to-R-top-to-bottom-Keith-Klassen-as-Oscar-Peter-McGillivray-as-Bassett-Asitha-Tennekoon-Stephane-Mayer-Aaron-Durand-Sean-Clark-Elaina-Moreau-Erica-Iris.jpg.jpg"
primary_image_credit = "A scene from Tapestry Opera's production of Rocking Horse Winner. Photo: Dahlia Katz."
publishDate = "2016-05-30T10:24:00+01:00"
related_articles = ["articles/dont-miss-rocking-horse-winner.md","articles/in-review-mdea-undone.md","articles/in-review-the-devil-inside.md","articles/new-operas-craig-bohmlers-riders-of-the-purple-sage.md","articles/dont-miss-glory-denied-at-nashville-opera.md","articles/dont-miss-naomis-road.md","articles/crosscanada-opera-the-overcoat-comes-to-toronto-vancouver.md","articles/oksana-g-its-so-out-of-this-world-and-yet-so-realistic.md","articles/tough-to-watch-oksana-g.md","articles/cosmic-grandeur-and-human-frailty-crossing.md","articles/materialism-turns-tragic-dont-miss-the-overcoat.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/asitha-tennekoon.md","scene/people/carla-huhtanen.md","scene/people/peter-mcgillivray.md","scene/people/keith-klassen.md","scene/people/michael-mori.md","scene/people/jordan-de-souza.md","scene/people/anna-chatterton.md"]
short_description = "As the autistic son, Paul, Asitha Tennekoon is a revelation. His beautiful leggiero tenor was perfect for playing the delicate Paul. It bridged the gap between full Mozart opera and contemporary musical theatre. But to be honest, his acting is the reason to see this show. I&#039;ve been watching Asitha grow as a performer over the last couple of years and I have to say that this could literally be a breakout role for this young man. It was endearing, truthful, and raw. "
slug = "in-review-rocking-horse-winner"
title = "In review: Rocking Horse Winner"
+++

On one of the hottest days Toronto has seen so far in 2016, I tore myself away from a patio in the distillery district - anyone who lives in Toronto knows how hard that is to do on a hot Saturday afternoon - and made my way through the Old Town of York over to the Berkeley Street Theatre for [Tapestry Opera](/scene/companies/tapestry-opera/)'s *Rocking Horse Winner*.

It's an exciting night that calls for a cool glass of white whine. My guest and I dressed in our flouncy summer brights made our way into the theatre to find our amazing seats.\*

We walked into the pianist on one side of the stage and the string quartet comprising the rest of the orchestra on the other with Tapestry Opera Resident Music Director [Jordan de Souza](/at-the-podium-jordan-de-souza/). As we made our way to our seats, the music provided in the house was improvisational in nature, and helped fill the air with the idea that this house (where the show is set) is one of comfortable affluence. 

Camelia Koo's set is dark and fairly sparse. The few furnishings you see suggest a deal of comfort. The delicate wooden table and chairs, a crystal decanter and sherry glasses. We see an upper balcony as well giving us the impression that the house this takes place in has a grandeur. The choice to have all of this set pushed up directly to the proscenium made it a very imposing presence, which paralleled the pressure we were about to see coming down on the quartet of characters. 

The setting of D. H. Lawrence's short story as an opera worked remarkably well. The shorter format of the original medium provided an already trimmed-down source, and lent the whole piece an organic, yet not frenetic pace. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464599911517/2016-05-31---RHW--Elaina-Moreau-Asitha-Tennekoon-Paul-Erica-Iris---Photo-Credit-Dahlia-Katz.jpg.jpg)
<figcaption>l-r: Elaina Moreau, Asitha Tennekoon (Paul), Erica Iris. Photo: Dahla Katz.</figcaption>
</figure>

Dora Award-winning playwright [Anna Chatterton](/dont-miss-rocking-horse-winner/) provided a fantastic adaptation of Lawrence's original text. The dialogue that she gave in particular to the character of Paul, kept his character from being a wholly tragic figure. It made him incredibly affable, lovable and when it all goes down in the denouement, you really feel the tragedy that much more intensely. Her choice to update the original character of Paul - originally a little boy - to a teenager with autism was a smart choice to highlight why the mother would have such a toxic relationship with her son, while not completely vilifying her.

Gareth Williams's score is breathtaking. I felt like for the first time I was hearing to where opera should be moving. It had a lot of moments that were reminiscent of contemporary musical theatre, but even those moments were elevated by the difficulty of the vocal lines - even though they were still incredibly singable. I felt like I was listening to the the love-child of a three-way between Samuel Barber, Stephen Schwartz, and Jason Robert Brown. I think my favourite part was actually the opening. In the place of a classical overture, we had the chorus singing a fantastic quartet and presented an amazing cuckoo-clockwork pantomime prologue, shadowed behind a scrim telling the prologue of the story of the mother, Ava, and Paul's absentee father.

As the conflicted mother, Ava, who has extreme difficulty loving her child due to the circumstances of his autism and the abandonment of his father, we see some amazing work by soprano [Carla Huhtanen](/scene/people/carla-huhtanen/). Her crystalline voice, at the same time light, clear and strong, married perfectly with Williams' score. She opens the show taking her place at the piano, singing a sad song about how this wasn't the way things were supposed to go. Her portrayal of the disenchanted, abandoned housewife was layered, intelligent, informed and honest. This is some of the best work I've seen Carla do yet, and that's saying something. 

As the autistic son, Paul, [Asitha Tennekoon](/scene/people/asitha-tennekoon/) is a revelation. His beautiful leggiero tenor was perfect for playing the delicate Paul. It bridged the gap between full Mozart opera and contemporary musical theatre. But to be honest, his acting is the reason to see this show. I've been watching Asitha grow as a performer over the last couple of years and I have to say that this could literally be a breakout role for this young man. It was endearing, truthful, and raw. Coupled with his flawless singing, you couldn't have asked for any more - on any stage - anywhere. 

As the somewhat smarmy uncle Oscar, [Keith Klassen](/scene/people/keith-klassen/)'s brassy tenor worked really well for this high lyrical theatre style that came out of this score. His roguish good looks and cavalier, debonair physicality were a total treat to see in this highly intense scenario. His portrayal of the catalyst of Paul's demise was truthful, and for a while you're actually supporting his (essentially) exploitation of Paul because you saw it as a means to the end that they're all searching for (and one you want them to attain). It's not until you see them actually at the races that you see the danger in what he's doing. Klassen's careful reveal of his ulterior motives is thrilling. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464599953105/2016-05-31---RHW--Asitha-Tennekoon-as-Paul---Photo-Credit-Dahlia-Katz.jpg.jpg)
<figcaption>Asitha Tennekoon as Paul. Photo: Dahlia Katz.</figcaption>
</figure>

As Basset, baritone [Peter McGillivray](/talking-with-singers-peter-mcgillivray/) gave us another of his animated performances that keeps you drawn in without pulling the focus - it's a tough balance to master as the comprimario in a show, but he does it with aplomb. His full baritone voice added a paternal quality to his character that leads you to believe that he really does have Paul's best interest at heart. It's not until the very end when you see him get steamrolled by Oscar's desire for wealth that you realize he's not as strong a personality in the household as he (and you) maybe thought he was. 

As the voices of the house, whom only Paul can hear, the quartet of Elaina Moreau, Erica Iris, Sean Clark, and Aaron Durand was clean, beautiful and incredibly precise on the diction front. Their work behind the scrims was chilling and exhilarating. The eerie quality they displayed kept the angst of the play present, and kept showing up at just the right moments - which means, just as the audience was getting comfortable in the scene.

The creative use of the space and a score that sounds like nothing you've heard on any opera stage are only two of the plethora of reasons to see this show. Tennekoon's portrayal of Paul is worth the price of admission alone. *Rocking Horse Winner* runs until June 4th, and you can get your [tickets here](https://tapestryopera.com/rocking-horse-winner/). 

Congratulations to Tapestry Opera on yet another thrilling season of new opera. I firmly believe that having a company like this in Toronto, led by the likes of [Michael Hidetoshi Mori](/scene/people/michael-mori/) (who ably directed this beautiful piece of theatre), is not only proof that our community and industry is in great shape, but it's also headed in the right direction. 

\#BraviTutti!

\*I just want to say - thank you to all the amazing Toronto companies who this year have given us some of the bests seats I've ever had at the theatre. Mille grazie!
