+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-05-01T08:30:00-04:00"
lastmod = "2015-04-23T21:19:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429838384029/1121-Elisabetta-Credit-Michael-Cooper-673x1024.jpg.jpg"
primary_image_credit = "All photos by Michael Cooper"
publishDate = "2014-05-01T08:30:00-04:00"
related_articles = ["articles/dont-miss-sondra-radvanovsky-at-koerner-hall.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/sondra-radvanovsky.md","scene/people/russell-braun.md","scene/people/allyson-mchardy.md"]
short_description = "Since the dress rehearsal of the Canadian Opera Company&#039;s Roberto Devereux, my Facebook and Twitter feeds have been flipping out about American soprano Sondra Radvanovksy&#039;s performance as Queen Elizabeth I. So I was really eager to see it for myself."
slug = "in-review-roberto-devereux"
title = "In review: Roberto Devereux"
+++

Since the dress rehearsal of the Canadian Opera Company's [_Roberto Devereux,_](http://www.coc.ca/PerformancesAndTickets/1314Season/RobertoDevereux.aspx) my Facebook and Twitter feeds have been flipping out about American soprano [Sondra Radvanovksy](http://www.sondraradvanovsky.com/)'s performance as Queen Elizabeth I. So I was really eager to see it for myself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429837868851/0187-Sara-and-Elisabetta-Credit-Michael-Cooper-1024x681.jpg.jpg)
<figcaption>Allyson McHardy and Sondra Radvanovsky. Photo by Michael Cooper.</figcaption>
</figure>

[Stephen Lawless](http://www.askonasholt.co.uk/artists/directors/stephen-lawless) directed this production of Donizetti's setting of this story of Elizabeth I, and he took advantage of the Queen's notorious love of the English arts, including her patronage of William Shakespeare. And so the curtain rose on [Benoît Dugardyn](http://www.b-dugardyn.be/)'s sets, which clearly and artfully suggested an Elizabethan theatre; the effect was that of a constant stage-within-the-stage, and yet it translated well from scene to scene. It never felt like a "concept" that had been stretched too far. Completing Lawless' vision were exquisite costumes by designer Ingeborg Bernerth. It was a grand feast on the eyes, fit for a Queen, really.

The overture was all I needed to be on board with this production. Lawless staged a sequence that's best described as an operatic version of _Here's Your Life_, showing historical highlights from the life of the Queen. With swift, clean transitions, we saw mini-scenes, of Elizabeth's attendance at the premiere of Shakespeare's _A Midsummer Night's Dream_, of her defeat of the [Spanish Armada](http://en.wikipedia.org/wiki/Spanish_Armada), etc. It was cool, not corny, and it set an organic precedent for the use of the stage-within-stage for the whole show.
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429837927115/0823-centre-Elisabetta-and-Roberto-Devereux-Credit-Michael-Cooper-1024x665.jpg.jpg)
<figcaption>Sondra Radvanovsky, Leonardo Capalbo, Russell Braun. Photo by Michael Cooper.</figcaption>
</figure>

As Elizabeth I, Sondra Radvanovsky truly was spectacular. Her voice was beautifully raw, and seemed to have endless force as she scaled huge ranges with fierce energy and complete control. She had a determined resonance in her highest register, shattering the theatre with her gloriously powerful instrument. It sounds trite, maybe, but she reminded me of Maria Callas, that relentless sound that's so exciting and vulnerable. I especially loved her singing in the context of her portrayal of Elizabeth I. Sondra and Stephen Lawless found moments to show the Queen's human frailty, like when she motioned for help climbing a step, and then angrily waved her aides away, as if offended by their offering of their arm. It was wonderfully effective to hear Sondra's powerful voice, showing us that Elizabeth I was weak in body, perhaps, but she was still a strong, smart, terrifying leader. Hers was a thrilling performance for me to see, and I don't think I'll ever forget it.

Canadian mezzo-soprano [Allyson McHardy](http://www.allysonmchardy.com/) sang the role of Sara, the Duchess of Nottingham and the unfortunate rival of the Queen. I really like Allyson's singing, and this was the first time I've heard her in a _bel canto_ role like this. I thought she was a beautiful foil to the fierce, volatile Queen; she was poised and classy, with expressive singing that helped the audience warm to her character. She didn't seem entirely comfortable in her top register, and the role seemed to lie in an irritating spot for most mezzos. But, I thought she paced the role well, finding moments of lightness in the trickier bars. I thought she portrayed Sara as a victim of circumstance, and it just helped make the Queen seem that much more of a wild card.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429838006167/0489-490-Roberto-Devereux-and-Sara-Credit-Michael-Cooper-720x1024.jpg.jpg)
<figcaption>Leonardo Capalbo and Allyson McHardy. Photo by Michael Cooper.</figcaption>
</figure>

Italian-American tenor Leonardo Capalbo sang the role of Roberto Devereux; originally it was to be Giuseppe Filianoti, but there was a semi-last-minute change, and Leonardo is singing the first four performances. (Filianoti returns starting on May 10th.) Leonardo sang with a full tone and plenty of defiance in his voice; I found him less polished  in comparison to his co-stars. He was hooking a lot, and the vibrato tended to get wild, and he was often under-pitch. It's a hard thing to share the stage with Sondra Radvanovsky, but I didn't think Leonardo really used his voice to tell his story; I thought he tried to physicalize a lot of his dramatic moments, and it simply translated into some vague singing, and in this kind of music, it's never worth throwing off one's ability to sing.

Cornerstone Canadian baritone [Russell Braun](http://www.russellbraun.com/) sang the Duke of Nottingham, the poor guy whose wife, Sara, cheats on him with his friend, Roberto. Russell's warm, benevolent voice gained him sympathy as the Duke, and he had a stoic presence onstage that set us up beautifully for his eventual desire for revenge against all the liars around him. I love hearing Russell sing; I don't think this was a good role for him. He seemed to be working hard in the wrong way, perhaps trying to produce a louder sound, or one that's more like a dramatic baritone. The result was a pressurized sound that made him creep sharp a times, and didn't always cut over the orchestra. Russell is an intensely expressive singer, and I feel that he didn't allow his expression all to come simply from his voice.  It's true that Russell's voice doesn't resonate the same way most _bel canto_ baritones do, but I love his naturally rich, haunting sound. I'd be truly curious to hear what it would sound like if he simplified his performance and let his voice take over.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429838056788/0302-Elisabetta-Credit-Michael-Cooper1-681x1024.jpg.jpg)
<figcaption>Sondra Radvanovsky as Queen Elizabeth I. Photo by Michael Cooper.</figcaption>
</figure>

Small roles were well-sung, and I thought there was good attention to detail in their presence onstage, despite having few lines to sing. American bass [Matt Boehler](http://www.mattboehler.com/) was solid as Sir Gualtiero Raleigh, and sufficiently creepy along with tenor [Owen McCausland](http://www.coc.ca/ExploreAndLearn/NewToOpera/OnlineLearningCentre/ParlandoTheCOCBlog.aspx?EntryID=24213) as Lord Cecil. Owen sounded great in this role; it was small, but it showed him off well. Bass-baritones Gordon Bintner and Neil Craighead were brief but memorable as a Page and Nottingham's servant.

The COC Orchestra sounded fantastic as usual, this time under the baton of Italian conductor [Corrado Rovaris](http://www.opus3artists.com/artists/corrado-rovaris). I thought there was plenty of that elastic Italian rhythm, and lots of love for the singers' cadenzas. The COC Chorus was also dynamite, including some really cool, almost geometric staging moments in the tiers of the "Elizabethan Theatre".

I thought the show was a definite success, despite any of my personal thoughts on the singers. Sondra Radvanovsky is a rare artist, and you should _absolutely_ try and go hear her while she's in town. It's a beautiful production that is packed with fascinating history, the kind that serves up a great story. _Roberto Devereux_ plays until May 21st. For details and tickets, visit the www.coc.ca, or click [here](http://www.coc.ca/PerformancesAndTickets/1314Season/RobertoDevereux.aspx).
