+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-10-27T14:53:00-04:00"
lastmod = "2015-10-28T16:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445980520412/QuinnKelseyRecital.jpg.jpg"
publishDate = "2015-10-28T12:29:00-04:00"
related_articles = ["articles/lieder-for-lunch-the-coc-ensemble-studio-in-recital.md","articles/in-review-a-shropshire-lad.md","articles/hat-trick-in-the-amphitheatre.md","articles/in-review-paul-appleby-at-wigmore-hall.md","articles/being-a-nice-person-why-art-really-really-matters.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/quinn-kelsey.md"]
short_description = "Hawaiian baritone Quinn Kelsey strode into the Richard Bradshaw Amphitheatre, wearing black cowboy boots with his three-piece suit, and said to the audience, &quot;I apologize in advance for cheat sheets.&quot;"
slug = "in-review-quinn-kelseys-songs-from-the-heart"
title = "In review: Quinn Kelsey&#039;s Songs from the Heart"
+++

Hawaiian baritone [Quinn Kelsey](/scene/people/quinn-kelsey/) strode into the [Richard Bradshaw Amphitheatre](https://www.google.com/analytics/web/?hl=en#report/visitors-overview/a46647120w77702325p80325527/), wearing black cowboy boots with his three-piece suit, and said to the audience, "I apologize in advance for cheat sheets."

He's preparing for his debut at [Wigmore Hall](https://wigmore-hall.org.uk/whats-on/rosenblatt-recitals-201511111930) in November, and this week's programme, with Rachel Andrist at the piano, was somewhat of a sneak peek. In Quinn, I sensed some of the nerves that are common to singers who spend much of their professional lives on large stages; compared to a vast, dark opera house, the light-filled, acoustically raw Amphitheatre is an intimidating venue.

I forgave him for his "cheat sheets" pretty quickly, since Quinn's sound is one of the most beautiful baritone voices singing today. For weeks, I have been looking forward to hearing him at a closer distance, without the bells and whistles of productions like the COC's current [*La traviata*](http://www.coc.ca/PerformancesAndTickets/1516Season/LaTraviata.aspx), in which Quinn sings Giorgio Germont. He chose two English sets, Vaughan Williams' *Songs of Travel* and Finzi's *Let Us Garlands Bring*, plus a few Brahms songs (including a "Von ewiger Liebe" that was "kick-ass," to quote a nearby audience member). It was repertoire that showed Quinn's intuitive musicianship and honest delivery.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446063921600/kelsey-headshot--new.jpg.jpg)
<figcaption>Quinn Kelsey, baritone. Photo by Ken Howard.
</figcaption>
</figure>

With nowhere to hide, Quinn sounded in beautiful vocal shape, using nothing but sound to get across each nuance. He had a huge range of sound, and sang through the loud as well as the soft. His text was totally accessible; when I'm provided translations for English rep, I usually try to listen rather than read. This was impressively easy from Quinn, whose sound is a gorgeous mix of speechlike and lyrical. I never worried for him, and he kept surprising me with new colours. At the piano, Rachel Andrist was a sympathetic partner, enjoying the gorgeous piano writing in those English sets. I could have used a bit more of a soloistic personality in the Brahms, especially for a voice of Quinn's ilk.

He had a curious bit of disconnection from the audience, with assymetrical body language and little interaction with the audience outside of his singing. At the same time, it was easy to get pulled in to Quinn, who at times felt as though he was staring right back at his rapt audience. I chalked up the dichotomy to those recital nerves I mentioned above, which in Quinn's case, are actually quite endearing.

Quinn returned for an encore, "Questo amor, vergogna mia" from *Edgar* (one of the few good Puccini arias for baritone, he lamented). Maybe it was a familiar aria, maybe it was the gorgeous Italian, or maybe it was the operatic element that made him audibly more comfortable. I was impressed by Quinn's obvious connection to the easy beauty of the rep he chose, and by the mature, voice-first approach he took even in the Amphitheatre's intimacy.

>For details on Quinn Kelsey's Rosenblatt Recital with pianist Llŷr Williams, follow the box office links below.

