+++
author = ["authors/jenna.md"]
date = "2014-04-27T19:08:00-04:00"
lastmod = "2015-04-27T18:06:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429838235315/ChrisandMireille-1024x974.jpg.jpg"
primary_image_credit = "Christopher Enns and Mireille Asselin in Opera Atelier's Persée. Photo by Bruce Zinger."
publishDate = "2014-04-27T19:08:00-04:00"
related_people = ["scene/people/aaron-ferguson.md"]
short_description = "Ah, Opera Atelier. As far as Canada&#039;s opera scene goes, OA is really its own genre. For those unfamiliar, Opera Atelier produces 17th- and 18th- century ballet/opera; the shows are directed and choreographed by co-artistic directors Marshall Pynkoski and Jeannette Lajeunesse Zingg."
slug = "in-review-perse"
title = "In review: Persée"
+++

Ah, Opera Atelier. As far as Canada's opera scene goes, OA is really its own genre. For those unfamiliar, Opera Atelier produces 17th- and 18th- century ballet/opera; the shows are directed and choreographed by co-artistic directors [Marshall Pynkoski](http://www.operaatelier.com/about/creative-team/) and [Jeannette Lajeunesse Zingg](http://www.operaatelier.com/about/creative-team/). I go to Opera Atelier shows because it's a chance for me to see and hear operas from this period, presented by artists who know what they're doing; under conductor [David Fallis](http://barczablog.com/2012/10/12/10-questions-for-david-fallis/), the [Tafelmusik Baroque Orchestra](http://www.tafelmusik.org/) is often in the pit, so that's a great start. Last night was opening night of Jean-Baptiste Lully's [_Persée_](http://www.operaatelier.com/season/13-14/persee/), based on the [Greek myth of Perseus](http://www.greekmythology.com/Myths/Heroes/Perseus/perseus.html) and his shenanigans with [Medusa](http://www.greekmythology.com/Myths/Creatures/Medusa/medusa.html), the lady with snakes for hair. With Zingg's complementary choreography (the artists of the Atelier Ballet were beautiful) and [Gerard Gauci](http://barczablog.com/2011/10/23/10for_gg/)'s truly impressive sets, this production of _Persée_ was great on the eyes as well as the ears.

Marshall Pynkoski uses the device of [Baroque rhetorical gesture](http://www.operaatelier.com/education/opera-lovers/about-the-art/acting/) in his productions. I'm by no means an expert, but the short history is that the gestures were designed to accompany a word or a sentiment in the text, to add to its affect. It's a stylistic choice that has function. Pynkoski works with many of the same singers in each of his productions, and I'm sure it makes for a smoother rehearsal process if more people in the room are starting from the same point of aesthetic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429838248376/Gorgons-1024x756.jpg.jpg)
<figcaption>l-r: Lawrence Wiliford, Curtis Sullivan, Olivier LaQuerre, Aaron Ferguson. Photo: Bruce Zinger.</figcaption>
</figure>

_Persée_ is a piece I didn't know prior to seeing it last night, and it reminded me of my impression of [_Hercules_](/in-review-hercules/) at the COC, in that the show is much more about the ensemble of cast members than simply the title character. The cast was made up of plenty of great Canadian talent, including tenor [Chris Enns](http://www.deanartists.com/vocal/tenor/christopher-enns) in title role. I thought he suited the hero well; his voice is sweet yet decisive, and he made it clear to the audience that Persée is a lover _and_ a fighter. This is Chris' debut with Opera Atelier, but he looked comfy and seasoned up there, including the gestures and postures in which OA veterans find themselves in their sleep. I know Chris, and I got a kick out of his "dancer double," who took Chris' place during the particularly balletic moments of Perseus' battles (I checked the program, and saw there were actually two: [Tyler Gledhill](http://www.thedietrichgroup.com/about/biographies/tyler-gledhill-dance-artist/) and [Brett Van Sickle](http://national.ballet.ca/thecompany/firstsoloists/Brett_van_Sickle/)).

As Andromède, the princess who loves Persée (he loves her back, don't worry), soprano [Mireille Asselin](http://www.mireilleasselin.com/) was lovely. I always enjoy hearing her sing, and this was a great role for her graceful demeanour. I thought Mireille portrayed Andromède with a balance of royal duty and human vulnerability. She sang with huge amounts of expression, and really showed that this style of opera is much closer to a play, perhaps, than to our modern notion of "opera".

Soprano [Peggy Kriha Dye](http://columbusblack.com/index.php?option=com_content&view=article&id=320:peggy-kriha-dye-named-general-manager-of-opera-columbus&catid=36:news) was a highlight onstage as Mérope, who also loves Persée (he doesn't love her back, oops). She sang beautifully and tragically, and she immediately had the audience on her side, despite the plot of the opera. I was impressed by her dramatic arc; it's a complicated thing to play the rival of a heroine, without playing a villainess. She broke my heart with her story of unrequited love, and her duet that Mérope sings with Andromède was, as a result, really stunning.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429838327878/Persee-1024x580.jpg.jpg)
<figcaption>Photo by Bruce Zinger.</figcaption>
</figure>

As the true villain in the story, Phinée (who loves Andromède, but knows she doesn't love him back), [Vasil Garvanliev](http://imgartists.com/artist/vasil_garvanliev) was brooding and wonderfully jealous. Phinée. His unpredictable, angular style of gesture went perfectly with his dark, mean-sounding singing. Vasil's physical presence onstage was what I really loved; I wished that his voice had projected a bit more, but his intentions were always made clear with his postures.

As Queen Cassiope, Andromède's mother, soprano [Carla Huhtanen](http://www.carlahuhtanen.com/) was great. She sounded clear and expressive, and was compelling to watch, even when she sang from one of the boxes flanking the stage. I was less impressed with bass-baritone [Olivier LaQuerre](http://www.olivierlaquerre.com/en/Baritone/Home.html) as King Céphée. I had real trouble hearing him, and he seemed a bit stiff rather than stately.

Olivier appeared again as Méduse, the lady Gorgon. Maybe dressing in drag helped him get into character or something, but the voice sounded more free and he sounded like he was having fun. I'll confess that I don't know the real history of this role, but I wasn't expecting a gender-crossing character for Medusa. Pynkoski made a comedy scene out of Medusa and her Gorgon sidekicks (played by Aaron Ferguson and Curtis Sullivan). It was a funny scene, for sure; Olivier, Aaron and Curtis, all dressed in Greek-mythology-drag, talking about how poor Medusa used to be beautiful, but now she's hideous.  I just thought it was a weird scene to choose for the one moment of comedy in the piece; in the previous act, there was lots of build-up about how dangerous it would be for Perseus to go to Medusa's cave (or whatever). But the scene was well done, with beautiful and hilarious ensemble singing by all three Gorgon "ladies".

The supporting cast often did double or triple duty with the many small roles in this show. Tenor [Lawrence Wiliford](http://www.lawrencewiliford.com/) sang Corite and Mercure. I loved him as Mercury, with gorgeous, agile singing that matched his nimble movements around the stage. Bass-baritone [Stephen Hegedus](http://www.stephenhegedus.com/) sang Proténor and Divinité Infernale; his was some of the best singing of the night, and he wins my vote for best costume of the night (by costume designers Dora Rust-D'Eye and Michael Legouffe). Soprano [Meghan Lindsay](http://www.meghanlindsay.com/) was striking both in her role as Nymphe Guerrière and as Vénus. She sang with an effortless, ringing tone, and she had stage presence that showed she was a veteran of the Opera Atelier stage. Baritone [Curtis Sullivan](http://www.deanartists.com/vocal/bass-baritone/curtis-sullivan) was the busiest singer in the cast with four roles: the Grand Prêtre, Cyclope, Sténon and Triton. I've seen Curtis in other shows at Opera Atelier during his long relationship with the company; physically, I understand why Marshall Pynkoski continues to hire Curtis, but I've never been impressed with him vocally.

Jeannette Lajeunesse Zingg's choreography was beautiful, and I thought it was the first time that the movements and gestures used by the dancers were in part shared by the singers in the cast. A piece like _Persée_ could be done with dances that are entirely disconnected from the action of the plot; here, I felt they were more complimentary to the affect of the story.

Conductor David Fallis beautifully led the Tafelmusik Baroque Orchestra and Chamber Choir through Lully's score. I'm no Early Music expert, but I thought the Chamber Choir sounded the best I'd ever heard them, and the orchestra really sounded fantastic. I had fun keeping an eye on the duelling continuo sections on opposite ends of the orchestra; at times, each continuo section accompanied a specific character onstage. Neat.

There are a lot of things about Opera Atelier that frankly aren't my cup of tea. But any objections I have really boil down to style and taste, and perhaps a difference in opinion about the function of opera. I'm someone who looks forward to the continuous evolution of opera as a theatrical genre (not just a musical one), including finding ways of keeping it relevant in the present. I suppose Marshall Pynkoski does the same, by presenting these works from the early years of opera's history, showing us that theatre, movement and opera were never meant to be separate entities.

_Persée_ continues at the Elgin Theatre until May 3rd; for full details and to buy tickets, click [here](http://www.operaatelier.com/season/13-14/persee/).
