+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-03-05T13:56:00+00:00"
lastmod = "2016-03-06T15:52:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457188176933/2016-03-05---Wigmore-Hall.jpg.jpg"
publishDate = "2016-03-05T15:15:00+00:00"
related_articles = ["articles/in-review-sondra-radvanovsky-at-koerner-hall.md","articles/in-review-dmitri-hvorostovsky-at-koerner-hall.md","articles/in-review-quinn-kelseys-songs-from-the-heart.md","articles/paul-appleby-telling-stories-at-wigmore-hall.md","articles/ian-rosenblatt-its-all-about-the-voice.md","articles/in-review-javier-camarena-at-wigmore-hall.md","articles/in-review-bryn-terfel-at-koerner-hall.md","articles/in-review-chris-thile-at-wigmore-hall.md","articles/in-review-kitty-whately-joseph-middleton-at-wigmore-hall.md","articles/fierce-recitals-karita-mattila-at-wigmore-hall.md"]
related_people = ["scene/people/paul-appleby.md"]
short_description = "It&#039;s noteworthy when a singer, in the midst of a busy schedule on the opera stage, is equally dedicated to his work in recital. Tenor Paul Appleby is a thoughtful artist, and he seems to relish the chance not only to tell many small stories in one sitting, but to collect them into a larger story arc of his own creation."
slug = "in-review-paul-appleby-at-wigmore-hall"
title = "In review: Paul Appleby at Wigmore Hall"
+++

It's noteworthy when a singer, in the midst of a busy schedule on the opera stage, is equally dedicated to his work in recital. Tenor [Paul Appleby](/scene/people/paul-appleby/) is a thoughtful artist, and he seems to relish the chance not only to tell many small stories in one sitting, but to collect them into a larger story arc of his own creation. While we wouldn't have been opposed to hearing arias from some of Appleby's signature roles like Ferrando (*Così fan tutte*) and Tom Rakewell (*The Rake's Progress*), it's impressive that he stayed within the confines (broad as they are) of song. 

With [Malcolm Martineau](http://martineau.info/), pianist and ubiquitous recital figure, Appleby offered a programme of selections which had a sum greater than even its parts. Robert Schumann's *Liederkreis* Op. 24, selections from Berlioz's *Les nuits d'été*, and songs by Hugo Wolf, Frank Bridge, and Heitor Villa-Lobos filled Appleby's debut recital at Wigmore Hall; he sang with ease and enviable technical facility, and still the excitement lay in the songs' texts and how he felt about them.

The first half was all German, including the lesser-known setting of Heine's "Das Fischermädchen" by Franz Paul Lachner. The song set up Schumann's *Liederkreis* like an overture, and Martineau expertly left little time before diving into the cycle. From both men, we heard new things in Schumann's score; surprising hidden melodies appeared under Martineau's fingers, and beautiful, text-first choices arose from Appleby. The pacing of the cycle was organic and never schlepped, and by the time we reached the final "Mit Myrten und Rosen" it felt as though they fit into one song all the human reactions to heartbreak and rejection.

A similar arc was built out of the Wolf selections; the Eichendorff texts had much to say about something being desired, and yet being slightly out of reach. Wolf's songs are somewhat of an unsung hero in recitals, but they're dense and precise, packing a punch the way one excellently crafted chocolate truffle does, compared to a big bag of M&M's.

The latter half brought out more voice and gusto from both Appleby and Martineau. Appleby's tenor comes with an enormous palette of colour, including everything from a mixed, floating sound to a full and virile ring. He suited the English songs by Bridge really well, making us want to hear him in some Britten (it's in his repertoire, fear not). The Berlioz were a beautiful change, and his inviting, almost cocky attitude to the final selection, "L'île inconnue", was charming as all get-out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457190875716/Paul-Appleby-High-Res-1---credit-Dario-AcostaResized.jpg.jpg)
<figcaption>Paul Appleby, tenor. Photo by Dario Acosta.</figcaption>
</figure>

If we had to choose a favourite, it would be the three selections by Villa-Lobos. Perhaps it's because Spanish is a comparatively rare pick in recital, but there's something alluring about the sound of Spanish art song. The generous, throatier sound that Appleby used in these songs was totally affecting, and Martineau delivered some thrilling playing. The final song, "Samba clássico" with text by the composer himself, had a beautifully big message, imploring listeners to be kind to each other, despite our differences. Plus, the pair certainly knew how to end with a bang.

They gave two encores, the first of which Appleby sang to satisfy any burning need of the audience's to hear their favourite "Das Fischermädchen", this time by Franz Schubert. For his final post-postscript, he presented the sole selection of American music, a song from John Musto's *Shadow of the Blues: Four songs on poems of Langston Hughes*. The song echoed the sentiments of Villa-Lobos' "Samba", and it was a subtle, understated way to end a polished evening.

It was a total pleasure to hear this duo; they were a lesson in malleability, in listening, in duetting. Appleby is currently on a recital stretch, including one [at Carnegie Hall](http://www.carnegiehall.org/Calendar/2016/3/16/0730/PM/Paul-Appleby-Ken-Noda/), as part of their [125 Commissions Project](http://www.carnegiehall.org/125commissions/), where he'll perform the world premiere of Matt Aucoin's new song cycle, *Merrill Songs*. Hopefully he'll return to Wigmore in seasons to come.
