+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-03-16T09:26:00+00:00"
lastmod = "2017-03-17T10:03:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489656315078/2017-03-16---Square---ENO-Partenope-Sarah-Tynan-Donald-Cooper.jpg.jpg"
primary_image_credit = "Sarah Tynan in the title role of Partenope, English National Opera, 2017. Photo: Donald Cooper."
publishDate = "2017-03-17T09:42:00+00:00"
related_articles = ["articles/in-review-rigoletto-at-eno.md","articles/in-review-the-pirates-of-penzance-at-eno.md","articles/laughing-out-loud-the-barber-of-seville-at-eno.md","articles/a-fierce-mob-wife-rodelinda-at-eno.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/rupert-charlesworth.md","scene/people/patricia-bardon.md","scene/people/sarah-tynan.md","scene/people/james-laing.md","scene/people/stephanie-windsorlewis.md"]
short_description = "There&#039;s no envy on our end for directors who put up Handel operas, and Partenope seems another which poses tricky dramaturgical questions; the biggest of these is the problem fo where these characters are, and why they share a common space. Alden&#039;s open-house concept, where everyone seems to hang out chez Partenope, works well; he finds an organic way to waver between real-time action and inner monologues, as though he hits &quot;pause&quot; and &quot;play&quot; on the general timeline of the story."
slug = "in-review-partenope-at-eno"
title = "In review: Partenope at ENO"
+++

Handel's setting of Silvio Stampiglia's wildly popular libretto, [*Partenope*](https://www.eno.org/whats-on/partenope/), is the best-known of the at least ten operatic versions from the 18th century. Though in his opera she is the Queen of Naples, Partenope is also the name of one of the sirens of Greek mythology, the half-bird, half-human creatures who lured sailors, fatally, with the sounds of their voices.

Mary Beard calls Partenope a "happy and humourous inversion" of Dido, that other queen with many suitors. Handel's opera is a rare piece of comedy, and this Olivier Award-winning production by Christopher Alden mercifully capitalises on what's light and absurd about *Partenope*. Alden brings the action to a world that's vaguely in the 20s, with architectural lines that hearken to 60s mod. The look of the production is heavily inspired by the surrealist work of [Man Ray](https://en.wikipedia.org/wiki/Man_Ray). 

Though it seems arbitrary, the influence works; Partenope becomes idealized in a contemporary way, moving around the stage as though she's constantly posing for a photograph, helped by the stunning silhouettes of Jon Morrell's costumes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489662485635/2017-03-16---ENO-Partenope-Sarah-Tynan-6-Donald-Cooper.jpg.jpg)
<figcaption>Sarah Tynan (Partenope) in *Partenope*, ENO, 2017. Photo by Donald Cooper.</figcaption>
</figure>

[Sarah Tynan](/scene/people/sarah-tynan/) was stunning in the title role. Her voice shimmered with plenty of sex, and (for the most part) an air of "lucky me!" It was easy to see why her four suitors were so slave-like to her whims, yet she stayed likeable at the same time. [Stephanie Windsor Lewis](/scene/people/stephanie-windsor-lewis/) was a true foil to Queen Partenope, as the scorned and jealous Rosmira. She had the tricky task of [playing a woman playing a man](https://store.schmopera.com/products/opera-is-boys-being-girls-being-boys-womens-t-shirt), while sharing the stage with actual trouser roles; she struck a neat balance of being convincing in her "Prince Eurimene", being the beautiful woman whom Arsace regrets leaving, and pouting like a rejected male suitor when things don't go her way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489662514673/2017-03-16---ENO-Partenope-Patricia-Bardon-and-Stehpanie-Windsor-Lewis-2-Donald-Cooper.jpg.jpg)
<figcaption>Patricia Bardon (Arsace) and Stephanie Windsor-Lewis (Rosmira) in *Partenope*, ENO, 2017. Photo by Donald Cooper.</figcaption>
</figure>

[Patricia Bardon](/scene/people/patricia-bardon/) was a strong Arsace, setting him apart as the suitor worthy of Partenope's affections. The strength in her voice was interesting, especially since Arsace's will seems to weaken as the opera progresses. Bardon's Arsace was an easy victory over Armindo, sung sympathetically by [James Laing](scene/people/james-laing/). He used Armindo's pathetic, love-sick nature for some of the biggest laughs in the show - perhaps with the exception of Matthew Durkan as Ormonte - and his singing had thoughtful attention to detail throughout (one can often trust the countertenor for high levels of artistic care).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489662617392/2017-03-16---ENO-Partenope-James-Laing-3-Donald-Cooper.jpg.jpg)
<figcaption>James Laing (Armindo) in *Partenope*, ENO, 2017. Photo by Donald Cooper.</figcaption>
</figure>

[Rupert Charlesworth](/scene/people/rupert-charlesworth/) had the most fascinating presence as Emilio, the suitor with malevolent intent. His voice matched his prowling presence onstage, a snarling power with surprising agility. He sang wicked coloratura with that Richard Croft-like, machine-gun approach, maintaining danger and intrigue.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489662474170/2017-03-16---ENO-Partenope-Rupert-Charlesworth-and-Sarah-Tynan-4-Donald-Cooper.jpg.jpg)
<figcaption>Rupert Charlesworth (Emilio) and Sarah Tynan (Partenope) in *Partenope*, ENO, 2017. Photo by Donald Cooper.</figcaption>
</figure>

There's no envy on our end for directors who put up Handel operas, and *Partenope* seems another which poses tricky dramaturgical questions; the biggest of these is the problem of *where* these characters are, and why they share a common space. Alden's open-house concept, where everyone seems to hang out chez Partenope, works well; he finds an organic way to waver between real-time action and inner monologues, as though he hits "pause" and "play" on the general timeline of the story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489662464600/2017-03-16---ENO-Partenope-Sarah-Tynan-Matthew-Durkan-Patricia-Bardon-James-Laing-and-Stephanie-Windsor-Lewis-Donald-Cooper.jpg.jpg)
<figcaption>Sarah Tynan (Partenope), Matthew Durkan (Ormonte), Patricia Bardon (Arsace), James Laing (Armindo) and Stephanie Windsor-Lewis (Rosmira) in *Partenope*, ENO, 2017. Photo by Donald Cooper.</figcaption>
</figure>

Alden seems to have a list of oddities: gask masks, banana guns, bathroom gags, and magical bra removal. They certainly keep the *da capo* arias from growing tedious, simply because there is always something new and curious to look at. Emilio's hobby as ubiquitous photographer helps put Partenope on her pedestal, and the varied types of masks allude to the constant lies and mistaken identities throughout the story. Indeed, Alden creates a strange world, where people move oddly (helped by the movement direction by Claire Glaskin, revived by Elaine Brown) and behave as though they're actually *in* a surrealist piece of art. But we spent an irritating amount of time trying to figure out what it all meant. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489662447574/2017-03-16---ENO-Partenope-Sarah-Tynan-and-Rupert-Charlesworth-Donald-Cooper.jpg.jpg)
<figcaption>Sarah Tynan (Partenope) and Rupert Charlesworth (Emilio) in *Partenope*, ENO, 2017. Photo by Donald Cooper.</figcaption>
</figure>

Luckily, the ENO Orchestra under Christian Curnyn sounded the best we've heard them, and the cast of singers all showed off extraordinary skills in coloratura and touching moments of subtlety. We craved a tighter pacing between many of the numbers, instead of waiting limply for the applause after every single aria (deserved as it often was). Perhaps more importantly, we wished for more meaning in the singers' musical choices; their ornaments were ingenious and novel, but they often seemed to mean little more than musical variety.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489662730098/2017-03-16---ENO-Partenope-Patricia-Bardon-Sarah-Tynan-and-Stephanie-Windsor-Lewis-c-Donald-Cooper.jpg.jpg)
<figcaption>Sarah Tynan (Partenope), Stephanie Windsor-Lewis (Rosmira) and Patricia Bardon (Arsace) in *Partenope*, ENO, 2017. Photo by Donald Cooper.</figcaption>
</figure>

>Partenope plays at English National Opera until March 24. For details and ticket information, [click here.](https://www.eno.org/whats-on/partenope/)
