+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-10-31T11:59:00-04:00"
lastmod = "2015-10-31T13:07:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446309191963/2015-10-30---OAArmide---Bruce-Zinger---Square.jpg.jpg"
primary_image_credit = "Colin Ainsworth (Renaud) and Peggy Kriha Dye (Armide) in Opera Atelier's Armide. Photo by Bruce Zinger."
publishDate = "2015-10-31T13:07:00-04:00"
related_articles = ["articles/orpheus-eurydice-opera-atelier.md","articles/he-saidshe-said-alcina-at-opera-atelier.md","articles/a-daring-desirous-doublebill-at-opera-atelier.md"]
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/peggy-kriha-dye.md","scene/people/colin-ainsworth.md","scene/people/meghan-lindsay.md","scene/people/carla-huhtanen.md","scene/people/stephen-hegedus.md","scene/people/aaron-ferguson.md"]
short_description = "Earlier this month I spoke with OA Artistic Director Marshall Pynkoski, who said, &quot;love can be something that saves people or destroys people. Love is amoral. Love cuts through like a knife – anyone in love is cut open. Love is more powerful than hate, but that doesn’t mean it’s a happy ending.&quot;"
slug = "in-review-opera-ateliers-armide"
title = "In review: Opera Atelier&#039;s Armide"
+++

Torquato Tasso's 1581 poem *La Gerusalemme liberata* has already taken up a large portion of my 2015/16 opera season. I just finished working on the Canadian Opera Company's current [triple bill](http://www.coc.ca/PerformancesAndTickets/1516Season/PyramusandThisbe.aspx), which includes Monteverdi's scena *Il combattimento di Tancredi e Clorinda*; the scene's libretto comes from Tasso's poem, in which the Christian Crusader Tancredi falls in love with Clorinda, a Muslim warrior, and kills her mistakenly in a night-cloaked battle.

So, I came into [Opera Atelier](/scene/companies/opera-atelier/)'s *Armide*, an opera based on Tasso's same poem, with sympathy and understanding of this wildly progressive story already in place. Armide is the Muslim Warrier Princess, and the Christian knight Renaud is the only man who hasn't yet fallen slave to her beauty. When I say this story is progressive, I mean that by the end of the 16th century, people were already telling tales of a woman whose strength came from her own virtues; who is so strong, in fact, that she becomes torn between vengeance and love, a very manly dilemma between head and heart.

Earlier this month I spoke with Opera Atelier Co-Artistic Director [Marshall Pynkoski](http://operaatelier.com/about/creative-team/), who said, "love can be something that saves people or destroys people. Love is amoral. Love cuts through like a knife – anyone in love is cut open. Love is more powerful than hate, but that doesn’t mean it’s a happy ending."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446310008531/2015-10-30---OAArmide2---Bruce-Zinger.jpg.jpg)
<figcaption>The company of *Armide*. Photo by Bruce Zinger.</figcaption>
</figure>

This *Armide* is a remount of their 2011 production, again featuring soprano [Peggy Kriha Dye](/scene/people/peggy-kriha-dye/) in the title role, and tenor [Colin Ainsworth](/scene/people/colin-ainsworth/) as Renaud. Lully's music paints an explicit story throughout his opera, and it was exciting to hear Dye in a role with so much bite and rage added to her usual repertoire of gorgeous sound. She risked "un-operatic" sounds for the sake of the story, and made a raging, wild foil to Ainsworth's cool and calm Renaud. Ainsworth has heft in his voice, but he had moments of lightness and beauty that made me catch my breath. 

Other highlights for me were sopranos [Carla Huhtanen](/scene/people/carla-huhtanen/) and [Meghan Lindsay](/scene/people/meghan-lindsay/), lovely as Phénice/Lucinde and Sidonie/Nymphe des eaux. Carla sang with her clear tone, and I loved hearing Meghan in something a little more mezzo-like. She has a warmth in her low voice that I hadn't heard before. Bass-baritone [Stephen Hegedus](/scene/people/stephen-hegedus/) sang Hidraot, King of Damascus, playing a well-meaning father to Armide. I always love hearing him sing in French, and hearing him sing way down low. His was a great mix of substantial sound and easy flexibility, never too heavy for Lully's schizophrenic score.

Under choreographer and Co-Artistic Director [Jeannette Lajeunesse Zingg](http://operaatelier.com/about/creative-team/), the artists of the Atelier Ballet were beautifully shown off in this production. Surrounded the by bright, saturated colours of Gerard Gauci's sets, the ballet took a primary role in *Armide*, including a stunning performance by Tyler Gledhill as Amour.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446309955163/2015-10-30---OAArmide3---Bruce-Zinger.jpg.jpg)
<figcaption>Tyler Gledhill (Love) and Colin Ainsworth (Renaud). Photo by Bruce Zinger.</figcaption></figure>

I've seen a fair amount of Opera Atelier productions over the years, and like any OA-goer, I've noticed the consistencies from one show to another. Pynkoski and Lajeunesse Zingg maintain an aesthetic in their productions, and in this *Armide*, it pulled me out of what was an earthy, human story from Lully. The theatrical gestures start to lose their (very real, yet very old) meaning, and I started noticing them as gesture-by-number. In the same vein, it's also not the first time OA has had people running across the stage with floating arms, or two characters sharing a downstage bench, turning their backs to each other.

Perhaps I'm speaking at an unfair advantage as someone who's seen several OA productions, but I figure OA is in favour of repeat audience members. Or, perhaps I'm confusing an aesthetic with a sort of serialistic way of directing, where a fixed visual is associated with a fixed collection of emotional states. I do know that I became increasingly aware of the *process*, instead of the story, and so it felt less imaginative than it could be. Beautiful, yes, but I felt it started from their aesthetic rather than Lully's score.

>*Armide* has one more show, today at 4:30pm at the Elgin Theatre. For details and tickets, follow the box office links below.
