+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-09-17T12:51:00+01:00"
lastmod = "2016-09-17T15:29:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474112738905/2016-09-17---Square---SONYA-YONCHEVA-AS-NORMA-ROH-PHOTOGRAPHER-BILL-COOPER.jpg.jpg"
primary_image_credit = "Sonya Yoncheva as Norma. Royal Opera House, 2016. Photographer: Bill Cooper."
publishDate = "2016-09-17T15:25:00+01:00"
related_articles = ["articles/in-review-the-barber-of-seville-at-roh.md","articles/in-review-tannhauser-at-roh.md","articles/in-review-lucia-di-lammermoor-at-roh.md","articles/in-review-il-trittico-at-roh.md","articles/in-review-cosi-fan-tutte-at-roh.md","articles/in-review-pop-up-operas-i-capuleti-e-i-montecchi.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/sonya-yoncheva.md","scene/people/joseph-calleja.md","scene/people/sonia-ganassi.md"]
short_description = "Ollé&#039;s production slowly revealed itself to be much more than a collection of provocative symbols, yet it still left us with questions. There were unnecessary distractions: he let swing a giant, swinging thurible just before Norma&#039;s infamous &quot;Casta diva&quot; aria; and when Norma&#039;s kids fall asleep watching television, the flat-screen TV blared (silent) cartoons throughout her entire act II scene with Adalgisa."
slug = "in-review-norma-at-roh"
title = "In review: Norma at ROH"
+++

Despite a dearth of Druid imagery and gloomy Celtic forests, Àlex Ollé's new production certainly grasps the eerie darkness and suffocating mores of religion in Bellini's *Norma*. "Religion here is the glue that holds society together, an unconscious way of ordering the known world," writes Ollé, "but it is also the means to repress anyone who dares deviate from the 'norm.'"

For a brief moment as the curtain rose, the looming set by Alfons Flores had the look of gnarly tree branches; the lights instead revealed a dizzying lattice work of crucifixes. Crosses pervade the stage at every corner, and priests were dressed in the [capirotes](https://en.wikipedia.org/wiki/Capirote) of Spanish Easter and Holy Week celebrations. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474112985564/2016-09-17--Chorus-PRODUCTION-IMAGE-ROH-PHOTOGRAPHER-BILL-COOPER.jpg.jpg)
<figcaption>Production image from *Norma*, Royal Opera House, 2016. Photographer: Bill Cooper.</figcaption>
</figure>

Perhaps we reveal a bit about our own discomfort with some religious symbols, yet it was clear that Ollé was taking the oppressive religion and customs of *Norma* and putting them in a setting of Christian imagery, to pack an appropriate punch for contemporary listeners. "We have, in short, chosen to create a production that chimes with current social preoccupations. We're talking about the deep-rooted forces that influence social and politial thinking - forces that unite around symbols such as the cross."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474112801064/2016-09-17---SONYA-YONCHEVA-AS-NORMA-ROH-PHOTOGRAPHER-BILL-COOPER.jpg.jpg)
<figcaption>Sonya Yoncheva as Norma in *Norma*, Royal Opera House, 2016. Photographer: Bill Cooper.</figcaption>
</figure>

It's a visually arresting production, to be sure. Also stunning were the combination of the Orchestra of the Royal Opera House under Music Director Anthony Pappano, and soprano Sonya Yoncheva in the title role. Earlier this year, we heard much flurry about [Anna Netrebko](/scene/people/anna-netrebko/)'s withdrawal from her debut in the ROH's *Norma*, yet Yoncheva was no consolation prize. She sang with glorious strength and authority, leaving no doubt of Norma's power. Her "Casta diva" had all of Bellini's endless lines, and her moments of coloratura felt relaxed and liquid. Ollé's Norma is a difficult character to play, and to find a beautiful balance between a leader with mercy and strength can be even harder to achieve as a woman. Yet Yoncheva had a powerful melding of sound, posture, and controlled moments of kindness.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474119102314/2106-09-17---3---SONYA-YONCHEVA-AS-NORMA-ROH-PHOTOGRAPHER-BILL-COOPER.jpg.jpg)
<figcaption>Sonya Yoncheva as Norma in *Norma*, Royal Opera House, 2016. Photographer: Bill Cooper.</figcaption>
</figure>

Pappano led us through the score with mercifully wise pacing, and he pulled great clarity out of Bellini's score. Bellini is a strange case, in many ways; he is a complete master of melody, and his love of the voice is what keeps his operas in the standard repertoire today. Yet in his works, there are inevitably sections of music that feel utterly banal, as though they mean to say, *here is some filler music!*

So, Pappano's deft handling of each scene as a part of a larger arc was a breath of fresh air, and the orchestra did some beautiful boasting of hidden inner voices that pumped interest into the "filler music." 

Famed tenor [Joseph Calleja](/scene/people/joseph-calleja/) was a cold-hearted Pollione; he stood out in a grey business suit among the robed followers of the church, and Ollé was telling us that Pollione came from a society with more freedom than Norma's. Though he may have been able to show Adalgisa a new life outside of her vows, no one wanted her to leave with Pollione. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474112971442/2016-09-17---SONYA-YONCHEVA-AS-NORMA-JOSEPH-CALLEJA-AS-POLLIONE-ROH-PHOTOGRAPHER-BILL-COOPER.jpg.jpg)
<figcaption>Sonya Yoncheva as Norma, Joseph Calleja as Pollione in *Norma*, Royal Opera House, 2016. Photographer: Bill Cooper.</figcaption>
</figure>

Calleja had fantastic fire with Yoncheva in their most hostile scenes together, yet he seemed to have a singular vocal colour that didn't suit his duet with Adalgisa, or his final scene with Norma. He sang with a stiffness that seemed to communicate what was difficult about Bellini's score.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474119077001/2016-09-17-2-SONYA-YONCHEVA-AS-NORMA-SONIA-GANASSI-AS-ADALGISA-ROH-PHOTOGRAPHER-BILL-COOPER.jpg.jpg)
<figcaption>Sonya Yoncheva as Norma, Sonia Ganassi as Adalgisa in *Norma*, Royal Opera House, 2016. Photographer: Bill Cooper.</figcaption>
</figure>

As Adalgisa, mezzo [Sonia Ganassi](/scene/people/sonia-ganassi/) sang with a sensitive, innocent sound that, paired with Yoncheva's Norma, gave a perfect picture of the deference and respect in their relationship. At times she seemed to over-darken her sound, and Ollé momentarily had her singing directly into the floor. Yet she was a touching presence in this opera full of harsh people and places.

Ollé's production slowly revealed itself to be much more than a collection of provocative symbols, yet it still left us with questions. There were unnecessary distractions: he let swing a giant, swinging [thurible](https://en.wikipedia.org/wiki/Thurible) just before Norma's infamous "Casta diva" aria; and when Norma's kids fall asleep watching television, the flat-screen TV blared (silent) cartoons throughout her entire act II scene with Adalgisa (except in the final pages of their duet, where Norma's daughter wakes up to bounce around the room on a pink ball).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474112849239/2016-09-17---SHERRATT-AS-OROVESO-YONCHEVA-AS-NORMA-CALLEJA-AS-POLLIONE-ROH-PHOTOGRAPHER-BILL-COOPER.jpg.jpg)
<figcaption>Brindley Sherratt as Oroveso, Sonya Yoncheva as Norma, Joseph Calleja as Pollione in *Norma*, Royal Opera House, 2016. Photographer: Bill Cooper.</figcaption>
</figure>

There seemed a disconnect among the cast, precisely where one wants cohesion.  Pollione's Act I duet with Adalgisa went by unremarkably, and in both of their duets Yoncheva and Ganassi seemed to sing beside each other, rather than with each other. The production made much of the restrictive society in which these characters live, and perhaps it's what gave us the sense of disconnect between the parts of the opera's whole.

Questions aside, Ollé's *Norma* is an impressive evening, with stellar music centred around Yoncheva and Pappano. The production runs at the Royal Opera House until October 8, so [click here](http://www.roh.org.uk/productions/norma-by-alex-olle) for full details and tickets.
