+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-11-17T17:56:00+00:00"
lastmod = "2016-12-07T22:49:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479406128527/2016-11-16---Square---NaomisRoad-photobyDahliaKatz-9125.jpg.jpg"
primary_image_credit = "Photo by Dahlia Katz."
publishDate = "2016-11-18T10:58:00+00:00"
related_articles = ["articles/oksana-g-its-so-out-of-this-world-and-yet-so-realistic.md","articles/tough-to-watch-oksana-g.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/erica-iris.md"]
short_description = "As Canadians, we pride ourselves on our acceptance of others, our inclusivity, and our concern for the well-being of others - but our record is not unblemished. There have been many missteps and atrocities committed by Canadians from which we can&#039;t shy away. Especially now, when we see who&#039;s running for the leadership of one of Canada&#039;s major political parties. We can not let ourselves go back to a time when stories like the one I saw tonight were happening."
slug = "in-review-naomis-road"
title = "In review: Naomi&#039;s Road"
+++

On Wednesday, November 16th, 2016 my eyes were opened. It's already been a pretty stellar season for opera here in Toronto every company is pulling out all the stops. Tonight, however, I found myself being told a story that I should have been told long ago - a story I should have learned in school and a story that should be talked about and addressed more in today's society. 

As Canadians, we pride ourselves on our acceptance of others, our inclusivity, and our concern for the well-being of others - but our record is not unblemished. There have been many missteps and atrocities committed by Canadians from which we can't shy away. Especially now, when we see who's running for the leadership of one of Canada's major political parties. We can not let ourselves go back to a time when stories like the one I saw tonight were happening. 

Joy Kogawa penned her novel, *Naomi's Road*, and it was published in 1986. It tells the story of a Japanese-Canadian family and their experiences with racism, segregation, and persecution at the hands of the Canadian government during WWII. Most of us may be aware of this epidemic of Japanese internment camps across the states due to the activism of TV star George Takei, and his subsequent Broadway show [*Allegiance*](http://allegiancemusical.com/). What we're painfully unaware of is that this xenophobia towards the Japanese after the events of Pearl Harbour was widespread across Canada at that time as well. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479406388581/2016-11-16---NaomisRoad-photobyDahliaKatz-9222.jpg.jpg)
<figcaption>*Naomi's Road*, Tapestry Opera, 2016. Photo by Dahlia Katz.</figcaption>
</figure>

In *Naomi's Road*, Naomi's family is torn apart. Mom goes back to Japan to care for an elderly relative. Dad stays to care for the two Canadian-born children, along with their Obasan. They are later packed up and moved to a small one-room shack in the mountains. They believe their father is still at home, working only to find out that he too has been sent to another camp - as was the practice then to separate the men from the women and children. 

We then see Naomi and her brother Stephen experience racism from all angles, mixed with the fear of the unknown, and the fear of the war and confusion over their lost father. Then Naomi suddenly befriends Mitzi, a white girl, and thus the seeds of hope are planted. The show ends with the children and Obasan reunited with the Father and off to start a new life now that the war is over. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479406396812/2016-11-16---NaomisRoad-photobyDahliaKatz-9138.jpg.jpg)
<figcaption>*Naomi's Road*, Tapestry Opera, 2016. Photo by Dahlia Katz.</figcaption>
</figure>

As Naomi, soprano Hiather Darnel-Kadonga sang with an easy, free, and accessible tone. She handled the role, which lies heavily in the mid-voice, very well. What was particularly endearing was the innocent quality she added to her Naomi. She was very naïve, but in an empowering way. The kind of way that makes you happy she asks questions. She has a 'legit' musical theatre quality to her voice that lends itself brilliantly to this score. 

Tenor Sam Chung sang the role of Stephen, Naomi's brother. This is a voice I'd really like to hear more of. Crisp diction and a firm vocal line while never sacrificing character or physicality. The bloom over the top of his register was quite exciting. His voice mixed very will with that of Naomi, to the point they could have actually been a real-life brother/sister duo. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479406354269/2016-11-16---NaomisRoad-photobyDahliaKatz-9181.jpg.jpg)
<figcaption>*Naomi's Road*, Tapestry Opera, 2016. Photo by Dahlia Katz.</figcaption>
</figure>

As Daddy, The Bully, Rough Lock Bill, and Trainmaster, baritone Sung Taek Chung had some impressively fast quick changes. He was bright and energetic and always drove the momentum of the scene forward. His relationship with the two kids was tangible and true. I really enjoyed his portrayal of Rough Lock Bill, a man who befriends the two young Japanese children and makes them feel welcome for the first time since they were driven from Vancouver. 

[Erica Iris](/scene/people/erica-iris/) as Mother, Mitzi, and Obasan walked away with the show last night. Like Sung Taek Chung, she too had many quick changes that you didn't even notice. She was gentle, charming, and warm throughout the whole production. Her honey-dripped mezzo sounded lush and comforting as it rang through the church. I have to say, her characterization of Mitzi may have been the highlight of the night for me. There was a truth to every character she played. There were layers and each one was on a journey. It would have been very easy to stick to archetypes and caricatures (and it would have totally jived with the aesthetic of the whole show) but Erica's choices brought us three-dimensional women and girls at all times.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479406174107/2016-11-16---NaomisRoad-photobyDahliaKatz-9144.jpg.jpg)
<figcaption>*Naomi's Road*, Tapestry Opera, 2016. Photo by Dahlia Katz.</figcaption>
</figure>

This production of *Naomi's Road* was originally conceived by Ann Hodges, also the opera's librettist. The 2016 Toronto revival is directed by Tapestry Opera's Artistic Director [Michael Mori](/scene/people/michael-mori/). Composer Ramona Luengen scored *Naomi's Road* as a one-act opera for four singers, geared towards younger audiences. It's been touring Vancouver and Alberta regularly since its premiere 10 years ago and has seen over 400 performances - making it the most performed Canadian opera. 

The score is accessible and tuneful and reminiscent of lyrical musical theatre. The text is poetic yet truthful and every syllable drives the narrative forward. As part of this production they built a stage insert, which will be a legacy gift for St. David's Anglican Church, that they can use to mount concerts and other theatrical productions to supplement their finanical needs.

I have to say that when I think of opera that's written with the youth in mind, I tend to lean to the more fable-based stories like [*The Bremen Town Musicians*](/schmopera-on-tour-the-bremen-town-musicians/) and [*Hänsel und Gretel*](/in-review-hänsel-gretel/). Last night I learned that there was a more direct way to tell the youth of today an important story, a story I was never told growing up. It's a timely piece and very important that as many people as possible hear it now. 

Although it highlights an embarrassing and deplorable moment in Canadian history, we need to acknowledge it happened, tell the story with empathy, and ensure that these mistakes are never made again. With the current climate south of the border and around the world, we need pieces like this to remind us that there is hope for the future if we look to the minds and the faces of the generation that will take over from us. 

Check out the rest of Tapestry's season here. Up next for Tapestry Opera is [*Songbook VII*](https://tapestryopera.com/songbook-vii/) featuring [Krisztina Szabó](/in-review-death-desire/) and the world premiere of [*Oksana G.*](https://tapestryopera.com/oksana-g/) starring a stellar lineup of singers including Szabó, [Ambur Braid](/talking-with-singers-ambur-braid/), [Keith Klassen](/scene/people/keith-klassen/), and [Adam Fisher](/scene/people/adam-fisher/). 

>Naomi's Road plays for two more performances, November 19 at 8pm and 20 at 2pm, both at St. David's Anglican Church, 49 Donlands Ave. For details and tickets, [click here.](https://tapestryopera.com/naomis-road/)
