+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-01-24T14:01:00-05:00"
lastmod = "2015-04-11T22:34:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805715946/Jan-2015-1024.jpg.jpg"
primary_image_credit = "Emily Ding"
publishDate = "2015-01-24T14:01:00-05:00"
related_companies = ["scene/companies/opera-5.md"]
related_people = ["scene/people/leighann-allen.md","scene/people/geoffrey-sirett.md","scene/people/emma-parkinson.md","scene/people/christopher-mayell.md","scene/people/rachel-krehm.md","scene/people/geoffrey-penar.md"]
short_description = "Last night Opera 5 opened their double bill, Modern (Family) Opera, which was made up of Ermanno Wolf-Ferrari’s Il segreto di Susanna and the world première of Darren Russo’s new opera, Storybook. Stage directors Grace Smith (Wolf-Ferrari) and Opera 5 Artistic Director Aria Umezawa shared the double bill, bringing their unique styles to two pieces that couldn’t have been more different."
slug = "in-review-modern-family-opera"
title = "In review: Modern (Family) Opera"
+++

<p>
	Last night <a href="http://www.operafive.com/season-tickets/" target="_blank">Opera 5</a> opened their double bill, <a href="http://www.operafive.com/season-tickets/" target="_blank"><em>Modern (Family) Opera</em></a>, which was made up of Ermanno Wolf-Ferrari's <em>Il segreto di Susanna </em>and the world première of Darren Russo's new opera, <em>Storybook</em>. Stage directors Grace Smith (Wolf-Ferrari) and Opera 5 Artistic Director Aria Umezawa shared the double bill, bringing their unique styles to two pieces that couldn't have been more different. Music Director Evan Mitchell led the orchestra (which I believe is a first for Opera 5, so congrats!) impressively through two tricky scores. I thought it was Opera 5's best production yet. It was streamlined and cohesive, and both pieces stood well on their own. Get out and see one of the two remaining shows (<a href="http://www.operafive.com/season-tickets/" target="_blank">details right here</a>).
</p>
<p>
	<em>Il segreto di Susanna</em> is a comedy about a newlywed couple, still in honeymoon bliss. Susanna's big secret? She smokes. Her husband, Gil, sniffs out the smell of smoke in their home, and blows the secret entirely out of proportion, convinced that Susanna is having an affair with a smoker. Wolf-Ferrari's score is intricate and colourful; the piece revolves around high stakes comedy and layers of hidden secrets to be uncovered, and the music itself is amazingly specific.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805769057/Jan-2015-0805.jpg"><img data-resize-src="http://lh3.googleusercontent.com/x7eydqybHmgylok9F7-ZDj2AvMV3wlrev5_whb_0uUK1iGrnIjYmVL11uO7OXpmZoA047Xd-tu6iJQzKfSFalZaGvG0gtA" src="http://lh3.googleusercontent.com/x7eydqybHmgylok9F7-ZDj2AvMV3wlrev5_whb_0uUK1iGrnIjYmVL11uO7OXpmZoA047Xd-tu6iJQzKfSFalZaGvG0gtA=s1200"></a><figcaption>Rachel Krehm (Susanna) and Christopher Mayell (Sante). Photo: Emily Ding</figcaption></figure>
<p>
	As Susanna, <a href="http://www.rachelkrehm.com/" target="_blank">Rachel Krehm</a> sounds the best I've heard her. It's a great role for her, one that lets her relax into her full, strong sound. Her part is big and expansive, full of ingratiating lies told to her husband, or thorough enjoyment of her forbidden vice. I missed a bit of inflection of the text; I thought she could have risked more of a spoken sound, with the vocal power that she has.
</p>
<p>
	<a href="http://www.geoffreysirett.com/" target="_blank">Geoff Sirett</a> sings Gil, her husband, and he was a total master of theatrical comedy, with a thousand different voices. He had huge, tragic outbursts of jealousy over his wife's perceived affair, he knew which lines to deliver out to us, so we could be in on his plan for finding the truth. He tore about the house, looking for his wife's lover ("Non c'è!!!"), shooting back and forth across the stage like a cartoon. Classic, loved it.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805811720/Jan-2015-0749.jpg"><img data-resize-src="http://lh3.googleusercontent.com/6dxL7X8i_JHGfCkYt8yK-JtnBUk07AHwONTsv4YQYzq1iJmlRTDn1L3Gxsqxx9LKWANsAOt9ztCYSqZCrkV5dnefEt33" src="http://lh3.googleusercontent.com/6dxL7X8i_JHGfCkYt8yK-JtnBUk07AHwONTsv4YQYzq1iJmlRTDn1L3Gxsqxx9LKWANsAOt9ztCYSqZCrkV5dnefEt33=s1200"></a><figcaption>Rachel Krehm (Susanna) and Geoffrey Sirett (Gil). Photo: Emily Ding</figcaption></figure>
<p>
	<a href="http://christophermayell.com/" target="_blank">Christopher Mayell</a> played the mute role of Sante, the butler-type who tries to contain his mistress' secret without angering his master. It's so, <em>so</em> hard to do these silent roles well, because they're often meant to be a combination of comic relief and liaison between the other characters and the audience. Chris was hilarious, and he expertly established his relationships to Susanna and Gil, keeping them different and in conflict. Great stuff indeed.
</p>
<p>
	The orchestra under Music Director<a href="http://www.musicaltoronto.org/2014/03/07/meet-the-new-face-of-the-kingston-symphony/" target="_blank"> Evan Mitchell</a> sounded great. It's a chamber-music-like score, with plenty of recurring themes in solo instruments and lots of rhythmic elasticity. In the recitatives I thought the orchestra sustained their harmonies too loudly, covering the subtleties in the singers' text. But it was great to have an orchestra, period; I'm excited for this step for Opera 5.
</p>
<p>
	Then, we heard the world première of <a href="https://soundcloud.com/darrenrusso" target="_blank">Darren Russo</a>'s <em>Storybook</em>, with a libretto by Darren Russo, William Blake, Lauren J. Rogener, and Anonymous, which was originally inspired by William Blake's <a href="http://www.gutenberg.org/files/1934/1934-h/1934-h.htm" target="_blank"><em>Songs of Innocence and Experience</em></a>. The opera is made up of seven scenes, sung by five singers whose characters are named for their voice type. Russo can describe it better than I in his composer's notes, "The inhabitants of <em>Storybook</em> revisit moments of boundless imagination and dreary routine, childhood readiness and adult resignation, all emanating from a desire for meaningful contact, for expression and for understanding in a duplicitous world." The scenes aren't dramatically linear, but they gradually made tiny connections to each other in small ways, leaving a web of people who have had vague interaction with each other over the course of an hour.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805866741/Jan-2015-0917.jpg"><img data-resize-src="http://lh3.googleusercontent.com/q7Wm5Fx1lPxjmpaLia_bdrRRw83MwZ54y_hASFWVcedq7VA1-v3UBKd8eXxo9gw4H-vOZVQ-IUX4lMQRoEfg3yay4cohyQ" src="http://lh3.googleusercontent.com/q7Wm5Fx1lPxjmpaLia_bdrRRw83MwZ54y_hASFWVcedq7VA1-v3UBKd8eXxo9gw4H-vOZVQ-IUX4lMQRoEfg3yay4cohyQ=s1200"></a><figcaption>Christopher Mayell in Darren Russo's <em>Storybook</em>. Photo: Emily Ding</figcaption></figure>
<p>
	My initial reaction was that it sounded really neat. The colour palate in the orchestra was icy and tense, using string harmonics, <em>pizzicato</em>, electronic sounds, and probably other extended techniques that I couldn't identify. There was some pretty amazing choral writing for the singers, reminding me of some of Arvo Pärt's harmonies. Russo brought out moments in the libretto with musical effects imitating squeaking, and muffled sex from the next room; he wrote some amazing word painting on phrases like "boiling point" and "crawling out of my skin". Throughout the piece, there were multiple returns to quotes of childhood songs and nursery rhymes, like "I am slowly going crazy, 1-2-3-4-5-6-switch!" and ""Five little ducks went out one day, out one day...". The counting in the nursery rhymes kept a structure to the piece, counting "five little ducks", then four, then three, etc. I thought it worked well, and the musical effect was always novel and evolving.
</p>
<p>
	Aria Umezawa directed the piece in an abstract way, seating the singers in one general space that allowed each character to have a private moment, or extend their space to other characters. I think it was the best way to visualize Russo's structure to <em>Storybook</em>, and it drew me in with its simplicity. The five singers were fantastic, and have to be commended for memorizing what seemed like a tricky score. <a href="http://www.leighannallen.com/home/" target="_blank">Leigh-Ann Allen</a> (Soprano),<a href="http://emmaparkinson.com/" target="_blank"> Emma Parkinson</a> (Mezzo-Soprano), <a href="http://christophermayell.com/" target="_blank">Chris Mayell</a> (Tenor), <a href="http://www.geoffreysirett.com/" target="_blank">Geoff Sirett</a> (Baritone), and <a href="http://geoffreypenar.com/" target="_blank">Geoffrey Penar</a> (Bass) were all fantastic as solo and ensemble artists. They rotated solo moments with group reactions to others' solo moments in a really fluid way. Emma Parkinson had a great aria/dream about wanting to go for a joint and a walk; Leigh-Ann Allen (whose voice is gorgeous, and we should hear her more) was tragic and innocent as a young boy who misses his father; Geoff Sirett had an incredible monologue about crawling out of one's skin, and then putting it back one. Pretty great texts, helped by a truly great cast. I hadn't heard Geoffrey Penar before, but I'd love to hear more; he had a fantastic, dark sound and an intense stage presence that was really exciting.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428805904951/Jan-2015-0962.jpg"><img data-resize-src="http://lh3.googleusercontent.com/OLlaVFpEJYJnXku5bzlZxQhIy_ukfWHVOtqk2ZTcdI29rJWxrearpzbX_hmaSuBZSVcyheQNXbN9WTlJX_aiU2ymwfI" src="http://lh3.googleusercontent.com/OLlaVFpEJYJnXku5bzlZxQhIy_ukfWHVOtqk2ZTcdI29rJWxrearpzbX_hmaSuBZSVcyheQNXbN9WTlJX_aiU2ymwfI=s1200"></a><figcaption>l-r: Christopher Mayell, Emma Parkinson (front), Geoffrey Penar, Leigh-Ann Allen, Geoffrey Sirett. Photo: Emily Ding </figcaption></figure>
<p>
	I think the piece is promising for Canadian opera, especially with the growth of so many small companies. I think <em>Storybook</em> is for a small- to medium-sized space, where the audience can get close and watch the details. My only issue was with the setting of the text. Russo used interesting rhythms and inflections, splitting up words, and often putting purposeful stress or length on the "wrong" syllable. I like the originality of the setting, but it really did make the text hard to understand. Surtitles were used again, but I wanted to be able to keep my eyes on the stage without having to check the titles; the texts were English, and their diction was good, but I thought the text setting created an unnecessary barrier between the piece and its listeners.
</p>
<p>
	<a href="http://www.operafive.com/season-tickets/" target="_blank">Opera 5's </a><em><a href="http://www.operafive.com/season-tickets/" target="_blank">Modern (Family) Opera</a> </em>runs until January 25th at the Arts and Letters Club, 14 Elm St. There are great singers, I like both shows, and I think <em>Storybook</em> is an important piece to see. <a href="http://www.operafive.com/season-tickets/" target="_blank">Click here for details and to purchase tickets</a>.
</p>
