+++
author = ["authors/patricia-auchterlonie.md"]
categories = "Review"
date = "2017-07-02T21:20:00-06:00"
lastmod = "2017-07-02T22:32:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499052874749/2017-07-02---Square---MITRIDATE-RE-DI-PONTO-PRODUCTION-IMAGE-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg"
primary_image_credit = "Mitridate, re di Ponto, ROH, 2017. Photo by Bill Cooper."
publishDate = "2017-07-02T22:19:00-06:00"
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/lucy-crowe.md","scene/people/rupert-charlesworth.md","scene/people/vlada-borovko.md","scene/people/jennifer-davis.md","scene/people/albina-shagimuratova.md","scene/people/bejun-mehta.md","scene/people/michael-spyres.md","scene/people/francesca-chiejina.md"]
short_description = "Overall, the quality of the production was incredibly high. It was visually stunning, particularly the unusual costuming. The aesthetic and movement choices of the production did inspire some conflict in me though. It was fantastic to see such a bold exploration of gender fluidity and campiness fearlessly played out with the costuming and physical characterisation of the singers. I also loved the aesthetic value of the costuming and set - the rich colours really brought this over-the-top world to life."
slug = "in-review-mitridate-re-di-ponto-at-roh"
title = "In review: Mitridate, re di Ponto at ROH"
+++

I love being surprised when I go to the opera, but I find it’s a rare occurrence. I am often delighted and moved, but rarely surprised. On this occasion, *Mitridate, Re di Ponto* was full of the unexpected. First of all, I really wasn’t expecting to enjoy the piece the way I did. Usually four hours of back-to-back *da capo* arias is my idea of torture (that's not to say I don't like *da capo* arias, but an hour is enough!). But this production was captivating from the beginning - campy, full of colour and stunning aesthetic value, but particularly, full of incredibly refined and beautiful singing. 

I did not think I would love the music as much as I did, but it really struck me. It's very hard to believe that Mozart was only 15 when he wrote this opera. It's full of gorgeous music that delightfully unfolds, occasionally subverting the Baroque form for an *opera seria*. The orchestra sounded fantastic under the direction of Christophe Rousset - full of energy and rhythmic vigour. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499053140553/2017-07-02---MITRIDATE-RE-DI-PONTO-PRODUCTION-IMAGE-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Production image from *Mitridate, re di Ponto*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

The second surprise was due to illness - the audience had the treat of hearing two (two!) singers from the Jette Parker Young Artists program. Some of the best singing of the evening came from [Vlada Borovko](/scene/people/vlada-borovko/), filling in for [Albina Shagimuratova](/scene/people/albina-shagimuratova/) as Aspasia. She seemed utterly comfortable and confident, taking the stage with grace and fleshing out the vulnerabilities of her character easily. Her tone was round and plummy, yet incredibly agile and flexible. Particularly, her quiet singing was something to be remarked on - very well controlled, but it seemed to always be deeply felt. I kept thinking I'd heard her best aria, but then she would impress me again. She opened the opera with a stunning display of vocal fireworks and emotional intensity that was balanced best by the incredibly tender and astonishing "Pallid'ombre" in Act III. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499053155764/2017-07-02---SALOME-JICIA-AS-SIFARE-ALBINA-SHAGIMURATOVA-AS-ASPASIA-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Salome Jicia as Sifare, Albina Shagimuratova as Aspasia in *Mitridate, re di Ponto*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

The second last-minute replacement was in the smaller role of Arbate, the Govenor of Nymphaeum. [Francesca Chiejina](/scene/people/francesca-chiejina/) stepped in to sing the role with ease and confidence - she can't have had more than 2 hours notice (Borovko made it into the program, but Chiejina was only announced). Although she had only one aria, she sang beautifully, with a easy round, warm sound that promises wonderful things to come. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499053184013/2017-07-02---MICHAEL-SPYRES-AS-MITRIDATE-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Michael Spyres as Mitridate in *Mitridate, re di Ponto*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>
 
Other stand-out singing also came from [Michael Spyres](/scene/people/michael-spyres/) in the title role. His arias demanded an incredibly range of technical accomplishment, from the lyrical to the acrobatic. He sang wonderfully, with ease and sparkle, navigating even the most challenging passages with aplomb. But even more impressive than his singing was his striking stage presence. He was regal and commanding, truly striking the figure of a cruel tyrant with a soft heart. 

[Bejun Mehta](/scene/people/bejun-mehta/) also impressed in the role of Farnace, playing the perfect cold villain and singing his arias with character and flair. He did lose intensity in his final aria, "Già dagli occhi", which was incredibly long and very demanding, with long lines and high emotional content. However, his performance was wonderful overall, with wonderful singing and venom to spare.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499053165121/2017-07-02---BEJUN-MEHTA-AS-FARNACE-RUPERT-CHARLESWORTH-AS-MARZIO-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Bejun Mehta as Farnace, [Rupert Charlesworth](/scene/people/rupert-charlesworth/) as Marzio in *Mitridate, re di Ponto*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>
 
Overall, the quality of the production was incredibly high. It was visually stunning, particularly the unusual costuming. The aesthetic and movement choices of the production did inspire some conflict in me though. It was fantastic to see such a bold exploration of gender fluidity and campiness fearlessly played out with the costuming and physical characterisation of the singers. I also loved the aesthetic value of the costuming and set - the rich colours really brought this over-the-top world to life.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499053206206/2017-07-02---LUCY-CROWE-AS-ISMENE-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Lucy Crowe as Ismene in *Mitridate, re di Ponto*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>
 
However, as much as the production was visually stunning, there was definitely an element of objectionable cultural pastiche. There was use of kathakali Indian and Japanese kabuki inspired costumes and movement and while the colours and variety were beautiful, ultimately, the two traditions came across overly simplified and pastiched. Particularly, the stylised imitation of Indian posing and dancing that [Lucy Crowe](/scene/people/lucy-crowe/) presented as Ismene was in poor taste (especially because Ismene is meant to be Parthian, an ancient Persian kingdom, not even Indian!) In specific, there was an ongoing use of a slightly mocking head wiggle that was definitely problematic - it was used as a joke with the audience, but it was a cheap way of confirming that we all knew her character was supposed to be Indian. I thought it was reductionist, and not in very good taste. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499053222132/2017-07-02---JENNIFER-DAVIS-AS-ARBATE-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>[Jennifer Davis](/scene/people/jennifer-davis/) as Arbate in *Mitridate, re di Ponto*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

However, there were other elements of the movement choreography by Ron Howell that were fantastic and served the production beautifully. The use of rhetorical 18th-century gesture was particularly effective, giving the singers slow and stylised movements to use during their long and technically difficult arias.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499053372082/2017-07-02---MITRIDATE-RE-DI-PONTO-PRODUCTION-IMAGE-2-ROH-PHOTO-BY-BILL-COOPER.jpg.jpg)
<figcaption>Production image from *Mitridate, re di Ponto*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

Overall, it was an absolutely wonderful evening out at the opera. The singing really stood out, especially due to the incredibly high technical demands of the music. Each of the singers shone in their own way, dealing with the remarkable demands of the score with ease and drama. Musically, it was easy to see hints of the genius that would write *Die Entführung aus dem Serail* and even *Don Giovanni*. Director Graham Vick is to be completely commended for his work on this production; there was never a dull moment, only beauty - both visual and musical - to behold.

>Mitridate, re di Ponto plays at the Royal Opera House until July 7. For details and ticket information, [click here.](http://www.roh.org.uk/productions/mitridate-re-di-ponto-by-graham-vick)
