+++
author = ["authors/jenna.md","authors/greg.md"]
categories = "Review"
date = "2015-05-27T09:04:00-04:00"
lastmod = "2015-06-03T16:47:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432735197094/M'Dea-Undone---Featuring-Lauren-Segal---photo-by-Dahlia-Katz.jpg.jpg"
primary_image_credit = "Photo by Dahlia Katz."
publishDate = "2015-05-27T10:20:00-04:00"
related_articles = ["articles/opera-in-spring.md","articles/in-review-tapestry-briefs-booster-shots.md","articles/go-to-this-tapestry-songbook.md","articles/does-new-opera-raise-the-bar-for-performers.md","articles/michael-mori-on-the-devil-inside.md","articles/in-review-rocking-horse-winner.md","articles/dont-miss-naomis-road.md","articles/crosscanada-opera-the-overcoat-comes-to-toronto-vancouver.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/scottish-opera.md"]
related_people = ["scene/people/lauren-segal.md","scene/people/peter-barrett.md","scene/people/jacqueline-woodley.md","scene/people/jordan-de-souza.md","scene/people/michael-mori.md"]
short_description = "I went with Greg last night to see M&#039;dea Undone, Tapestry Opera&#039;s much-anticipated world premiere by composer John Harris and librettist Marjorie Chan. The short version of this review is that I loved, loved it, and it was one of the most integrated nights out at the opera I&#039;d experienced."
slug = "in-review-mdea-undone"
title = "In review: M&#039;dea Undone"
+++

**Jenna**: I went with Greg last night to see *M'dea Undone*, Tapestry Opera's much-anticipated world premiere by composer John Harris and librettist Marjorie Chan. The short version of this review is that I loved, loved it, and it was one of the most integrated nights out at the opera I'd experienced. It's hard to pull one element apart from another in order to write cohesively about it, but I'll try.

**Greg**: Under the watchful eye of Artistic Director Michael Mori, Tapestry Opera has another hit on their hands. The first thing I said to Jenna when it was over was "I feel like I just had an amazingly satisfying meal." *M'dea Undone*, with music by John Harris and libretto by Marjorie Chan, opened at Evergreen Brickworks last night and there was magic made. Every now and again you see a show that reminds you why you got into this biz in the first place. 

**Jenna**: The story of *M'dea Undone* unfolded in the spacious Holcim Gallery at Evergreen Brickworks. The semi-closed space smelled like trees, and you could hear the muted traffic on Bayview. The orchestra, led by Music Director Jordan de Souza, blended in among the lights and shadows, looking like a very organized group of buskers on the street. Director Tim Albery created really specific characters, the kind you feel like you've known for longer; I loved how he often seemed to step back and allow the story to work in this unique environment.

**Greg**: Michelle Tracey's set was fractured into three main playing spaces. The first being M'dea's hovel, the second the Oval Office/election stage and the third being M'dea's American apartment. This can run the risk of challenging the audience on both a dramatic and sonic front. Director Tim Albery expertly managed Tracey's design of the space providing a neat clearly directed visual, a visual that showed a stark contrast between the lush political affluence and the strife torn village that our heroine was forced to betray. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432735247904/M'Dea-Undone-Featuring-Lauren-Segal-and-Peter-Barrett---photo-by-Dahlia-Katz--smaller-7.jpg.jpg)
<figcaption>Lauren Segal as M'dea and Peter Barrett as Jason. Photo by Dahlia Katz.</figcaption>
</figure>

**Jenna**: I couldn't get over how organic everything was, even the raw scaffolding set, or the small but clear implication of a Presidential Briefing Room. Michelle Tracey's sets and costumes made this an every-day, contemporary story, with noticeable hints of uneasiness. The lighting design by Jason Hand really did it for me, though; we knew where to look, and the long, looming shadows he created in the large space helped the story's unsettling quality.

**Greg**: Jason Hand's lighting was, to use a phrase from the 90s, da bomb. His mastery of outdoor stages is wonderful and his seamless transitions added another level to the whole movie-like feel of the piece. Tracey's Costumes were simple and understated with some exceptions for the beautifully clad Dahlia and President. It was a nice parallel between the more homely aspects of M'dea's appearance and surroundings. 

**Jenna**: The cast was small but mighty. As M'dea, mezzo Lauren Segal was tragic and frustrating and compelling, and I loved it. She sounded spectacular, and put the text before all. Ugly chest voice, hyperventilating panick, seduction; Lauren sang them all so specifically that I was pulled past all the "parts" of opera and into the story. This is the best I've heard her, and I couldn't help but notice that she was a beautiful actor, too.

**Greg**: As M'dea, Lauren Segal is breathtaking. A challenging role to sing for sure, she made excellent and prolific use of her chest voice, adding a depth of heartiness and earthiness to balance with some of her incredibly difficult higher passages. Her acting was on point. Segal was riveting from start to finish. Watching her slide from love-struck new mother into the madness caused by infidelity was incredibly powerful. Her scenes with Peter Barrett as Jason were electric. And it's worth it to note how modern the relationship dialogue was between them. It helped to lend itself to the overall feeling that I was watching a really lyrical episode of *House of Cards*. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432735329734/M'Dea-Undone-Featuring-Lauren-Segal%2C-Peter-Barrett%2C-and-Michael-Mori---photo-by-Dahlia-Katz--8.jpg.jpg)
<figcaption>Lauren Segal, Peter Barrett and Michael Mori. Photo by Dahlia Katz.</figcaption>
</figure>

**Greg**: Barrett's Jason was a force to be reckoned with. Some of the best singing I've heard Peter do. The tessitura was quite high, but Peter sang it as though it were natural everyday speech. He pulled out some extra stops in his characterization as well. The desperation of his yearning to be with his son was palpable. The moment when he realizes his son is missing was the high point of the night for me. 

**Jenna**: As Jason, Peter Barrett made his Tapestry Opera debut. He too sounded in great vocal shape, but not once was I really "aware" of Peter the Opera Singer. He had a voice for talking to M'dea, one for The President, one for grief, one for panic. Some of Harris' writing for Jason was the most touching of the night, for me; when Jason grieves the death of a loved one, Peter sings with such a weak, scared, *unmanly* sound that you'd have to be a robot to ignore. This is the most meaty, layered character I've seen Peter play, and I really hope we get to hear more of him with Tapestry.

**Greg**: James MacLean as the President cut an impressive figure on that stage. His full throated Lyric tenor sailed through Harris's music. He was affable, gregarious, and charismatic, making his reaction to his daughter's murder so poignant when you see all those layers of charm stripped away. 

**Jenna**: Tenor James McLean was loud and exaggerated as The President; I loved how he sang as though he were always on an election campaign, very sensationalist and confident. It set him up beautifully for the tragedy later in the show; the fall of the strong, in-charge man is always unsettling.

**Greg**: I've never hated Jacqueline Woodley more. (Don't worry, I said that to her face). Actually, what I mean was she was excellent as Dahlia. Her velvety soprano coupled with her acting chops lent a special kind of venom to the passive aggression her character uses as such a sharp weapon. 

**Jenna**: Jacqueline Woodley as the President's daughter, Dahlia, was a total standout performance for me. She was a beautiful foil to M'dea, whose wild curls and flowing costumes are a stark contrast to Dahlia's smooth, fitted dresses and gleaming white smile. Like a true White House lady, perhaps, I started off liking Dahlia, and with one scene she turned on a dime. Jacqueline had a fantastic self-important sashay and carefully chosen words with their accompanying smiles. Very Claire Underwood. Vocally, I loved how Harris wrote Dahlia's part; calm and calculated small-talk turned into cutting, deliberate classist insults, and Dahlia's music goes from Mélisande to somewhere between Lulu and the Queen of the Night at her most shrieky. Jacqueline was a stunning actor, too; it's hard to hate such a lovely lady (but I did for a bit).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432735392941/M'Dea-Undone-Featuring-Lauren-Segal---photo-by-Dahlia-Katz.jpg.jpg)
<figcaption>Lauren Segal. Photo by Dahlia Katz.</figcaption>
</figure>

**Greg**: I really felt like I was watching a movie. Harris's score felt as though the orchestra, who played amazingly under Jordan de Souza's capable baton, were underscoring a film. Unlike traditional operatic writing, there was no doubling of any of the vocal parts which helped the dialogue to stand out the way you need it to. It reminded me of Howard Shore that way (not in tonality or composition style) but the technical execution of the orchestra to enhance the dramatic impulse was very similar to Shore's work in film #imho. Harmonically and melodically, I felt it was akin to a lot of exciting Canadian composers, but I couldn't shake the thought of how Sondheimian the marriage of text and music was. And since he's my fave (sorry Verdi), I have to say Harris is doing phenomenal work. 

**Jenna**: I've not been struck by the music of a new opera in a long time. Harris' score seemed to be speaking as M'dea throughout the show; there were sunny moments of happiness, then one violin would sourly slide a pitch down, beautifully set with the words that would scare M'dea the most, like when Dahlia says the name, "Jason." The music had my attention, as though it were another character in the story; it was atmospheric, but specific and thoughtful. It too was another element of *M'dea Undone* that can't be cleanly pulled away from anything else we saw or heard. I'm really excited about this piece, and show it showed off some of Canada's hottest young singers in beautifully complex roles.

**Greg**: There are three more shows. Do yourself a favour. Go early, check the grounds, have some vino and enjoy some of the best opera, nay, theatre, that Toronto has offered us this season. Bravi, tutti.  

**Jenna**: Do as Greg says, and make time to see this show. It's an experience from the moment you pull off the Don Valley; gorgeous setting aside, the stuff of *M'dea Undone* will travel well to (hopefully) plenty more venues. Bravo to the entire team on this operatic coup.

> *M'dea Undone* runs until July 29th. Follow the links below for details, and to purchase tickets.
