+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-05-04T17:33:00+01:00"
lastmod = "2016-05-04T18:00:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462379676267/2016-05-05---Pisaroni-as-Maometto-II---Photo-by-Michael-Cooper.jpg.jpg"
primary_image_credit = "Luca Pisaroni as Maometto II in the Canadian Opera Company's production of Maometto II. Photo: Michael Cooper."
publishDate = "2016-05-04T18:00:00+01:00"
related_articles = ["articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-leah-crocetto.md","articles/talking-with-singers-elizabeth-deshong.md","articles/in-review-carmen-at-the-coc.md","articles/review-sondra-slays-in-bellini-masterwork.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/the-santa-fe-opera.md"]
related_people = ["scene/people/luca-pisaroni.md","scene/people/leah-crocetto.md","scene/people/elizabeth-deshong.md","scene/people/harry-bicket.md"]
short_description = "David Alden&#039;s production of Maometto, a work that until the revival in Santa Fe in 2012 hadn&#039;t been performed in it&#039;s entirety since Naples in 1820, was exactly what I think the COC needed in its season at this point. A simple, easy to digest set and staging, with a thrilling orchestra and incomparable vocals. I can&#039;t... I just can&#039;t get over the voices I heard last night."
slug = "in-review-maometto-ii"
title = "In review: Maometto II"
+++

The Four Seasons Centre for the Performing Arts in downtown Toronto was packed to the rafters last night for the third performance of Gioachino Rossini's rarely performed [*Maometto II*](http://www.coc.ca/PerformancesAndTickets/1516Season/MaomettoII.aspx), with libretto by Cesare della Valle. 

In an opera seria by a composer unjustly pigeon-holed by his super-successful comedies, Rossini shows us he knows how to deliver both musically and dramatically. The score is more through-composed than other opera seria, which tend to follow the "recit + aria + ensemble = opera" formula. The first act, actually, rarely provides the audience the chance to applaud, which is something we won't see on the regular until Wagner's time. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462380409257/2016-05-05---Crocetto-as-Anna-Female-Chorus---Photo-by-Michael-Cooper.jpg.jpg)
<figcaption>Leah Crocetto as Anna (kneeling) in the COC’s production of *Maometto II*, 2016, photo: Michael Cooper
</figcaption>
</figure>

David Alden's production of *Maometto*, a work that until its revival in Santa Fe in 2012 hadn't been performed in its entirety since Naples in 1820, was exactly what I think the COC needed in its season at this point. A simple, easy to digest set and staging, with a thrilling orchestra and incomparable vocals. I can't... I just can't get over the voices I heard last night. The set and costume design by Jon Morrell easily helped with making the distinction between the "noble" Venetians and the "barbaric" Muslims. I really liked this approach because the material itself belies this idea. We hear Maometto II being described as savage and fearful. When we finally meet him, yes, he's dark-clad and cuts an impressive figure across the stage, but we see a more worldly and noble man than we're led to believe has ransacked Constantinople and has now come for Negroponte. 

In the title role [Luca Pisaroni](/talking-with-singers-luca-pisaroni/) is clearly a star. Not a celebrity, not "flavour-of-the-month", but a bonafide star. He struts around the stage proudly and produces an heroic bass-baritone sound that sails over the orchestra, which is quite large. I found Maometto's singing range to lie in dangerous mid-voice territory (this is a feeling I had for most of the roles in this opera) for singing out over the pit, but he showed that problem who's boss, and in spades. His rousing aria in Act II after his somewhat conflicted duet with Anna is some of the best baritone work I've heard in a long time, full-throated without sacrificing the beauty and skill needed to produce the most desirable sound for Rossini opera seria. All the while, he never once compromising his dramatic intent. And the breath, oh my goodness, the breath. I swear this dude has nine lungs. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462380462160/2016-05-05---Sledge-as-Erisso-Crocetto-as-Anna-DeShong-as-Calbo---Photo-by-Michael-Cooper.jpg.jpg)
<figcaption>(l-r) Bruce Sledge as Paolo Erisso, Leah Crocetto as Anna and Elizabeth DeShong as Calbo in the COC’s production of *Maometto II*, 2016, photo: Michael Cooper.</figcaption>
</figure>

As Anna, [Leah Crocetto](/talking-with-singers-leah-crocetto.) had me. I fell in love. The divine Ms. Crocetto is the perfect response to the recent spate of 'fat-shaming' [(Brit)-crits](/once-agan-shushing-meanies/). She was tender, and beautiful, and graceful, and sexy, and desirable, and above all, *talented*. This girl can wail. There wasn't a moment when she was onstage when I wasn't transfixed by something she was doing. As I mentioned above, I found all the roles kind of 'mid-voicey', but there's a shift in the writing for Anna in Act II and it starts sitting closer to full Verdi soprano territory. The effect when she reaches her apogees is thrilling. I can't wait to hear more of her beautiful voice. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462380483591/2016-05-05---Maometto-MC-0287.jpg.jpg)
<figcaption>(l-r) Elizabeth DeShong as Calbo and Leah Crocetto as Anna in the COC’s production of *Maometto II*, 2016, photo: Michael Cooper.</figcaption>
</figure>

[Elizabeth DeShong](/talking-with-singers-elizabeth-deshong/) is destructive as Calbo. Her mannerisms in a pants role are a little exaggerated for my taste, but the singing, dear lord, the singing. Her Act II aria literally (and rightfully) stopped the show dead in its tracks, and it was one of the few times the audience was allowed to really appreciate the magic happening on stage. Her range, her flexibility, her communication were all top-drawer. I'm not entirely sure, but this may be the first time I bestow this honour upon a female, but she definitely stole the #TripleSwoonTimesInfinity right out of Pisaroni's hands. (I still love you though, boo.) Honestly and seriously, though, lyric mezzos take note: this is how you *bel canto*. Full Stop. It is worth the price of a ticket just to hear her Act II aria. 

As Paolo Erisso, making his COC Debut was tenor [Bruce Sledge](/scene/people/bruce-sledge/). A bright, forward sound with lots of muscle and agility are what he brought to this Venetian noble, and it was exhilarating from start to finish. When singing alone he had a mastery of range and colours that suited Rossini's pizzicato accompaniments in the pit but an impressive size and quality when singing over the chorus. I deeply enjoyed his work in the small ensembles, in particular the two trios he has with Crocetto and DeShong. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462380497307/2016-05-05---Pisaroni-as-Maometto-II-Sledge-as-Erisso---Photo-by-Michael-Cooper.jpg.jpg)
<figcaption>(l-r) Luca Pisaroni as Maometto II and Bruce Sledge as Paolo Erisso in the COC’s production of *Maometto II*, 2016, photo: Michael Cooper.</figcaption>
</figure>

Pulling comprimario duty on this production were COC Ensemble Studio members [Charles Sy](/scene/people/charles/sy/) and [Aaron Sheppard](/scene/people/aaron-sheppard/) playing the roles of Condulmiero and Selimo respectively. While the two didn't have much in regards to music, it was great to see young, fresh, Canadian talent filling out the ranks of this production. Bravi, gente! 

As always, the COC Chorus and Orchestra, under maestro Harry Bicket, are in top-form, reminding us all why it's such a coveted gig among the classical music elite in Canada.

In the words of [opera newbie Malcolm Vella](/newbies-at-the-opera/), "It's exactly what I imagine when I think of an opera." And I agree. One. Billion. Percent. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462380734414/2016-05-05---Maometto-GB-85.jpg.jpg)
<figcaption>Luca Pisaroni as Maometto II (centre) in the COC’s production of *Maometto II*, 2016, photo: Gary Beechey.</figcaption>
</figure>

This production has four more showings and you can (read: MUST) buy [tickets here](http://www.coc.ca/PerformancesAndTickets/1516Season/MaomettoII.aspx). You'll thank me afterwards.
