+++
author = ["authors/greg.md"]
categories = "Review"
date = "2014-10-16T15:57:00-04:00"
lastmod = "2015-04-14T14:14:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429035102925/Butterfly-MC-1291.jpg.jpg"
primary_image_credit = "Patricia Racette as Cio-Cio San. Photo by MIchael Cooper"
publishDate = "2014-10-16T15:57:00-04:00"
related_articles = ["articles/talking-with-singers-elizabeth-deshong.md","articles/birdcalls-and-spoilers.md","articles/in-review-madam-butterfly-at-eno.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/elizabeth-deshong.md","scene/people/patricia-racette.md","scene/people/patrick-lange.md"]
short_description = "On Wednesday, October 15th I made my way on over the Four Seasons Centre at University and Queen Street West to check out the Canadian Opera Company‘s production of Madama Butterfly by Giacomo Puccini (duh, Greg.)g"
slug = "in-review-madama-butterfly"
title = "In review: Madama Butterfly"
+++

On Wednesday, October 15th I made my way on over the Four Seasons Centre at University and Queen Street West to check out the [Canadian Opera Company](http://www.coc.ca/Home.aspx)'s production of [_Madama Butterfly_](http://www.coc.ca/PerformancesAndTickets/1415Season/MadamaButterfly.aspx) by Giacomo Puccini (duh, Greg.)
Let me preface this by saying one thing: the music is beautiful, the story is not. I don't have the emotional, visceral attachment to this piece that other people have. I can't explain why - well, actually I can, but that's a completely different piece for another time here at Schmopera.

So the story... American Soldier Benjamin Franklin (B. F.) Pinkerton comes to Japan aboard the _Abraham Lincoln_ and somehow finds himself leasing a house atop a hill in Nagasaki for 999 years (luckily, in Japan he has the option to cancel at anytime). He's also set to marry a young geisha (another contract he can cancel at anytime) from the village Cio-Cio San, called Butterfly. Goro, the wedding/real estate/gossip broker has arranged the deal and is showing Pinkerton his new house, when Sharpless, the American consul in Nagasaki shows up to try and talk some sense into Pinkerton. He learns the intended bride is only fifteen years old and registers proper "western" disgust at the idea (which librettists Giuseppe Giacosa and Luigi Illica deftly juxtapose against Butterfly's own statement that she is 'past her prime' at a whopping fifteen years old.) The wedding happens in a blitz and we discover that Cio-Cio San has decided to convert to Christianity for her husband, forsaking her family and heritage. Unfortunately for her, her secret trip to the monastery was discovered, and now she's on the receiving end of an entire familial shunning. Obviously not what she had intended. The family storms off/are removed by Pinkerton and the mood changes quickly to that of trying to convince a young teenage girl to consummate a marriage. Which... happens.

In the second act we see Butterfly and Suzuki, her maid, buzzing about the house with Suzuki trying to talk sense into Butterfly. It's been three years since Pinkerton sailed on the _Lincoln_ back to America, and there's been no contact at all. Suzuki is trying to make her realize he probably isn't coming back - just as Sharpless comes to deliver a letter saying EXACTLY that. Upon seeing Butterfly's excitement of Pinkerton's return (the _Lincoln_ has been spotted in the harbour by her and Suzuki), and watching her refuse the advances of a wealthy Yamadori, he doesn't have the heart to tell her that Pinkerton won't see her. He relents and shows up after Butterfly stays awake all night in vigil waiting for him. Upon greeting Suzuki and hearing of the grief it will cause Butterfly, Pinkerton runs off saying I'm a coward leaving Sharpless and Kate Pinkerton (B. F.'s American wife) to deal with the fallout and collect the child. After relinquishing her son, Sorrow, Cio-Cio San takes her own life, using the same blade her father committed suicide with at the demand of the Mikado. She expires as we hear Pinkerton wailing "Butterfly!!" in the distance.

So that's the story... here's what I thought.

From a design perspective, [Susan Benson](http://susanbensonart.com/design/)'s set is typically "Japanese" with the standard sliding doors set up that are key to the opening of the piece. Set on a raked stage (higher upstage than down) to add perspective and clear sight lines in large crowds. I get the feeling of the whole colour palette being washed out by the sun. It gives the air of the former glory of Cio-Cio San's family's wealthier days, but showing the passage of time can be harsh on anything, not just a person's face. My eyes craved a shock of colour here and there. We get a bit when the wealthy Yamadori arrives. The lighting was simple and effective with the only real "effect" happening during Butterfly's vigil.

There aren't many different ways you can present _Madama Butterfly_. Luckily the music is lush, complex and Puccini. The show starts off at a clip with Goro ([Julius Ahn](http://www.juliusahn.com/)) ably running about the stage ordering the supers, who were assembling the set (a series of movable walls with sliding rice paper slats) to represent the house. A snafu with the set assembly gave us a chance to see why good [comprimarios](http://en.wikipedia.org/wiki/Comprimario) are so important. While the supers were fixing the tech issue _a vista_ (in full view of the audience) and the scene is clearly underway, Ahn deftly added some improvised staging and gestures all the while staying on top of his connection with the conductor and orchestra. It's one of the myriad of things I love about live theatre, seeing a professional solve a problem in real time. Bravo, Mr. Ahn.

Enter the Americans... ugh. *

To be fair, Pinkerton ([Stefano Secco](http://www.stefanosecco.com/)) has the dubious distinction of having is ulterior motives, and unsavoury plot known to the audience from the get-go. He's about to use, abuse, and discard Cio-Cio San, although thanks to Giacosa and Illica he says it a little more poetically than I. I saw a distaste for American culture that's inherent in the dialogue of both Pinkerton and Sharpless ([Dwayne Croft](http://imgartists.com/artist/dwayne_croft)). Secco's tenor is lovely, italianate, open, free and quite muscular in the extreme upper registers - great for Puccini. I felt like he wasn't actually connecting emotionally with what he was saying. I do believe there's a time and a place for presentational theatre, but I felt like he spent most of his time poorly negotiating the proscenium arch and the fourth wall. As an actor I believe it's impossible to connect with the other characters in your universe if there's no genuine eye contact. You're not communicating otherwise, and I felt that a lot with this Pinkerton. However is gruffness and dare-I-say rudeness when he's inspecting the house at the top of the show, did add a more believable layer to him when it came to kicking the family out and then later when he lasciviously can only focus on getting Butterfly into the sack for a little makin' whoopee. I felt the darker vowels tended to get swallowed in the back of the throat, but for the most part it sailed out quite easily over the orchestra.

As Sharpless I found Croft's voice a little too _cupo_. It has a beautiful, natural colour and texture that reminds me of the whiskey his character imbibes on stage, but instead of getting a 15-yr-old scotch I feel like I got a decent Bourbon. It's great and all, but didn't have the 'bite' or the 'ping' I was looking for. The swagger and characterization he brought to the American consul was wonderful, despite the fact that I felt he may have been a bit uncomfortable performing on a raked stage. I found his tone lovely, open and free with just the right amount of age-colouring to make you believe him, yet when paired with Secco, I found his tone to retreat into the back of his throat a bit as well. He wore a GREAT suit, though...

As Goro, I have to doff my cap to [Mr. Ahn](http://www.juliusahn.com/). Flying around that stage, singing some very pattery dialogue and singing with a light, free, and open tenor that had an agility that sparkled on the few runs and flourishes Puccini gave him. Suzuki's assault is a full-on physical attack, executed in such a complete physicality that it makes me excited for the future of opera if our comprimarios (like in [_Falstaff_](http://www.coc.ca/PerformancesAndTickets/1415Season/Falstaff.aspx)) are doing such excellent stage/character/physical work while still providing beautiful singing.

Speaking of Beautiful singing, can we all just take a moment for [Elizabeth DeShong](http://www.elizabethdeshong.com/)?

... Thanks.

Holy crap I loved her. I feel like I know want to see all of _Butterfly_ only from Suzuki's perspective. Less naïve than her counterpart Butterfly, she lets us see that in her physical stance, her physiognomy, and voice all lend a credible level of worldliness and you really feel and see and empathize with her desire to protect Cio-Cio San. Her voice is full and luscious with a low register that tickles me in fun places. Her shifts from ecstatic happiness alongside Cio-Cio San to her rage at discovering Goro gossiping about Butterfly's son, Sorrow, show a talented actress who can also act with her voice. During Act III, she's a wonder. Her emotional journey is a roller-coaster and it's the first time I really felt Suzuki's stake in all this. The few moments where I was on the verge of tears, they were at the hands of her deft work on the stage.

And then there's [Patricia Racette](http://patriciaracette.com/).

Ms. Racette is [widely lauded](http://www.sfgate.com/music/article/Madama-Butterfly-review-Patricia-Racette-lifts-5556813.php) for her portrayal of Butterfly, and I can totally see why. A beautifully nuanced, full, visceral, lyric soprano that had true excitement in her pianos as well as her fortes. Her management of the naïveté of young teenager as well as the manic mood swings we were all known for added much needed depth to Cio-Cio San who really spends almost the entire show on stage after her Act I entrance. The role and the singer are each a _tour de force_ and I recommend any time you get the chance to hear Racette sing Puccini - do it. Tasteful portamenti, respect for tempi, as well as an elastic, organic use of rallentando remind us why we like Puccini in the first place.

Un Bel Di was breathtaking. #fullstop.

The chorus was excellent ,and the humming chorus lived up the the anticipation I had built up in my mind for it. Bravi, tutti!!

For me the highlight definitely had to be the COC orchestra under [Patrick Lange](http://www.artistsman.com/home/kuenstler_verzeichnis/dirigent/patrick-lange/)'s (#tripleswoontimesinfinity) masterful hand. The blend in the strings and the seamless passing of melody from winds to strings married perfectly for this schmaltzy, movie-music kind of score. With wonderful quotes of Americana during act I and the suspense of the ostinato timpani in Act III. Most of the time, it looked as though Lange and his orchestra were dancing together. All bodies and music moving at the same time in the same direction was really quite something to experience. Bravi tutti.

So in short, if you like _Butterfly_, you'll love this production. Clean, forward, traditional. If you don't like _Butterfly_, go see it for Racette, DeShong, and the orchestra. You will not be disappointed.

Honourable Mention to Jennifer Szeto and Jenna Douglas (of [Schmopera](http://schmopera.com/)) rocking some serious [birdcalls](/birdcalls-and-spoilers/) at the top of Act III. * - in reference to the American characters in the opera, not Americans in general.
