+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-05-19T09:55:00+01:00"
lastmod = "2016-05-19T13:42:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463651208261/2016-05-19---ENO-Madam-Butterfly-Rena-Harms-Tom-Bowles.jpg.jpg"
primary_image_credit = "Rena Harms as Cio-Cio San in Madam Butterfly. Photo: Tom Bowles/English National Opera."
publishDate = "2016-05-19T11:34:00+01:00"
related_articles = ["articles/in-review-enos-the-magic-flute.md","articles/in-review-madama-butterfly.md","articles/in-review-tristan-and-isolde-at-eno.md","articles/in-review-don-giovanni-at-eno.md","articles/in-review-lulu-at-eno.md","articles/rohs-madama-butterfly-better-to-be-furious-than-bored.md","articles/making-the-connection-madama-butterfly-in-manitoba.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/david-butt-philip.md","scene/people/alun-rhysjenkins.md"]
short_description = "A silent, stunning tableau, featuring dancer Ayano Honda in silhouette against a wash of saturated red, began the story; it gave way to a stage full of puppeteers, who spent the evening moving sets, providing ambient lighting, and playing a flock of birds. They smoothed the lines between the story&#039;s characters and the &quot;unseen&quot; bodies onstage, who also included three puppeteers bringing Cio-Cio San&#039;s son, Sorrow, to heartbreaking life."
slug = "in-review-madam-butterfly-at-eno"
title = "In review: Madam Butterfly at ENO"
+++

Last night at the London Coliseum, we had the chance to hear live the late Anthony Minghella's production of [*Madam Butterfly*](https://www.eno.org/whats-on/madam-butterfly/), which was created by [English National Opera](/scene/companies/english-national-opera/) in 2005. With Michael Levine's simplistic and arresting set design, and delicious costumes by Han Feng, this treatment of *Butterfly* is one that seems to cling beautifully to those details in the libretto that have become uncomfortably affecting for contemporary audiences. The live singers find themselves in the middle of Bunraku performance, or Japanese puppet theatre, making brutal clarity out of all the times that Benjamin Franklin Pinkerton refers to Cio-Cio San as a plaything, a toy, anything but a woman.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463651258329/2016-05-19---ENO-Madam-Butterfly-Ayano-Honda-Tom-Bowles.jpg.jpg)
<figcaption>Ayano Honda in ENO's *Madam Butterfly*. Photo: Tom Bowles.</figcaption>
</figure>

A silent, stunning tableau, featuring dancer Ayano Honda in silhouette against a wash of saturated red, began the story; it gave way to a stage full of puppeteers, who spent the evening moving sets, providing ambient lighting, and playing a [flock of birds](/birdcalls-and-spoilers/). They smoothed the lines between the story's characters and the "unseen" bodies onstage, who also included three puppeteers bringing Cio-Cio San's son, Sorrow, to heartbreaking life.

Tenor [David Butt Philip](/scene/people/david-butt-philip/) wowed as Pinkerton, a role debut for him. He had an enormous, thrilling sound that screamed of the Lieutenant's zest for life and horridly misplaced concept of the world's being his oyster. His sound felt so American, and we were struck by how Philip's Pinkerton seemed less dismissive and patronizing, and more ignorant in the truest sense of the word. His cultural blunders were no embarrassment, and he seemed completely satisfied with his own surface-level understanding of Japanese society. One could *almost* forgive him.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463651286948/2016-05-19---ENO-Madam-Butterfly-Rena-Harms-and-David-Butt-Philip-1-Tom-Bowles.jpg.jpg)
<figcaption>Rena Harms (Cio-Cio San) and David Butt Philip (Pinkerton) in ENO's *Madam Butterfly*. Photo: Tom Bowles.</figcaption>
</figure>

[Rena Harms](/scene/people/rena-harms/) was the perfect balance of child-like, optimistic, and strong as Cio-Cio San. Her bright sound echoed her characterization, and she had a knack for trading soaring phrases with matter-of-fact, immediate deliveries of the more banal, even funny moments in the score. *Butterfly* can be infuriating enough, and our sympathy can depend entirely on whether or not we like Cio-Cio San; we loved Harms, and her dramatic trip throughout the show earned more than enough sympathy from the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463651701197/2016-05-19---ENO-Madam-Butterfly-Rena-Harms-and-George-von-Bergen-Tom-Bowles.jpg.jpg)
<figcaption>Rena Harms (Cio-Cio San) and George von Bergen (Sharpless) in ENO's *Madam Butterfly*. Photo: Tom Bowles.</figcaption>
</figure>

As Sharpless, [George von Bergen](/scene/people/george-von-bergen/) stole the show as often as he was onstage. His healthy baritone helped us understand the US consul immediately. He had a beautiful way of being entirely unimpressed with Pinkerton and with the novelties of Nagasaki, yet he was never condescending or patronizing, even to humour his fellow American. He reminded us of a combination of Woody Harrelson and Nick Offerman; that's a really great combination.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463651818802/2016-05-19---ENO-Madam_Butterfly-Sorrow-with-Rena-Harms-and-Stephanie-Windsor-Lewis-1-Tom-Bowles.jpg.jpg)
<figcaption>Sorrow with Rena Harms (Cio-Cio San) and Stephanie Windsor-Lewis (Suzuki) in ENO's *Madam Butterfly*. Photo: Tom Bowles.</figcaption>
</figure>

[Stephanie Windsor-Lewis](/scene/people/stephanie-windsor-lewis/) was a lovely Suzuki, both in voice and demeanour. Suzuki is one of our favourite characters in opera, and Windsor-Lewis did a beautiful job of unfolding herself from almost nameless servant to Cio-Cio San's only source of support. [Alun Rhys-Jenkins](/scene/people/alyn-rhys-jenkins/) was an annoying, yet still likeable Goro; he had all the makings of a salesman, and a great immediacy of sound. 

*Butterfly* is an opera that, like *La bohème*, gets us in the feels every time we hear it. There were several moments throughout the night that felt crowded and rushed, and the problem seemed to be in the pit. Sir Richard Armstrong led the ENO Orchestra, and though it was refreshing to hear some of his brisk tempi, there were moments where it seemed that Armstrong had little sympathy for the story, or the singing. He didn't seem to be listening, or feeling. The Act I duet, the Flower Duet, the Humming Chorus, and Cio-Cio San's final outcry to her son, they all felt matter-of-fact, stubbornly *a tempo* with no apparent room for drama. The singers did a wonderful job of making it work, but their singing left no doubt that it would have been worth it to hear more patience and schmaltz from Armstrong.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463651911976/2016-05-19---ENO-Madam-Butterfly-Rena-Harms-and-ENO-Chorus-Tom-Bowles.jpg.jpg)
<figcaption>Rena Harms (Cio-Cio San) and the ENO Chorus in ENO's *Madam Butterfly*. Photo: Tom Bowles.</figcaption>
</figure>

This *Butterfly* also had two intermissions, and that's a problem. The set change between acts II and III didn't seem overly complicated, and breaking up the end of the Humming Chorus and the beginning of the orchestra interlude entirely interrupts the intensity of Cio-Cio San's waiting. We were on an emotional edge by the end of act II, and that second intermission robbed us of carrying it through to the horrible moments in act III.

Still, the piece packs a punch because of the stellar cast and the production's evocative storytelling. Running until July 7, there are 15 remaining performances of [*Madam Butterfly*](https://www.eno.org/whats-on/madam-butterfly/), and it's one you'll want to catch. For details and ticket information, follow our box office links below.
