+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-04-08T10:27:00+01:00"
lastmod = "2017-01-09T10:29:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460109525136/2016-04-08---PR8A1676-DIANA-DAMRAU-AS-LUCIA-ROH-PHOTOGRAPHER-STEPHEN-CUMMISKEY.jpg.jpg"
primary_image_credit = "Diana Damrau as Lucia in the ROH's Lucia di Lammermoor. Photo by Stephen Cummiskey."
publishDate = "2016-04-08T11:24:00+01:00"
related_articles = ["articles/in-review-tcherniakovs-don-giovanni.md","articles/when-critics-are-jerks.md","articles/once-agan-shushing-meanies.md","articles/in-review-tannhauser-at-roh.md","articles/in-review-norma-at-roh.md","articles/in-review-cosi-fan-tutte-at-roh.md","articles/in-review-les-contes-dhoffmann.md","articles/in-review-il-trovatore-at-roh.md","articles/in-review-der-rosenkavalier-at-roh.md","articles/in-review-la-traviata-at-roh.md","articles/booing-at-the-opera-why.md","articles/in-review-adriana-lecouvreur-at-roh.md","articles/in-review-the-exterminating-angel-at-roh.md","articles/a-lucia-with-agency-and-independence-at-the-royal-opera-house.md","articles/a-luminous-lucia-at-florida-grand-opera.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/diana-damrau.md","scene/people/charles-castronovo.md","scene/people/ludovic-tezier.md"]
short_description = "There was Lucia, embodying the most horrible, messy, inappropriate and inconvenient lows in a woman&#039;s life. By showing us all these unseen scenes, Mitchell managed to create a real relationship not only between Lucia and Edgardo, but between Lucia and Alisa, sung and acted beautifully by Rachael Lloyd. The gross differences between victory and loss, men&#039;s stories and women&#039;s, were powerful."
slug = "in-review-lucia-di-lammermoor-at-roh"
title = "In review: Lucia di Lammermoor at ROH"
+++

The hype surrounding [Katie Mitchell](http://www.roh.org.uk/people/katie-mitchell)'s new production of *Lucia di Lammermoor*, currently on at the [Royal Opera House](/scene/companies/royal-opera-house/), was no empty threat. Much had been made of the warnings sent out to subscribers that this *Lucia* would feature violence and shocking scenes, and [Diana Damrau](/scene/people/diana-damrau/) herself [told *The Guardian*](http://www.theguardian.com/music/2016/mar/20/be-ready-for-blood-diana-damrau) that audiences would feel "shaken" after seeing it. "Shaken" is right, in every positive meaning of that word.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460109680368/2016-04-08---PR8A2773-DIANA-DAMRAU-AS-LUCIA-RACHAEL-LLOYD-AS-ALISA-ROH-PHOTOGRAPHER-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Diana Damrau as Lucia, Rachael Lloyd as Alisa, ROH. Photographer: Stephen Cummiskey.</figcaption>
</figure>

First, the singing. In the title role, Damrau was the most human Lucia we've ever seen. She sang an enormous arc of storytelling, beginning with beautiful soft and secretive singing in her Act I aria, and ending with a Mad Scene that was constantly beautiful, and a heartbreaking twist on "happiness". Every single note that she sang did something, went somewhere. She used the music to move, with an energy that kept her firmly outside the doll-like trope that is often the manipulated Lucia. Damrau's Lucia fights tooth and nail throughout her whole ordeal, yet neither was she stubborn nor aggressively naïve. She was a real person, even funny at times. She, with the brilliant work of Katie Mitchell, shut out the big objection we often have with Donizetti's opera, and that's the Case of the Spineless Woman. 

As her lover Edgardo, [Charles Castronovo](/scene/people/charles-castronovo/) was more perfection. His dark sound holds surprising agility, and he matched Damrau with risky soft singing and specific meaning in his vocal choices. He too was a real man, and the richness in his voice seemed to help Edgardo stand alone among the other supporting tenors. Together, Damrau and Castronovo were strong singing actors, executing what could have been an extremely risky "concept" in this production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460109816772/2016-04-08-0-PR8A0538-DIANA-DAMRAU-AS-LUCIA-CHARLES-CASTRONOVO-AS-EDGARDO-ROH-PHOTOGRAPHER-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Diana Damrau as Lucia, Charles Castronovo as Edgardo, ROH. Photographer: Stephen Cummiskey.</figcaption>
</figure>

Ludovic Tézier's Enrico was strong and menacing, with a laser-like focus to his sound and a thrilling high extension. He too had a darkness in his sound, which served him in a different way than Castronovo's Edgardo. Tézier was a dangerous brother to Lucia, almost robotic in his obsession with familial legacy and having his orders executed. There was a coldness in his performance that was foiled by Kwangchul Youn's Raimondo. Youn's sound stayed beautiful and rich, and there was something benevolent in his delivery of what are some of the most frustrating lines in the show.

At its most basic, Katie Mitchell's production is feminist. More interestingly, it landed on the successful side of what can be considered a director's superimposition of a new story. We've [discussed in depth](/panel-regietheater/) the fine line between a director who uses an existing opera to [tell a story that isn't there](/concept-production-real-reason/), and one who uncovers something hidden and organic instead. Readers, take note: **spoilers ahead**.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460110040142/2016-04-08---SC1_7536-PRODUCTION-IMAGE-ROH-PHOTOGRAPHER-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Photographer: Stephen Cummiskey.</figcaption>
</figure>

Mitchell, along with designer Vicki Mortimer, spent the entire production revealing information. Each scene was visually split in two, with action happening in real time, in two separate rooms. Brilliantly, we were able to watch as Enrico and his henchmen snooped in Lucia's dressing room while she and Edgardo had one of their illicit trysts in the basement mausoleum. We saw Edgardo crawl through Lucia's window and discover in a real way that she was downstairs, signing a marriage contract to Arturo (much more effective than a cheesy bust-down-the-door tenor entrance).

The creative team earned a healthy amount of boos from the audience as they took their curtain calls, and it's easy to figure out what angered the crowd so. Lucia's first duet with Edgardo comes with a quickie scene; it could have been gratuitous, but it felt very real. Instantly we understood that this couple had the meet-and-screw routine down pat; they were exchanging practical information while checking off what was understandably a priority on their to-do list. Mitchell made sure the sex scene wasn't fluff, since it began an important arc that became the crux of Lucia's downfall. We later see Lucia hunched over a toilet, vomiting; in an impressively mimed scene, next door to the looming Enrico, Lucia and her maid, Alisa, conclude that she's pregnant. Another chance for fluffy shock value, but Mitchell's arc continued.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460110083730/2016-04-08---PR8A1524-LUDOVIC-TEZIER-AS-ENRICO-ASHTON-DIANA-DAMRAU-AS-LUCIA-ROH-PHOTOGRAPHER-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Ludovic Tézier as Enrico Ashton, Diana Damrau as Lucia, ROH. Photographer: Stephen Cummiskey.</figcaption>
</figure>

The split-scene trend also included a look at one of the biggest voids in Donizetti's score. As Edgardo and Enrico sing a stellar Wolf's Crag scene, we watch Lucia bind and blindfold her new husband under the guise of kinkiness, and she and Alisa clumsily stab and choke Arturo to death. More vomiting, a shattered Alisa, and then Lucia begins to miscarry. She staggers into the post-wedding billiards party drenched not in Arturo's blood, but her own. Damrau's Mad Scene was difficult to watch, and she was stunning in her switches from insanity to the real pain that brings her into moments of lucidity.

There was Lucia, embodying the most horrible, messy, inappropriate and inconvenient lows in a woman's life. By showing us all these unseen scenes, Mitchell managed to create a real relationship not only between Lucia and Edgardo, but between Lucia and Alisa, sung and acted beautifully by Rachael Lloyd. The gross differences between victory and loss, men's stories and women's, were powerful. There was a horrifying contrast in the final scene, with Lucia's running bath infecting the sound of Castronovo's unreal singing of his last aria. This is what it means to have a "feminist take" on an opera, and the combination of opportunity and choice were complete and organic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1460110127101/2016-04-08---PR8A3391-CHARLES-CASTRONOVO-AS-EDGARDO-DIANA-DAMRAU-AS-LUCIA-ROH.-PHOTOGRAPHER-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Charles Castronovo as Edgardo, Diana Damrau as Lucia, ROH. Photographer: Stephen Cummiskey.</figcaption>
</figure>

It's a production that will stay in our minds for a long time, and it's one that depends on all parties in the creative process. The design, the concept, the carefully crafted acting by the singers, all of these elements are inter-dependent, and the production could so easily have fallen into the land of feminist flailings. The shouts of "bravo" were offensively hurled in response to the loud boos, and it seemed so obvious that with their reactions, the audience had exactly mirrored the contrast on Mitchell's stage.

Go. Go and see this production. Hate it or love it, you *will not* forget it.

>For details and ticket information about ROH's Lucia di Lammermoor, follow our box office links below.
