+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-10-08T23:23:00-04:00"
lastmod = "2015-10-09T11:53:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444360426087/Traviata-MC-1052Square.jpg.jpg"
primary_image_credit = "Charles Castronovo as Alfredo and Ekaterina Siurina as Violetta in La Traviata, 2015. Photo: Michael Cooper."
publishDate = "2015-10-09T11:29:00-04:00"
related_articles = ["articles/in-review-la-traviata-at-roh.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/ekaterina-siurina.md","scene/people/charles-castronovo.md","scene/people/quinn-kelsey.md","scene/people/marco-guidarini.md","scene/people/james-westman.md","scene/people/aviva-fortunata.md","scene/people/lauren-segal.md","scene/people/robert-gleadow.md","scene/people/iain-macneil.md","scene/people/charles-sy.md"]
short_description = "Last night the Canadian Opera Company opened its new production of La traviata, and I was officially excited. La traviata is done often, but it&#039;s another thing to hear it done really well. I got my fix at the Four Seasons Centre with the first of two casts singing the 11 shows between now and November 6th."
slug = "in-review-la-traviata-at-the-coc"
title = "In review: La traviata at the COC"
+++

Last night the [Canadian Opera Company](/scene/canadian-opera-company/) opened its new production of [*La traviata*](http://coc.ca/PerformancesAndTickets/1516Season/LaTraviata.aspx), and I was officially excited. *La traviata* is done often, but it's another thing to hear it done really well. I got my fix at the Four Seasons Centre with the first of two casts singing the 11 shows between now and November 6th.

First thing's first: the music, under the baton of maestro [Marco Guidarini](/scene/people/marco-guidarini/), sounded absolutely stunning. Those first chords of the score are notoriously gorgeous, and the COC Orchestra began the evening with a truly special sound. Guidarini kept a great mix of indulgence and pacing, including a few brisk tempi when the score needs it. Best of all, the orchestra was always transparent, Verdi's layers stacked audibly on top of each other; under Guidarini, I learned new things about this music. Love when that happens.

I think it's a significant thing to see a *La traviata* directed by a woman. [Arin Arbus](http://www.theglobeandmail.com/arts/theatre-and-performance/arin-arbus-on-directing-canadian-opera-companys-la-traviata/article26686733/)'s production starts with a glimpse into the relationship between Violetta and her maid, Annina. Behind a beautiful lace srim, Annina helps Violetta into her big gown; the scene suggested this is a nightly routine for the two women, Annina prepping Violetta for a night at work. I thought it was a beautifully mundane way to begin the story, and Arbus set up a powerful mirror of this scene at the top of the final act (by this point, Annina works less as a dresser, and more as a nurse).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444360681175/Traviata-MC-0025Resized.jpg.jpg)<figcaption>Ekaterina Siurina as Violetta and Aviva Fortunata as Annina in the COC’s production of *La Traviata*, 2015. Photo: Michael Cooper.</figcaption>
</figure>

The tableau gives way to a party scene, and we were treated with the sight of fantastic sets and costumes by Riccardo Hernandez and Cait O'Connor. The costumes were eye candy, always something to look at. It make me think a bit of [Christopher Alden](/scene/people/christopher-alden/)'s *Die Fledermaus* a few seasons back. With Marcus Doshi's lighting (and the eerie shadows he created), Hernandez's sets seemed to morph; they're luxurious when full of people, barren and looming when empty.

As Violetta, soprano [Ekaterina Siurina](/scene/people/ekaterina-siurina/) brought a warm, gentle sound to the role. Her voice doesn't have the metallic brilliance that often comes with a Violetta; it meant that her character seemed less of an extroverted escort, and more like a woman with quiet magneticism. In truth, I missed some of the vocal fire. Siurina's sound was a bit small, and some passages seemed more careful than carefree. Her final aria, "Addio del passato," was her most lovely and honest singing of the night. I wondered if she finally felt free to let go in the last act, and I wished she had done it sooner, like in her Act II scene with Germont.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444360949708/Traviata-CH-157Resized.jpg.jpg)<figcaption>Charles Castronovo as Alfredo and Ekaterina Siurina as Violetta in the Canadian Opera Company's production of *La Traviata*, 2015. Photo: Chris Hutcheson
</figure>

[Charles Castronovo](/scene/people/charles-castronovo/) was an honest, heartfelt Alfredo. His sound is dark but flexible, and I liked how that strength made his Alfredo seem like he had a spine, a life outside of Violetta. He had a huge range of sound, including a wicked, fiery cabaletta to his Act II aria. I thought he was the strongest actor onstage, and he had beautiful onstage chemistry with Siurina, his real-life-wife. I found myself, for the first time, really invested in Alfredo as a protagonist of this story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444360797372/Traviata-MC-0406Resized.jpg.jpg)<figcaption>Quinn Kelsey as Germont and Ekaterina Siurina as Violetta in the COC’s production of *La Traviata*, 2015. Photo: Michael Cooper.</figcaption>
</figure>

Baritone [Quinn Kelsey](/scene/people/quinn-kelsey/) was one of the names I was particularly excited to hear, in one of his signature roles, Germont. I almost forgot how *beautiful* Quinn's sound is. I think it's so attractive to me because Kelsey keeps his singing very close to speaking. It's a throaty sound that always seems elastic, something Kelsey showed off best in his "Di Provenza," which had me heavy in my seat. I loved how Kelsey maintained the good side of his character; the father who's doing the best with what he knows is a sadder, more dangerous "villain" than a judgy dad. The last couple of times I've heard Kelsey, I've noticed a good amount of straight tone singing. I suppose it comes down to taste, but it seems a shame to use an effect like that so often, when Kelsey's natural, vibrating sound is honest-to-god-gorgeous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444360754141/Traviata-CH-124Resized.jpg.jpg)<figcaption>Lauren Segal as Flora (centre) in a scene from the Canadian Opera Company's production of *La Traviata*, 2015. Photo: Chris Hutcheson.</figcaption>
</figure>

The choreography by Austin McCormick livened up Flora's party scene, giving it a macabre, gender-bending affair with oversized bull skeletons inhabited by puppeteers. Mezzo-soprano [Lauren Segal](/scene/people/lauren-segal/) was a feisty Flora, one we felt like we got to know in her short moments of spotlight. I liked how Arbus had Dr. Grenvil, sung by [Robert Gleadow](/scene/people/robert-gleadow/), in the party scenes; it suggested one of the potential back stories to Grenvil's relationship with Violetta, he being a past client. 

Baritone [James Westman](/scene/people/james-westman/) whetted our appetites as the Baron Douphol; Westman steps into the role of Germont with the second cast. This is a signature role for Westman, too, and one I'm excited to hear. The COC Ensemble Studio represented with a few smaller roles. Soprano [Aviva Fortunata](/scene/people/aviva-fortunata/) was a compassionate, simple Annina, and bass-baritone [Iain MacNeil](/scene/people/iain-macneil/) was a dapper Marchese. New Ensemble member [Charles Sy](/scene/people/charles-sy/) made his Four Seasons Centre stage debut as Gastone.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444401801346/Traviata-MC-0097Resized.jpg.jpg)<figcaption>Robert Gleadow as Dr. Grenvil and Ekaterina Siurina as Violetta in the COC’s production of *La Traviata*, 2015. Photo: Michael Cooper</figcaption>
</figure>

I like this new production. It looks pretty slick, and all the right moments are in place. There were a few missed marks, like not always using the music to inform when and how a character should move. I'm very curious to hear the second cast, starring [Joyce El-Khoury](/scene/people/joyce-el-khoury/) and COC Ensemble Studio tenor [Andrew Haji](/scene/people/andrew-haji/); I think they'll bring an entirely different dynamic to the stage (and music), and answer a few questions I have about some of the scenes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444360579135/Traviata-MC-0590Resized.jpg.jpg)<figcaption>A scene from the COC’s production of *La Traviata*, 2015. Photo by Michael Cooper.</figcaption>
</figure>

My opinions aside, this *La traviata* is definitely a show to catch. The music is spectacular, and the production is alluring. The second cast takes the stage for three performances, beginning October 16th. There are 10 more shows in this run; for details and tickets, follow the box office links below.
