+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-01-26T13:31:00+00:00"
lastmod = "2017-01-26T17:07:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485448627035/2017-01-26---La-Traviata-13-01-17-ROH-1119x2-JOYCE-EL-KHOURY-AS-VIOLETTA-VALERY-SERGEY-ROMANOVSKY-AS-ALFREDO-GERMONT-ROH-PHOTO-BY-TRISTRAM-KENTON.jpg.jpg"
primary_image_credit = "Joyce El-Khoury (Violetta), Sergey Romanovsky (Alfredo) in La traviata, ROH, 2017. Photo: Tristam Kenton."
publishDate = "2017-01-26T17:00:00+00:00"
related_articles = ["articles/in-review-la-traviata-at-the-coc.md","articles/in-review-lucia-di-lammermoor-at-roh.md","articles/a-shining-violetta-in-washington.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/joyce-elkhoury.md","scene/people/artur-rucinski.md","scene/people/sergey-romanovsky.md"]
short_description = "The broad-strokes architecture of the opera&#039;s four sets are a clean contrast against the ladies&#039; luxurious dresses, even against the messy humanity of Verdi&#039;s simple, classic tale of love and the opinions of others. Joyce El-Khoury&#039;s Violetta comes with easy charisma, and a strong desire to maintain composure and dignity. El-Khoury matured along with Violetta&#039;s story, yet somehow retained a young voice, full of the best intentions. Her third-act aria, &quot;Addio del passato&quot; was the highlight of the night."
slug = "in-review-la-traviata-at-roh"
title = "In review: La traviata at ROH"
+++

For as much as we babble on about what's new and creative about opera, a good production of Verdi's [*La traviata*](http://www.roh.org.uk/productions/la-traviata-by-richard-eyre) can be like a palate cleanser, a reminder of the difference between so-called "museum pieces" and operas which are simply timeless.

Richard Eyre's production, since its premiere in 1994, is in its 14th revival. His staging backed Angela Gheorghiu's debut at the Royal Opera as Violetta that same year; this month, three more singers make their Covent Garden debuts: Lebanese-Canadian soprano [Joyce El-Khoury](/talking-with-singers-joyce-el-khoury/) as Violetta, Russian tenor [Sergey Romanovsky](/scene/people/sergey-romanovsky/) as Alfredo, and Polish baritone [Artur Puciński](/scene/people/artur-pucinski/) as Giorgio Germont.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485448689947/2017-01-26---La-Traviata-13-01-17-ROH-661-JOYCE-EL-KHOURY-AS-VIOLETTA-VALERY-ROH-PHOTO-BY-TRISTRAM-KENTON.jpg.jpg)
<figcaption>Joyce El-Khoury as Violetta Valéry, *La traviata*, ROH, 2017. Photo by Tristam Kenton.</figcaption>
</figure>

The broad-strokes architecture of the opera's four sets are a clean contrast against the ladies' luxurious dresses, even against the messy humanity of Verdi's simple, classic tale of love and the opinions of others. Joyce El-Khoury's Violetta comes with easy charisma, and a strong desire to maintain composure and dignity. El-Khoury matured along with Violetta's story, yet somehow retained a young voice, full of the best intentions. Her third-act aria, "Addio del passato" was the highlight of the night.

Romanovsky is an earnest Alfredo, who seemed truly tortured with his love for Violetta. His dark sound gave way to an exciting, almost throaty ring up top, and he sang with an impressive attention to detail. He and El-Khoury created an honest, understated picture of Alfredo and Violetta; they seemed to have found best friends in each other. (Well, for the most part.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485448698878/2017-01-26---La-Traviata-13-01-17-ROH-813-ARTUR-RUCINSKI-AS-GIORGIO-GERMONT-SERGEY-ROMANOVSKY-AS-ALFREDO-GERMONT-ROH-PHOTO-BY-TRISTRAM-KENTON.jpg.jpg)
<figcaption>Artur Rucińsky as Giorgio Germont and Sergey Romanovsky as Alfredo Germont, *La traviata*, ROH, 2017. Photo by Tristam Kenton.</figcaption>
</figure>

Puciński sings with all the refinement and cool emotional detachment of a Giorgio Germont. His aria earned some of the loudest applause of the evening, and at times we were convinced he had four lungs. His scene with El-Khoury was respectful, as though he had no reason to stoop to personal attacks (besides, of course, the digs at her self-esteem); his relationship with Alfredo had that uncomfortable familiarity of expectant, removed fathers and their captive sons.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485448719440/2017-01-26---La-Traviata-13-01-17-ROH-1387-JOYCE-EL-KHOURY-AS-VIOLETTA-VALERY-ROH-PHOTO-BY-TRISTRAM-KENTON.jpg.jpg)
<figcaption>Joyce El-Khoury as Violetta Vlaéry, *La traviata*, ROH, 2017. Photo by Tristam Kenton.</figcaption>
</figure>

Maestro Daniele Rustioni, an alumnus of the ROH's Jette Parker Young Artists Programme, led the Orchestra of the Royal Opera House through a flexible, lifelike score. Conductors who listen are a luxury, and it's a fascinating thing to hear an orchestra, playing a piece they surely know well, also listening intently to the singer above them. We only wished that Rustioni had kept the pace more often between numbers; the applause breaks seemed to make the story stutter, rather than holding listeners captive through the dramatic landscape. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485448730533/2017-01-26---La-Traviata-13-01-17-ROH-654-ARTUR-RUCINSKI-AS-GIORGIO-GERMONT-JOYCE-EL-KHOURY-AS-VIOLETTA-VALERY-ROH-PHOTO-BY-TRISTRAM-KENTON.jpg.jpg)
<figcaption>Artur Ruciński as Giorgio Germont and Joyce El-Khoury as Violetta Valéry, *La traviata*, ROH, 2017. Photo by Tristam Kenton.</figcaption>
</figure>

The ROH Chorus had great uniformity and great life; sadly, they seemed to fall into nearly every trap in Verdi's score. They collectively rushed in those tricky party scenes, a surprising thing considering how often this Chorus sings *La traviata*.

After over 20 seasons, Eyre's production of *La traviata* is smart one that stays out of the story's way; it's a vehicle all the chemistries that can come out of the various casts, perhaps not a blank slate, but free from heavy-handed "concept".

[*La traviata*](http://www.roh.org.uk/productions/la-traviata-by-richard-eyre), starring El-Khoury in the title role, runs at the ROH until February 1; the production returns in June 2017, featuring [Corinne Winters](/talking-with-singers-corinne-winters/) as Violetta. For full details and tickets, [click here.](http://www.roh.org.uk/productions/la-traviata-by-richard-eyre)
