+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-01-10T13:38:00+00:00"
lastmod = "2017-01-11T12:38:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484055574623/2017-01-10---La-Colla-Katzarava.jpg.jpg"
primary_image_credit = "Stefano La Colla, tenor, and Maria Katzarava, soprano."
publishDate = "2017-01-11T12:25:00+00:00"
related_articles = ["articles/ian-rosenblatt-its-all-about-the-voice.md","articles/in-review-alek-shrader-at-wigmore-hall.md","articles/in-review-jamie-barton-at-wigmore-hall.md"]
related_people = ["scene/people/maria-katzarava.md","scene/people/stefano-la-colla.md"]
short_description = "At the same time, Wigmore Hall is not conducive to an evening of opera scenes. The two singers seemed to fall into a groove, carved from their respective past performances of Butterfly or Turandot. They seemed to want to fill the recital stage with stuff, making up for the lack of sets and costumes and space, when instead they could have done less, and simply let their voices do the work."
slug = "in-review-la-colla-katzarava-in-recital"
title = "In review: La Colla &amp; Katzarava in recital"
+++

Many times, we've heard a common sentiment from opera singers about giving recitals: they're utterly terrifying. It's easy to understand why; recitals are intimate, and intimate can be scary. Everything about a singer - from the beauty of their sound, to their choices of repertoire - is subject to close scrutiny.

When an opera singer gives a recital, it's always fascinating for us to peruse their programme, and note how many items are plucked from the operas they know and love. It's noteworthy both when a programme is opera-free - like the recitals we heard by [Paul Appleby](/in-review-paul-appleby-at-wigmore-hall/) and [Jamie Barton](/in-review-jamie-barton-at-wigmore-hall/) - and when a recital is entirely opera-full.

Falling into the latter group was the programme by Mexican soprano [Maria Katzarava](/scene/people/maria-katzarava/) and Italian tenor [Stefano La Colla](/scene/people/stefano-la-colla/), with pianist [Simon Lepper](http://www.simonlepper.com/). Theirs was the latest in the [Rosenblatt Recitals Series](/ian-rosenblatt-its-all-about-the-voice/) at Wigmore Hall, and Katzarava and La Colla gave us a cross-section of the *verismo* repertoire which fills their operatic schedules. 

The two singers shared the stage, offering arias and duets from *Le Cid*, *Roméo et Juliette*, and all the big ones by Puccini. La Colla sang an impassioned "Recondita armonia", and Katzarava gave an impressive, grounded Poison Aria; her singing of Liù's aria from *Turandot* was a highlight of the evening.

The duets - juicy as they were - seemed to shed the wrong kind of light on opera-in-recital. Where the arias allowed La Colla and Katzarava to simply sing for their audience, the duets became encumbered with makeshift blocking on the small Wigmore stage. To be fair, the excerpts from *Tosca* and *Madama Butterfly* are certainly duets, but they're really *scenas* for two people; they're not meant to be parked-and-barked.

At the same time, Wigmore Hall is not conducive to an evening of opera scenes. The two singers seemed to fall into a groove, carved from their respective past performances of *Butterfly* or *Turandot*. They seemed to want to fill the recital stage with *stuff*, making up for the lack of sets and costumes and space, when instead they could have done less, and simply let their voices do the work. Though their voices are certainly made for the breadth and high stakes of *verismo* repertoire, duets by Verdi or Donizetti could have been better picks for the simple recital recipe.

It seemed odd that every pick on their recital programme was something that audiences could hear La Colla and/or Katzarava sing elsewhere. Perhaps they were encouraged to keep their programme entirely operatic, but it left us curious about what else they could do.

There was an interesting moment at the very end of the recital, when La Colla and Katzarava were nearly through the Act I duet from *Madama Butterfly*; they both went for the high C option for their final notes, and that decision seemed to miss the point entirely. The room was too intimate, and even the robust playing by Lepper was no substitute for Puccini's rich orchestration; rather than the large-scale thrill that happens in a large opera house with the grace of distance, instead we heard the work involved in singing those high Cs.

After cries of "encore" began, it seemed a strange choice - old-world, really - to reprise the last 32 bars or so of the very same duet. Very 1970s at La Scala.

>The next Rosenblatt Recital happens on [March 6th at Wigmore Hall](http://www.rosenblattrecitalseries.co.uk/recital.aspx?key=172), featuring mezzo [Tara Erraught](/scene/people/tara-erraught/) and pianist [James Baillieu](/scene/people/james-baillieu/). For details and tickets, [click here.](http://www.rosenblattrecitalseries.co.uk/recital.aspx?key=172)


