+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-10T21:45:00-04:00"
lastmod = "2015-04-10T23:18:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428716409730/La-Belle-Helene-089-2.jpg.jpg"
primary_image_credit = "Stuart Lowe"
publishDate = "2015-03-19T09:45:00-04:00"
related_articles = ["articles/in-review-los-gavilanes-at-toronto-operetta-theatre.md"]
related_companies = ["scene/companies/royal-conservatory-of-music.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/christina-campsall.md","scene/people/asitha-tennekoon.md"]
short_description = "Last night I went to see opening night of the Glenn Gould School&#039;s production of Offenbach&#039;s La belle Hélène."
slug = "in-review-la-belle-helene"
title = "In review: La belle Hélène"
+++

<p>
	Last night I went to see opening night of the Glenn Gould School's production of Offenbach's 
	<em>La belle Hélène</em>. I didn't know the piece, but I immediately remembered how Offenbach is like French Rossini, with more romanticism and unexpectedly beautiful melodies. <em>La belle Hélène </em>is an <em>opera-bouffe</em> take on the Greek myth of Paris and his abduction of Helen, directed by <a href="http://www.joelivany.com/index/welcome.html" target="_blank" data-mce-href="http://www.joelivany.com/index/welcome.html">Joel Ivany</a> with choreography by <a href="https://twitter.com/jennemethod" target="_blank" data-mce-href="https://twitter.com/jennemethod">Jennifer Nichols</a>, and conducted by Uri Mayer. The cast and chorus did an admirable job with all of the dancing, and I thought the work by Jennifer and Joel were really complementary.
</p>
<p>
	The show was sung in French, with English dialogue by Michael Albano. I don't know the original dialogue for 
	<em>La belle Hélène</em>, but it was clear that Albano had fun with the translation, updated the language, and included a few timely jokes ("John Tory's Smart Track!"). The dialogue was absolutely in line with Joel's idea of the production, which was one that acknowledged and had fun with all the silly plot holes and melodramatic music that comes with most operetta. The minimal sets by Camellia Koo and costumes by Ming Wong put the setting largely in an Ancient Greek period, but Joel wasted no time breaking the concept of time and place. For her first aria, Hélène is supplied (by <a href="http://schmopera.com/author/greg/" target="_blank" data-mce-href="/author/greg/">Gregory Finney</a> as chorus/stage hand, of course) with a microphone and a spotlight, and she sings downstage, cabaret-style. I was glad that Joel went with this stand-alone aria, letting it be a song for its own sake. There were gags with the orchestra, like the "bad clarinetist" who couldn't seem to get it right (handled hilariously by Daniel Wheeler as Menelaus). Between the moments of exaggerated comedy, and some breaking of the fourth wall, I thought this was a great take on a piece that has a fair amount of dramatic fluff. Plus, everyone onstage was having fun.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428716647175/La-Belle-Helene-289-2.jpg"><img data-resize-src="http://lh3.googleusercontent.com/ETP_9UCTOmLHFSMWW4fxdPXpWLc2vRVjA_1dFyIqge6Thfk7v1CisUTWx-B4cUUGm1xMuuy8-whdJeiHY4qRnyqC2ZwUvw" src="http://lh3.googleusercontent.com/ETP_9UCTOmLHFSMWW4fxdPXpWLc2vRVjA_1dFyIqge6Thfk7v1CisUTWx-B4cUUGm1xMuuy8-whdJeiHY4qRnyqC2ZwUvw=s1200"></a><figcaption>Christina Campsall and Asitha Tennekoon. Photo: Stuart Lowe.
</figcaption></figure>
<p>
	Mezzo-soprano <a href="https://twitter.com/chriscampsall" target="_blank" data-mce-href="https://twitter.com/chriscampsall">Christina Campsall</a> sings the title role, and I loved her sound; it's been a while since I really heard Christina, but she had a really rich mezzo colour that got beautifully bright and metallic up top. Helen of Troy was The Most Beautiful Woman in the World, and I liked how Christina's Hélène was quite aware of her own beauty. Also aware of his hotness was Hélène's lover Paris, sung by tenor <a href="https://twitter.com/asten8r" target="_blank" data-mce-href="https://twitter.com/asten8r">Asitha Tennekoon</a>. He had an exciting, focused tenor sound, and had plenty of personality to boot. He managed to play a cocky wife-napper, while still being liked by the audience. Asitha is definitely one to watch; you can catch him as Bénédict in <a href="http://www.metroyouthopera.ca/201415-season/" target="_blank" data-mce-href="http://www.metroyouthopera.ca/201415-season/">Metro Youth Opera's <i>Béatrice et Bénédict</i></a>, opening April 24. was a great energy onstage, a cocky character still liked by the audience. As Oreste, Nadine Anyan had great trouser-role energy. In <em>La belle Hélène</em>, Oreste is a spoiled son, entitled to prostitutes and gambling all day long. Nadine was covered at times by the orchestra, and I wondered if the role really showed what she can do.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428716610851/La-Belle-Helene-410.jpg"><img data-resize-src="http://lh3.googleusercontent.com/yi5F_GRjB1sOTFWoSn4O-sd32jFu6qJcwIdyMujpnpnrvP1H8qRbrluaEpV4YrhDX3ODOBHh62bcpqTOcIwq3QTM6e3O" src="http://lh3.googleusercontent.com/yi5F_GRjB1sOTFWoSn4O-sd32jFu6qJcwIdyMujpnpnrvP1H8qRbrluaEpV4YrhDX3ODOBHh62bcpqTOcIwq3QTM6e3O=s1200"></a><figcaption>l-r: Ronan MacParland, Daniel Wheeler, Tristan Jones. Photo: Stuart Lowe
</figcaption></figure>
<p>
	Tristan Jones was great as Agamemnon, singing the role with a humongous, bright sound. Agamemnon has some of the most difficult music of the show, with lots of patter and parts that go unnecessarily high; Tristan made it seem easy. As Ménélas, Hélène's husband, Daniel Wheeler was a cartoon-like version of a cuckolded king; I'm fairly sure Daniel has experience in music theatre, and it showed in his physicality onstage. As Calchas, the double agent who secretly works for Hélène, Ronan MacParland was more comedy, rounding out the pattering, Stooge-like trio of men. He had a fantastic speaking voice in the dialogue, but I tended to lose him when he sang. I loved the cameos by Achille and Ajax I and II, sung by Christopher Wattam, Justin Stolz and Alvaro Vasquez Robles, respectively. The Tweedledee and Tweedledum schtick with the two Ajaxes was pretty cute.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428716506105/La-Belle-Helene-066-2.jpg"><img data-resize-src="http://lh3.googleusercontent.com/TVAqllmJwOWqj47TNPCztNfbhaD8P7bKWwhLasiJejQBuHmDjNtARcMo37z1c6G_0bu96Cau36mk3bSz6fGIP2mUqxrk" src="http://lh3.googleusercontent.com/TVAqllmJwOWqj47TNPCztNfbhaD8P7bKWwhLasiJejQBuHmDjNtARcMo37z1c6G_0bu96Cau36mk3bSz6fGIP2mUqxrk=s1200"></a><figcaption>Members of the chorus of the GGS Opera production of La belle Hélène. Photo: Stuart Lowe.
</figcaption></figure>
<p>
	The chorus had a tight sound, and I have to give them many, many kudos for their dance work with Jennifer Nichols. The chorus included baritone and Schmopera contributor Gregory Finney. The orchestra, under the baton of Uri Mayer, had a great palate of sound. I though Mayer micro-managed some of the operetta rubato, but the style was there and the orchestra had some truly beautiful moments. I noticed that the orchestra covered several of the singers in the ensemble numbers, but this was the first opera I'd seen (yes, first!) in Koerner Hall, and it may be a regular acoustic issue.
</p>
<p>
	As a piece, I think 
	<em>La belle Hélène</em> has some loose ends, both dramatically and musically. On the other hand, some of the music was brilliantly hilarious; the "l'homme à la pomme" scene was one of my favourites. There's a scene where everyone is making Ménélas go to Crete so that Hélène and Paris can get to know each other; I thought of Rossini again, specifically of the whole Act II finale with Basilio, "Buona sera," etc. Just like Joel, Jennifer Nichols took the more cheesy moments in stride, including wing-flapping choreography for the goose scene. Plot holes and silliness aside, it was hard to not have fun with this show.
</p>
