+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-11-18T11:53:00-05:00"
lastmod = "2015-11-18T16:07:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447869245096/2015-11-18---Square---Lucia-Cervoni-(Julie)_Photo-by-Cylla-von-Tiedemann.jpg.jpg"
primary_image_credit = "Lucia Cervoni as Julie. Photo by Cylla Von Tiedemann"
publishDate = "2015-11-18T16:06:00-05:00"
related_articles = ["articles/dont-miss-julie.md","articles/in-review-squeezebox.md","articles/dont-miss-soundstreams-presents-odditorium.md"]
related_companies = ["scene/companies/soundstreams.md"]
related_people = ["scene/people/lucia-cervoni.md","scene/people/clarence-frazer.md","scene/people/sharleen-joynt.md","scene/people/leslie-dala.md"]
short_description = "Last night Soundstreams and Canadian Stage opened their collaborative production of Julie, the fourth opera by Belgian composer Philippe Boesmans. There was a good amount of hype leading up to this opening, and for good reason. Julie is adapted by librettists Luc Bondy and Marie-Louise Bischofberger from the controversial play by August Strindberg, Miss Julie; its three-singer cast is a cross-section of the rising stars of our current generation. "
slug = "in-review-julie"
title = "In review: Julie"
+++

Last night [Soundstreams](/scene/companies/soundstreams/) and Canadian Stage opened their collaborative production of *Julie*, the fourth opera by Belgian composer Philippe Boesmans. There was a good amount of hype leading up to this opening, and for good reason. *Julie* is adapted by librettists Luc Bondy and Marie-Louise Bischofberger from the controversial play by August Strindberg, [*Miss Julie*](https://en.wikipedia.org/wiki/Miss_Julie); its three-singer cast is a cross-section of the rising stars of our current generation. Mezzo-soprano [Lucia Cervoni](/scene/people/lucia-cervoni/) sings the title role, opposite baritone [Clarence Frazer](/scene/people/clarence-frazer/) as Jean, her father's valet (and  maybe more). Soprano [Sharleen Joynt](/scene/people/sharleen-joynt/) is Christine,  fiancée to Jean as well as Julie's cook. 

Boesmans' opera is a condensed telling of *Miss Julie*, and Matthew Jocelyn's direction brought us into a very specific world. Confined to Julie's kitchen, the action felt like it unfolded in real time, and in close connection with the music. The opera begins with a feeling of unease, aided by a throbbing bass drum underscoring Christine's eerie, hummed work-song. I love how Music Director and conductor [Leslie Dala](/scene/people/leslie-dala/) describes Boesmans' writing, as "incredibly economical". It was dense with short musical motives and a huge range of instrumental sound effects, and the orchestra's raw sound kept the score earthy, not only atmospheric. I thought the smaller orchestra heightened this effect, too; it made the music more transparent, each part audible and distinct. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447880304807/2015-11-18---Resized---JuliePress.jpg.jpg)
<figcaption>Lucia Cervoni (Julie) and Clarence Frazer (Jean). Photo by Cylla von Tiedemann.</figcaption>
</figure>

The singing was predictably strong from this cast of singers. As Julie, [Cervoni](/scene/people/lucia-cervoni/) had a rich, flexible mezzo sound; the role demands a lot of her, and I especially loved how she dealt with the quite low singing. She was a great fit for this role; her voice can morph from sultry to dangerous, and I found her really compelling to hear. [Clarence Frazer](/scene/people/clarence-fraz.er) was strong as Jean, and I thought the role showed off what he does well. His sound has gotten more rich, and I even heard some similarities to Russell Braun at a few moments. He connected his singing directly to his action, always keeping his sound easy despite periods of frantic, fast-paced movement

I loved [Sharleen Joynt](/scene/people/sharleen-joynt/)'s Christine. She was funny, and she was the source of sanity in this bizarre story. Boesmans writes for Christine fierce coloratura and lyric lines that are impossibly high; I was thrilled that this role showed off so much of Joynt's extraordinary skill. In all of her vocal extremes, she kept the sound beautiful and she prioritized text. We felt as though we already knew Christine, I found myself on her side. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447880211105/2015-11-18---Resized---JuliePress2.jpg.jpg)
<figcaption>Sharleen Joynt (Christine) and Clarence Frazer (Jean). Photo by Cylla von Tiedemann.</figcaption>
</figure>

All three roles showed examples of Boesmans' often tricky style of setting text. The rhythms are tight and speech-like, yet not entirely organic to the lilt of the text; it certainly helps the unease heard throughout the music, but it can create a challenge for the singer. Despite what felt like a few crowded moments, I liked the combination of naturalistic pacing with unexpected and otherworldly sounds written into the score.

Like Boesmans' music, Strindberg's *Miss Julie* brings us into a very specific world. Characters speak with significance, and they're reckless with their actions. I've not seen the play, but I couldn't help thinking that the opera, an abridged version of the story, lacked some of the material that helped set up this world. I felt like I didn't really know Julie or Jean, and I didn't always understand their motivations. Perhaps those questions have answered in the scenes left out of *Julie*. Nevertheless, there were wonderful details in Jocelyn's direction, and I thought they added to the seamless quality between music and drama. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447880293651/Resized---JuliePress2.jpg.jpg)
<figcaption>Lucia Cervoni (Julie) and Clarence Frazer (Jean). Photo by Cylla von Tiedemann.</figcaption>
</figure>

It's an intense, compact work that's absolutely worth seeing. *Julie* plays until November 29th at the Bluma Appel Theatre, 27 Front St. E, Toronto. Follow the box office links below for more details and to purchase tickets.
