+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-04-19T10:01:00+01:00"
lastmod = "2016-04-19T12:03:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461058929231/2016-04-19---Karita-Mattila-Jiri-Belohlavek_Czech-Philharmonic_Jenufa.jpg.jpg"
primary_image_credit = "Karita Mattila, Jiří Bělohlávek and the Czech Philharmonic. Photo: Petr Kadlec"
publishDate = "2016-04-19T11:10:00+01:00"
related_articles = ["articles/still-stunning-written-on-skin.md","articles/in-review-boris-godunov.md","articles/back-to-school-opera-a-practical-glossary.md"]
related_people = ["scene/people/karita-mattila.md"]
short_description = "As Jenůfa&#039;s mother, Kostelnička, Karita Mattila was a total force. She tore into the role&#039;s enormous range and horrific moments of drama with her notoriously brazen energy. She sang wildly at moments, yet it was funneled through a perfect character, one who constantly veers outside the comfortable and controlled."
slug = "in-review-jenufa-czech-philharmonic"
title = "In review: Jenůfa with the Czech Philharmonic"
+++

Last night, the Royal Festival Hall welcomed the Czech Philharmonic to the stage, under the baton of Jiří Bělohlávek, for an in-concert performance of Leoš Janáček's *Jenůfa*. It's an opera we hadn't seen performed before, and after the evening's musical taste, it's one we're eager to see fully staged.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461059600906/2016-04-19---Karita-Mattila-Jiri-Belohlavek_Czech-Philharmonic.jpg.jpg)<figcaption>Karita Mattila, Jiří Bělohlávek and the Czech Philharmonic. Photo: Petr Kadlec.</figcaption>
</figure>

*Jenůfa* is one of those riveting, infuriating stories, set in a time and place where women have no control over whether life turns out great or horrid. Jenůfa is an unmarried woman, pregnant by Števa, the man she loves. She, along with her mother and grandmother, is eager to get married to Števa before her pregnancy begins to show, since the punishment for being single and pregnant is death by stoning. While she's waiting to marry, Števa decides to let her know about all the women who want him, and how he's so great at flirting back with them. He's a real catch, you see. Complicating matters is Jenůfa's childhood friend, Laca, who has been in love with her for years. He ends up cutting her face with a knife in a fit of anger when she rebuffs his attempt to kiss her; and, since Števa figures that Jenůfa's beauty is all she really has going for her, the scar on her cheek is enough to cancel any wedding plans they might have had. To be fair, he offers child support, but won't admit to paternity; he's now engaged to marry the mayor's daughter instead.

Fast-forward to Jenůfa's having her child in secret, kept isolated and drugged up by her mother. Her mother drowns the baby under the ice, getting rid of that pesky complication, and tells Jenůfa that the baby died while she was asleep. Jenůfa ends up marrying Laca after all, and at their wedding ceremony, the baby's body is discovered, and Jenůfa's mother is taken away to trial. Jenůfa forgives her mother, for some flabbergasting reason, and decides that Laca, the man who didn't respect her love for Števa and cut her cheek to make his point, is the best man she's ever met in her life. Sigh.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461059632075/2016-04-19---Adriana-Kohutkova-Karita-Mattila.jpg.jpg)<figcaption>Adriana Kohútková as Jenůfa and Karita Mattila as Kostelnička. Photo: Petr Kadlec.</figcaption>
</figure>

Even though every single character in Janáček's opera is frustratingly horrible, it's an incredible piece of theatre that seems to fly by in an instant. In the title role, Adriana Kohútková had a beautiful, womanly sound, that went from naïvely in love to maternally caring, to empty and resigned. Aleš Briscein was a highlight of the night, singing with a similar dramatic arc as Laca; he began with more than a hint of menace in his clear, ringing sound, and somehow that same sound became heroic, like Jenůfa's saving grace, or at least her lesser of all evils. As Jenůfa's mother, Kostelnička, Karita Mattila was a total force. She tore into the role's enormous range and horrific moments of drama with her notoriously brazen energy. She sang wildly at moments, yet it was funneled through a perfect character, one who constantly veers outside the comfortable and controlled.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461059686325/2016-04-19---Ales-Briscein-Jenufa-Royal-Festival-Hall.jpg.jpg)<figcaption>Aleš Briscein as Laca. Photo: Petr Kadlec.</figcaption>
</figure>

Jaroslav Březina was appropriately cad-like as Števa; he sang in a defensive, declamatory way, yet his sound felt less free than it could have. We're curious to hear him in a more friendly role. Other highlights included Svatopluk Sem's friendly, pointed baritone as Stárek, and Lucie Silkenová's clear, cutting soprano as Karolka, the mayor's daughter. Plus, we loved Marta Reichelová's trouser-role chops as Jano, the young boy who is delightedly learning to read, and who becomes the bearer of bad news, as the first to discover the frozen body of Jenůfa's baby on her wedding day. Marta was cute as a button, with an exciting zing to her sound.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461059738420/2016-04-19---Jaroslav-Brezina-Jana-Hrochova-Jenufa-Royal-Festival-Hall.jpg.jpg)<figcaption>Jaroslav Březina as Števa and Lucie Silkenová as Karolka. Photo: Petr Kadlec.</figcaption>
</figure>

Janáček's music is mesmerizing and alive, and *Jenůfa* is an opera that stays theatrical even in-concert. Under Jiří Bělohlávek, the Czech Philharmonic played as a honed group of soloists, with clear attention to the speech rhythms so expertly echoed in their textless music. Though the music was top-notch, there could have been so much more interaction amongst the singers onstage. We wished that characters remained standing when they were still present in a scene, rather than only when they were set to sing. Mattila, for all her fire, seemed particularly in her score, cutting off a lot of potential eye contact with the audience and other characters. At times this in-concert setting felt more like a rehearsal than a performance; we thought back to our experience at the [Barbican watching George Benjamin's *Written on Skin*](/still-stunning-written-on-skin/), also performed in-concert. It's no small task to bring an opera to life without sets and costumes, but it can happen. We craved more of the story, yet we mercifully lacked little in musical delivery.

For more, have a look at Karita Mattila's interview for the Czech Philharmonic about performing *Jenůfa*:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/zsDIR9VQGHs" frameborder="0" allowfullscreen></iframe>
</figure>
