+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-04-04T17:33:00+01:00"
lastmod = "2016-04-04T18:16:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459788624997/2016-04-04---Lucia-Cesaroni-as-ISIS-Michael-Barrett-as-Osiris-photo-by-Gary-Beechey.jpg.jpg"
primary_image_credit = "Lucia Cesaroni as Isis and Michael Barrett as Osiris. Photo by Gary Beechey."
publishDate = "2016-04-04T18:16:00+01:00"
related_articles = ["articles/talking-with-singers-lucia-cesaroni.md","articles/dion-mazerolle-the-quick-study.md","articles/elitism-irony-and-the-phantom-of-the-opera.md","articles/dont-miss-waltz-rivals.md","articles/tots-pirates-of-penzance-a-glorious-thing.md"]
related_companies = ["scene/companies/voicebox-opera-in-concert.md"]
related_people = ["scene/people/lucia-cesaroni.md","scene/people/michael-nyby.md","scene/people/michael-barrett.md"]
short_description = "As Isis, Cesaroni was a revelation. Her incomparable voice flew throughout the Jane Mallett with ease and aplomb, and I&#039;ve said this before, she just gets better every time I hear her. Her darker colour belies the height and beauty she can achieve at the top of her register and every note is properly placed and spins and sparkles. Her characterization of (as she puts it) &quot;the bad b*tch in charge&quot; was a genuine treat."
slug = "in-review-isis-and-osiris"
title = "In review: Isis and Osiris"
+++

I spent a snowy, blustery, Sunday afternoon in the comfort of the St. Lawrence Centre's Jane Mallett Theatre to witness the culmination of over four years of preparation for the world premiere of Peter-Anthony Togni and Sharon Singer's *Isis and Osiris: Gods of Egypt*. Presented by the new incarnation of one of Toronto's oldest opera companies, [VOICEBOX: Opera In Concert](/scene/companies/voicebox-opera-in-concert/), *Isis and Osiris* was from start to finish a delicious, musical feast. 

A black, empty stage with minimal decor featuring a gold sarcophagus, and statues of Egyptian gods and goddesses in black and gold, set the stage for our play. The piece was incredibly effective and one of the best things I've seen and heard from VOICEBOX in recent memory. Not presented in concert at all, director Guillermo Silva-Marin treated the audience to a fully staged piece, complete with choreography which emphasized a physicality shaped after Egyptian hieroglyphs. 

The title roles were ably sung by tenor [Michael Barrett](/scene/people/michael-barrett/) - who bravely stepped in to the role with only three weeks notice - and soprano [Lucia Cesaroni](/scene/people/lucia-cesaroni/), who we featured in a [recent Q&A](/cesaroni-isis-osiris-new-opera/) on this particular show. Barrett's manly, muscular tenor commanded the stage and the house. He ably sang his way through a difficult score that bordered on Heldenland. His characterization of the Pharaoh-god was simultaneously comforting and threatening, a magical combination of human qualities that are possessed by a true ruler of a civilized nation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459788703989/2016-04-04---Michael-Nyby-as-SETH-Michael-Barrett-as-OSIRIS-photo-by-Gary-Beechey.jpg.jpg)<figcaption>Michael Nyby as Seth, Michael Barrett as Osiris. Photo by Gary Beechey.</figcaption>
</figure>

As Isis, Cesaroni was a revelation. Her incomparable voice flew throughout the Jane Mallett with ease and aplomb, and I've said this before, she just gets better every time I hear her. Her darker colour belies the height and beauty she can achieve at the top of her register and every note is properly placed and spins and sparkles. Her characterization of (as she puts it) "the bad b\*tch in charge" was a genuine treat. She brought strength and vulnerability, showing the duality of the divine and human that is unique amongst the Egyptian deities. They are actually embodied in a human form and come with human weaknesses. It was a beautiful performance, bravissima. 

As their sister-god, Nepthys, [Julie Nesrallah](/scene/people/julie-nesrallah/) was a shining light. Her warm, dark full mezzo married so well with the other singers on stage you had trouble believing this was their first time working together - in particular in passages with Cesaroni. There was some remarkable soloist singing accompanied by the VOICEBOX: Opera In Concert Chorus where she effortlessly sailed above all the other voices on stage as well as the exposed orchestra. Her acting chops were top-notch and her scenes onstage with Seth were riveting, powerful and poignant. It was a true delight to see her on the boards. 

As Seth, the bringer of evil, I have one thing to say to baritone Michael Nyby - #TripleSwoonTimesInfinity. That's right, you heard it here first. If you weren't convinced of Nyby's incredible talent and skill already, his performance in this piece will convince you. The standout performance for me in this production, Nyby sang Seth's incredibly difficult and rangy music as though he had been singing this role his whole life. There were moments of Germont and Escamillo all rolled into this sinewy, snakelike characterization that had me entranced the moment he stepped on the stage. Bravo, signor! Bravo! 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459788737411/2016-04-04---Lucia-Cesaroni-as-ISIS-Michael-Nyby-as-SETH-Photo-by-Gary-Beechey.jpg.jpg)<figcaption>Lucia Cesaroni as Isis, Michael Nyby as Seth. Photo by Gary Beechey.</figcaption>
</figure>

Supporting the cast were the lovely coloratura [Leigh-Ann Allen](/scene/people/leigh-ann-allen/), who sang some pretty unforgiving passages effortlessly as the priestess Sennefer, and tenor Christopher Wattam as Imhotep, who sang with a clear, lighter tenor that was a nice change of pace from Barrett's heroic singing. As Grand Vizier Khamet, baritone Stuart Graham displayed some surprising acting chops during a scene where he's tortured by the sister gods and the high priest Imhotep. 

As always, the VOICEBOX: Opera In Concert Chorus were phenomenal. From memory and with staging - which is not something that this chorus does all the time - not a single note suffered. They were solid, engaged, in-tune and exhilarating. I was left wanting more big chorus numbers after the show, and I don't think I was the only one. 

Under the baton of Robert Cooper, the chorus and orchestra - which consisted of 9 players - brought the score off the page with the subtlety and grace which we come to expect from Cooper's breadth of experience at the podium. It handled the Middle-Eastern stylisms and quotes carefully, never in an exploitative manner, which helped elevate the production to a new level. 

Togni's score was at once modern and antique. He adeptly incorporated the use of Middle-Eastern harmonies and modes with a score that was at times cinematic, at some times sounded like a current broadway hit and there were even times he seemed to nod to Nova Scotian folk-tunes - and I can speak from experience that that music gets in your blood and is some of the most satisfying to listen to and perform. 

There were times I felt a lot of the melodic development was too similar, and there were a little too few tunes that you left the theatre humming - that being said, it seems to be a trend in Canadian compositions that a melody that's singable after a first hearing is not as important as exercising the range of colours the human voice can produce. However, the most beautiful moments in the piece were his handling of Isis's aria towards the end of Act I when she lulls Osiris to sleep, and the "Bring Osiris Home" chorus, which had elements of the Broadway musical coupled with a show-choir's show-stopper.

Singer's libretto handled the material of the storyline very well. The characterizations of the four gods, Isis, Osiris, Nepthys and Seth, were fully fleshed out and nuanced. Her writing for Seth was probably the most poetic of the four, however I found that the libretto itself was all-exposition-all-the-time. The text was quite demonstrative, which hearkens back to what we know of the art of antiquity, in particular the theatre of ancient Greece, but it would have been nice to have a few overtly poetic arias or ensembles to balance things out. I felt myself wanting to know more about how the characters felt about what was going on not just telling us the facts of the situation. 

Here's hoping we see this piece on stage again REAL SOON. You all need to hear this work. 
