+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-04-12T08:35:00-04:00"
lastmod = "2015-04-23T22:38:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429842937860/Tafelmusik-716x1024.jpg.jpg"
publishDate = "2014-04-12T08:35:00-04:00"
related_articles = ["articles/a-masked-ball-american-baroque-opera-cos-opera-cabaret.md"]
related_companies = ["scene/companies/tafelmusik-baroque-orchestra-chamber-choir.md"]
related_people = ["scene/people/isabel-bayrakdarian.md"]
short_description = "On Thursday night I went to see the Tafelmusik orchestra perform with Canadian soprano Isabel Bayrakdarian in a concert with a good title: Rival Queens.\n\nThe queens in this case are 18th-century operatic divas Francesca Cuzzoni and Faustina Bordoni, who were in a famous feud throughout their careers, resulting in onstage catfights and general shallow rivalry."
slug = "in-review-isabel-bayrakdarian-and-tafelmusik"
title = "In review: Isabel Bayrakdarian and Tafelmusik"
+++

On Thursday night I went to see the Tafelmusik orchestra perform with Canadian soprano [Isabel Bayrakdarian](http://bayrakdarian.com/) in a concert with a good title: _Rival Queens_.

The queens in this case are 18th-century operatic divas [Francesca Cuzzoni](http://en.wikipedia.org/wiki/Francesca_Cuzzoni) and [Faustina Bordoni](http://en.wikipedia.org/wiki/Faustina_Bordoni), who were in a famous feud throughout their careers, resulting in [onstage catfights and general shallow rivalry](http://www.independent.co.uk/arts-entertainment/music/features/whine-women-and-song-the-bitter-rivalry-of-handels-divas-816644.html). Tafelmusik and Isabel Bayrakdarian gave us some orchestral music and arias by composers like Handel, Vivaldi, Bononcini, Hasse and Telemann, who had written music specifically for these divas. It was a great programme, and you can have a look at it [here](http://www.tafelmusik.org/concert-calendar/concert/rival-queens-isabel-bayrakdarian).

I absolutely loved watching and listening to the Tafelmusik orchestra. They _listened _ to each other, and you could see beautiful moments of chamber music between different instruments. They played Telemann's Concerto in D Minor, (TWV53:d1, for the curious) and it was one of those orchestra dance-off pieces, where the strings do something and the winds try to one-up them. I remembered how _fun_ that music is. And when they began the second half with Vivaldi's Concerto for strings in G Minor, (RV.153!), I was reminded of how Vivaldi really was a rock star. Tafelmusik, bravo.

Canadian soprano Isabel Bayrakdarian took on the large task of singing arias written for these two attention-hungry divas. The first half was dedicated to music written for Faustina Bordoni, and the second half was given to Francesca Cuzzoni. In fact, Isabel added a Cuzzoni aria to the programme, stating that, for fairness' sake, she wanted to give each singer an equal number of arias. Isabel has worked quite a lot with Tafelmusik in the past, and you could see the chamber music chemistry extend to include her when she joined the orchestra onstage; it was fun to watch her enjoy their playing.

She got off to a shaky start, jumping right into some ridiculous coloratura at a pretty brave pace. For the rest of the night, and for reasons unknown to me, most of the arias she sang all had quick tempos and about a bazillion notes. I hadn't ever thought of Isabel as a coloratura soprano, and these particular arias weren't exactly forgiving. It made for an exciting night of vocal Olympics, but all the scales and arpeggios didn't leave Isabel much room to just _sing_. Her coloratura was quick, sure, but it was also faked. She was fidgeting all over the place, reminding me of [Cecilia Bartoli](https://www.youtube.com/watch?v=rISjBGOtHhs), and she couldn't seem to stand still. I'll happily grant that those arias sounded pretty hard, and I'm definitely not able to sing it; but I do know that standing still is a good start when singing plenty of notes.

Isabel had moments of exciting vocal power, and she really did invest energy in singing with a broad palate of colours. Unfortunately for the most part, I could hear that she wasn't fully comfortable singing these arias. When she had a chance to really sing with her voice and express, she allowed her dramatic intent to take away from her technique. For example, she sang as an encore, Handel's "Piangerò la sorte mia" from _Giulio Cesare,_ which she has [recorded with Tafelmusik](http://www.amazon.com/Isabel-Bayrakdarian-Cleopatra-George-Frideric/dp/B000641ZEK) in 2004\. You could tell immediately that Isabel had explored the possibilities of expression with her voice; the execution, however, included morphing vowels and wonky intonation. Isabel simply didn't have the technical facility to sing this kind of repertoire _and_ avoid its many traps.

I enjoyed hearing the Tafelmusik orchestra, but I clearly wasn't sold on this performance by Isabel. if I've piqued your curiosity, there are two more performances of _Rival Queens,_ April 12th and 13th. For details and ticket info, click here.

Also, remember this?

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/rISjBGOtHhs" frameborder="0" allowfullscreen></iframe>
</figure>
