+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-12-05T10:39:00+00:00"
lastmod = "2016-12-05T12:58:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480934233271/2016-12-5---2777ashm_665-664-ANITA-RACHVELISHVILI-AS-AZUCENA-NAJMIDDIN-MAVLYANOV-AS-MANRICO-ROH-PHOTOGRAPHER-CATHERINE-ASHMORE.jpg.jpg"
primary_image_credit = "Anita Rachvelishvili (Azucena) and Najmiddin Mavlyanov (Manrico) in Il trovatore, ROH, 2016. Photographer: Catherine Ashmore."
publishDate = "2016-12-05T12:46:00+00:00"
related_articles = ["articles/in-review-lucia-di-lammermoor-at-roh.md","articles/in-review-tannhauser-at-roh.md","articles/jawdropping-the-nose-at-roh.md","articles/in-review-il-trovatore-at-oper-frankfurt.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/anita-rachvelishvili.md","scene/people/quinn-kelsey.md","scene/people/maria-agresta.md"]
short_description = "First performed in 1853, just after Rigoletto and just before La traviata, Il trovatore gives unfortunate talking points to those who may say that opera plots are silly. There&#039;s the &quot;I burned the wrong baby&quot; bit, the &quot;it&#039;s too dark to tell who I&#039;m hugging&quot; bit, and there are all the opera-esque moments of oddly-timed shock and rage."
slug = "in-review-il-trovatore-at-roh"
title = "In review: Il trovatore at ROH"
+++

David Bösch's production of [*Il trovatore*](http://www.roh.org.uk/productions/il-trovatore-by-david-bosch) - his debut with the [Royal Opera](/scene/companies/royal-opera-house/) - first went up in July of this year; until February 9, 2017, two more casts (and one extra Manrico) step into Bösch's bleak-yet-eclectic look at Verdi and his infamous troubadour.

First performed in 1853, just after *Rigoletto* and just before *La traviata*, *Il trovatore* gives unfortunate talking points to those who may say that opera plots are silly. There's the "I burned the wrong baby" bit, the "it's too dark to tell who I'm hugging" bit, and there are all the opera-esque moments of oddly-timed shock and rage. 

Of course, there are all the good bits, too; love triangles, shifty gypsy women, and each character in *Il trovatore* brings to the table their own form of *vendetta*. But as is the case for all the Verdi operas that still fill contemporary stages, it's the music of *Il trovatore* that makes it last. There's that Caruso quote about the opera, how all it needs is the four greatest singers in the world. Tongue-in-cheek though it may be, Caruso isn't lying; Verdi's writing seems to demand more and more of his singers as *Il trovatore* unfolds.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480934325355/2016-11-5---2777ashm_365-NAJMIDDIN-MAVLYANOV-AS-MANRICO-ANITA-RACHVELISHVILI-AS-AZUCENA--ROH-PHOTOGRAPHER-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Najmiddin Mavlyanov (Manrico) and Anita Rachvelishvili (Azucena) in *Il trovatore*, ROH, 2016. Photogapher: Catherine Ashmore.</figcaption>
</figure>

The evening went spectacularly to [Anita Rachvelishvili](/scene/people/anita-rachvelishvili/) as Azucena. Her enormous sound filled the house, and she never resorted to ugly for its own sake. She found the details in Verdi's writing, including her silences, and she created an Azucena who seemed frightening, yet not malicious. The depth and health in Rachvelishvili's sound gave lucidity to the old gypsy woman, adding to the tragedy of her story.

With Rachvelishvili, Usbekistani tenor [Najmiddin Mavlyanov](http://www.roh.org.uk/people/najmiddin-mavlyanov) did his best singing as Manrico. He seemed to expand throughout the role, finding some touching colour in his final mother-son (?) duet. Mavlyanov seemed quite focused on his singing, and it made him seem detached from Manrico. We were left wanting a real, organic connection between Mavlyanov and [Maria Agresta](/scene/people/maria-agresta/) as Leonora. Agresta had a similar arc, with some Act I tentativeness (perhaps nerves, and perhaps aggravated by a fussy dress - a nod goes to [Jennifer Davis](/scene/people/jennifer-davis/) as Ines for her subtle assistance). As the night went on, Agresta ceded to more abandon in her singing, making for a chilling *scena* in Act IV. As actors, she and Mavlyanov left us wanting much, much more; they seemed in their own heads, and when they were together onstage, their chemistry had an air of being two parallel stories, rather than one that is shared.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480934334943/2016-12-5---2777ashm_173-JENNIFER-DAVIS-AS-INES-MARIA-AGRESTA-AS-LEONORA-ROH-PHOTOGRAPHER-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Jennifer Davis (Ines) and Maria Agresta (Leonora) in *Il trovatore*, ROH, 2016. Photogapher: Catherine Ashmore.</figcaption>
</figure>

[Quinn Kelsey](/scene/people/quinn-kelsey/) was an ominous, dangerous-looking Conte di Luna. There has always been something irrisistable about Kelsey's voice; there's a reedy warmth in it, and there's also a hint of a pop-ish belt, used wisely in his large repertoire of Verdi roles. As di Luna, he found the right time to be menacing, and the right time to be a desperate man. Like Rachvelishvili's Azucena, Kelsey found in his role the subtle shades of grey within the man set on revenge and love (perhaps not in that order).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480934360576/2016-12-5---2777ashm_597-QUINN-KELSEY-AS-COUNT-DI-LUNA-MARIA-AGRESTA-AS-LEONORA-ROH-PHOTOGRAPHER-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Quinn Kelsey (Conte di Luna) and Maria Agresta (Leonora) in *Il trovatore*, ROH, 2016. Photogapher: Catherine Ashmore.</figcaption>
</figure>

Hungarian bass [Gábor Bretz](/scene/people/gabor-bretz/) sang the most beautiful Ferrando we've ever heard. No blustering Verdi bass was he; he channeled his best teller of ghost stories in Act I, with gorgeous precision and detail. [Jennifer Davis](/scene/people/jennifer-davis/)' Ines made us curious to hear her sing a bit of Leonora, and her fellow Jette Parker Young Artist David Junghoon Kim sang a Ruiz to make us wonder about his Manrico.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480934376013/2016-12-5---2777ashm_721-720-NAJMIDDIN-MAVLYANOV-AS-MANRICO-MARIA-AGRESTA-AS-LEONORA-ROH-PHOTOGRAPHER-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Najmiddin Mavlyanov (Manrico) and Maria Agresta (Leonora) in *Il trovatore*, ROH, 2016. Photogapher: Catherine Ashmore.</figcaption>
</figure>

Perhaps the best way to describe the look of Bösch's production is that it was minimalistic, yet with interesting details. The chorus scenes brought a buffet for the eyes; Azucena's fellow gypsies had the look of American carnies, a gender-ambiguous mish-mash of odd folks. Simple barbed wire strewn on the group showed us a prison, and the image of fire were ubiquitous, and foreboding.

Yet the roughly modern setting didn't uncover anything new in *Il trovatore*. With the exception of the quaint gypsy camp, it wasn't always clear *where* everyone was; it's not entirely crucial to the action, which centres on relationships rather than locations. Yet that question of "where" bled into the question of *who* these people were; help is arguably lacking in Cammarano's libretto, yet there seemed little that's special about the relationship between Manrico and Leonora, and between Leonora and di Luna. The starkness of the production seemed to keep people apart -  rather than show us more clearly why Manrico and Leonora fight to stay together.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480934386841/2016-12-05---2777ashm_826-PRODUCTION-IMAGE--ROH-PHOTOGRAPHER-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>A scene from *Il trovatore*, ROH, 2016. Photogapher: Catherine Ashmore.</figcaption>
</figure>

Conductor Richard Farnes led the Orchestra of the Royal Opera House briskly through Verdi's score; the tempos were mercifully quick, yet perhaps a bit claustrophobic for the singers. The Royal Opera Chorus sounded lovely, with deft handling of Verdi's tricky writing. The *Miserere* scene was a stunner.

[*Il trovatore*](http://www.roh.org.uk/productions/il-trovatore-by-david-bosch) runs with this cast until December 16 (with Stefano Secco singing the role of Manrico on Dec 16); from January 26 to February 9, Rachvelishvili is joined by Gregory Kunde, Lianna Haroutounian, and Dmitri Hvorostovsky. For details and ticket information, [click here.](http://www.roh.org.uk/productions/il-trovatore-by-david-bosch)
