+++
author = ["authors/blanche-isral.md"]
categories = "Review"
date = "2017-09-11T10:16:00-04:00"
lastmod = "2017-09-11T11:42:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505139621227/2017-09-11---3328_iltrovatore14_gross.jpg.jpg"
primary_image_credit = "Elza van den Heever as Leonora, Il trovatore, Oper Frankfurt, 2017. Photographer: Barbara Aumüller."
publishDate = "2017-09-11T10:32:00-04:00"
related_articles = ["articles/in-review-il-trovatore-at-roh.md","articles/in-review-tosca-at-the-coc.md","articles/a-dreamy-psychological-thriller-vanessa-at-oper-frankfurt.md","articles/verdi-at-204-toscanini-at-150-the-2017-festival-verdi.md"]
related_companies = ["scene/companies/oper-frankfurt.md","scene/companies/royal-opera-house.md"]
related_people = ["scene/people/brian-mulligan.md","scene/people/elza-van-den-heever.md"]
short_description = "&quot;Balanced&quot; is the emphasis here, with the infamous requirements of the four lead roles met by the quadfecta of Piero Pretti (Manrico), Elza van den Heever (Leonora), Brian Mulligan (Conte di Luna), and the very last-minute replacement for an ailing Tanja Baumgartner, mezzo-soprano Marianne Cornetti (Azucena), flown in from Pittsburgh just in time for Friday&#039;s dress rehearsal."
slug = "in-review-il-trovatore-at-oper-frankfurt"
title = "In review: Il trovatore at Oper Frankfurt"
+++

Schmopera first reviewed this co-production of Il trovatore at the Royal Opera House in London [last December](https://www.schmopera.com/in-review-il-trovatore-at-roh/). 

I attended my first opera at Oper Frankfurt since moving from Toronto to Germany last week. I was pleased to be greeted with an [*Il trovatore*](http://www.oper-frankfurt.de/en/season-calendar/il-trovatore/?id_datum=976) straight to the heart, direct and clear in its storytelling and triumphantly carried by a powerful and balanced cast.

"Balanced" is the emphasis here, with the infamous requirements of the four lead roles met by the quadfecta of Piero Pretti (Manrico), [Elza van den Heever](/scene/people/elza-van-den-heever/) (Leonora), [Brian Mulligan](/scene/people/brian-mulligan/) (Conte di Luna), and the very last-minute replacement for an ailing Tanja Baumgartner, mezzo-soprano Marianne Cornetti (Azucena), flown in from Pittsburgh just in time for Friday's dress rehearsal. 

Directed by David Bösch, a German theatre-director-turned-opera-director well-known to Frankfurt locals, this production of *Il trovatore* displayed a shrewd knowledge and understanding of its audience. Notwithstanding the smattering of boos from staunch traditionalists garnered by the creative team during their bows, I found that Bösch's production struck that tricky balance of edgy without reaching alienating. The childish and the grotesque intersected to create a raw exploration of Verdi's themes of innocence versus corruption, with an obsession with freaky dolls and childish love symbols pervasive throughout. Bösch's gypsy world was reminiscent of reality TV show gypsy culture, complete with sparkly leather, tulle, and tracksuits as seen on TLC's *My Big Fat Gypsy Wedding*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505139729996/2017-09-11---3339_iltrovatore04_gross.jpg.jpg)
<figcaption>Playful scenic and costume elements with lots of depth in an ensemble scene of Il trovatore, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Despite the eleventh-hour swap-in, Cornetti fit herself into the world of this *Il trovatore* like a puzzle piece, embodying an erratic, disturbed, and worn-out Azucena down to the last detail of her posture and gait. Her acting occasionally bled into her voice as well however, at times compromising the pitch and causing cracking and clucking, but the result was nonetheless powerful, insanely deep and, in the end, very well suited to her version of this character.

I was loving Mulligan as Conte di Luna. The Juilliard-trained singer had me doing a double-take at how much he resembles another American baritone, [Quinn Kelsey](/scene/people/quinn-kelsey/), who took on the same role at ROH last winter. From his large, coppery voice to his still and coolly powerful stage presence, Mulligan brought warmth to Conte di Luna that contributed lots of complexity to his relationship with Manrico rather than just portraying a villain.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505139767192/2017-09-11---3338_iltrovatore05_gross.jpg.jpg)
<figcaption>Piero Pretti (Manrico), Elza van den Heever (Leonora), and Brian Mulligan (Il conte di Luna) were a well-suited trio in *Il trovatore*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Sardinian tenor Piero Pretti's Manrico was sweet and connected, demonstrating mother-tongue comfort in the diction. His guido slicked back hair, animal print and sparkly leather elevated his depth as a character, a credit to costume designer Meentje Nielsen. More than just a macho young man, Pretti's Manrico was a burdened and exhausted guerrilla soldier whose virtuosic displays didn't ever go so far as to pull you away from the action, which I appreciated.

Since the production's first iteration last year, I note a few costume edits for the women, specifically for Leonora and Ines, which seem to be intended to bring the time period even closer into the present day. The context is ill-defined, but somewhere between 1950 and present day, a gratuitous smartphone selfie by the Spanish army being either an afterthought or a central clue. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505139802252/2017-09-11---3337_iltrovatore06_gross.jpg.jpg)
<figcaption>Some of the costumes were remixed since the Royal Opera House's run of this ROH/Oper Frankfurt co-production. Elza van den Heever (Leonora) and Alison King (Ines) in *Il trovatore*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Elza van den Heever exhibited daring risks and impressive range as Leonora. Her first scene alongside Opera Studio member Alison King as Ines was a bit overly twee, but she went on to have fun with her fast "Di tale amor che dirsi" in Act I, and her character's maturity developed dramatically by the time she hit the prison arias in Act III where she took moving chances, both vocally and in her acting. This made for an interesting character as well as one of the most convincing slow deaths by poisoning I've seen on a stage, her head lolling around as she sang her last breaths. The Luna-Leonora duet between van den Heever and Mulligan in Act IV was quite glorious.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505139834584/2017-09-11---3331_iltrovatore11_gross.jpg.jpg)
<figcaption>Elza van den Heever (Leonora) and Piero Pretti (Manrico) in *Il trovatore*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Okay, can we talk about this chorus?! The male chorus, especially, was haunting and precise, particularly from off-stage. Confession: I actually cannot stand the Anvil Chorus in general, but the rest of the male chorus moments were gripping. The only issues overall were with timing in some of the faster bits, which one would hope will get worked out in the next couple of performances. Otherwise, their sound was full and satisfying from the very first scene. A shout-out, also, to the three male chorus members who pulled off a very convincing stabbing, particularly the stab-ee - there are so many half-baked and/or overly literal stabbing scenes in opera, but this wasn't one of them.

The set elements were sleek and interesting without being too gimmicky, and that's a tall order with all the pyro involved. The slowly rising fire pit in the final scene was a dark moment of awe. The flaming heart was not as literal as it sounds because a heart-like shape had been previously established as a symbol of allegiance on a flag. The babydoll-studded trailer and dismantled rusty car provided lots of information about the gangster Spanish gypsies' way of life without requiring much else. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505139863364/2017-09-11---3349_iltrovatore20-1_gross.jpg.jpg)
<figcaption>One of several pyro displays in David Bösch’s Il trovatore, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Overall, the result of all this was a surprisingly honest and down-to-earth *Il trovatore* that focused on the story and kept the context intentionally hazy, and therefore universal. Of particular note were the various relationships, which all fit the bill. Pretti and Mulligan were believable as estranged brothers, and Cornetti's Azucena a highly believable mother to (n)either. It made sense for van den Heever's Leonora, an emotionally driven young woman in the process of developing her own identity and principles, to find true love in Pretti's sensitive and alternative Manrico and to be disgusted with the idea of di Luna. You felt for all of them, and this communicated even through my own double language barrier (Italian with German subtitles, groan... I did my homework beforehand), a testament to the music's timeless power and to the power of opera in general.

Il trovatore runs at Oper Frankfurt until January 13, 2018. For details and ticket information, [click here](http://www.oper-frankfurt.de/en/season-calendar/il-trovatore/?id_datum=976).
