+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-03-04T10:59:00+00:00"
lastmod = "2016-03-04T13:01:00+00:00"
preamble = "Photo: Rebecca Evans (Nella), Paolo Fanale (Rinuccio), Carlo Bosi (Gherardo), David Kempster (Marco), Gwynne Howell (Simone), Jeremy White (Betto), Marie McLaughlin (La Ciesca), Elena Zilio (Zita). ROH. Photographer: Bill Cooper."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457092742979/%C2%A9BC20160222_GIANNI_SCHICCHI_1478-SEE-PHOTO-CAPTIONS-LIST-(C)-ROH.-PHOTOGRAPHER-BILL-COOPER---square.jpg.jpg"
primary_image_credit = "Photographer: Bill Cooper."
publishDate = "2016-03-04T13:01:00+00:00"
related_articles = ["articles/in-review-enos-the-magic-flute.md","articles/in-review-boris-godunov.md","articles/in-review-tannhauser-at-roh.md","articles/in-review-norma-at-roh.md","articles/in-review-cosi-fan-tutte-at-roh.md","articles/rohs-madama-butterfly-better-to-be-furious-than-bored.md","articles/an-astonishing-bryan-hymel-in-the-royal-operas-double-bill.md","articles/a-frighteningly-timeless-story-of-abuse-pagliacci.md","articles/feminism-confetti-ateliers-triplebill.md","articles/standout-performances-in-ava-doublebill.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/patricia-racette.md","scene/people/lucio-gallo.md","scene/people/carl-tanner.md","scene/people/ermonela-jaho.md"]
short_description = "We were thrilled to get a three-for-one deal with our inaugural trip to the ROH, in the form of Richard Jones&#039; production of Puccini&#039;s Il trittico. The through line holding together the stories of Il tabarro, Suor Angelica and Gianni Schicchi was the original theme: the fact that Puccini wrote them. The shows looked as different as the stories they told, and it was a true feast for opera lovers with slight ADD."
slug = "in-review-il-trittico-at-roh"
title = "In review: Il trittico at ROH"
+++

Last night we had a debut of our own, our first visit to the Royal Opera House. The space is plush yet packed, ornate yet functional. We got turned around a few times in what seemed like endless stairways leading anywhere but our seats; yet despite the grandeur of the building, there was something charmingly everyday about the scene. We exercised will power against the intermission ice cream vendors, and our kind seat neighbour offered some wise advice about checking out the balcony overlooking the square in Covent Garden.

We were thrilled to get a three-for-one deal with our inaugural trip to the ROH, in the form of Richard Jones' production of Puccini's *Il trittico*. The through line holding together the stories of *Il tabarro*, *Suor Angelica* and *Gianni Schicchi* was the original theme: the fact that Puccini wrote them. The shows looked as different as the stories they told, and it was a true feast for opera lovers with slight ADD. Maestro Nicola Luisotti expertely led the Orchesta of the Royal Opera House with fire and sensitivity.

*Il tabarro* has a way of creeping up on you; as it begins, we're busy meeting barge workers and townspeople, who give clear glimpses of the various miseries in their lives. In the monotone, quite real world laid out by Richard Jones, we were left to rely on voices to find our protagonists. 

Soprano [Patricia Racette](/scene/people/patricia-racette/) was the first to shine as Giorgetta, wife of Michele, the owner of the barge. She had a sad air of desperation as she made the best of her trapped existence; yet she never whined, never bemoaned without hope the fact that she was living someone else's (her husband's) life. [Lucio Gallo](/scene/people/lucio-gallo/) was a stiff, cold Michele, yet Puccini quickly creates a three-dimensional character out of him with his sad, ill-timed conversation about the late son he had with Giorgetta. Gallo and Racette made sense of each other as a married couple, unhappy for different reasons. Even in the compact tale, we get to see the two-way street that always exists when a marriage goes badly. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457093269677/Tabarro%202.jpg.jpg)
<figcaption>Patricia Racette as Giorgetta, Carl Tanner as Luigi. Copyright: ROH. Photographer: Bill Cooper.</figcaption>
</figure>

Yet, it was [Carl Tanner](/scene/people/carl-tanner/) as Luigi who stole the show. As the barge worker, having a very secret affair with Giorgetta, Tanner had brilliant versatility in his voice. He sang both with the air of an Italian serenader, full of joy and charisma, and with the same shared desperation as Giorgetta, longing for a better life in Paris, and with her. Together, they were the two complete people in this dark story, and that was what made them tragic.

There was some lovely singing by two members of the Jette Parker Young Artists Programme, tenor David Junghoon Kim and soprano Lauren Fagan. Kim had the infamously meta quotes from *La bohème*, and although our view of him was slightly obscured in the Amphitheatre (the Amphie, we heard it called?), his voice rang out friendly and kind. Along with Luis Gomes, Lauren Fagan sang with a clear brilliance as the two lovers. I hope we'll get to hear lots more from these artists as the season continues.

As familiar as Puccini can get for any opera-goer, shows like *Il tabarro* remind us of his skills in dramatic timing. The gruesome finale to the act builds quickly and terribly, with a final blackout the only response to Giorgetta's shriek upon finding her lover dead at her husband's hands. It's a rare thing in opera to find no true denouement; it makes your breath catch, and it almost makes you *want* the emotional catharsis that *Suor Angelica* brings.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457093285896/Tabarro%201.jpg.jpg)
<figcaption>Lucio Gallo as Michele, Patricia Racette as Giorgetta. Copyright: ROH. Photographer: Bill Cooper.</figcaption>
</figure>

*Suor Angelica* unfolds in Miriam Buether's sterile set, depicting a children's hospital run by the nuns. There was a church-like arc that shaped this hospital, and in contrast to the expansive street scene of *Il tabarro*, this set seemed too small, too confining. The story is just as claustrophobic, one where even without the historically oppressive presence of men, women still can't seem to find freedom. The powerful women were almost eerily so; Irina Mishura as the Abbess, Elena Zilio as the Monitress, and Anna Larsson as the Princess, they were all terrifying in voice and demeanour. Who needs mean men when you've got mean women, right? Larsson was particularly great at making our skin crawl, especially with the full fox pelt she brought as her primary accessory.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457094702069/Suor-2.jpg.jpg)<figcaption>Ermonela Jaho as Sister Angelica. Copyright: ROH. Photographer: Bill Cooper.</figcaption>
</figure>

As it should be, [Ermonela Jaho](/scene/people/ermonela-jaho/) was entirely heartbreaking as Suor Angelica. She stood out among the sea of identically dressed nuns almost immediately, with an air of calmness that somehow felt too wise for a Sister. Jaho was stunning throughout, and she managed to unveil a long familial history in her infamous scene with her aunt, the Princess. Her soft singing in "Senza mamma" could have been straight from a lullaby to a sleeping child, and it made her outbursts hurt even more. 

Jaho's voice cut right through us; she had an enormous sound in the house, and she didn't hold back from letting wildness into her sound when the story needed it. Her curtain call was almost as affecting as her performance; it was a candid moment where the singer has put everything into a role, and she feels the audience recognize and appreciate it. It was a special moment, and one that brought us closer to the story, even in hindsight.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457094685004/Suor-1.jpg.jpg)
<figcaption>Anna Larsson as The Princess, Ermonela Jaho as Sister Angelica. Copyright: ROH. Photographer: Bill Cooper.</figcaption>
</figure>

After all the tears, there's nothing left to do but laugh. *Gianni Schicchi* rounds out *Il trittico*, with the mercifully hilarious tale of a family of horrible people, acting horribly after the death of their "beloved" uncle Buoso. Lucio Gallo returned to sing the title role, with a relaxed air about him and a costume by Nicky Gillibrand that made me think of [Earnest P. Worrell](https://en.wikipedia.org/wiki/Ernest_P._Worrell). 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457093319019/Schicchi%202.jpg.jpg)
<figcaption>Lucio Gallo as Gianni Schicchi, Susanna Hurrell as Lauretta. Copyright: ROH. Photographer: Bill Cooper.</figcaption>
</figure>

This ensemble show had a truly ensemble cast of colourful, complete characters. Elena Zilio had shaken off the habit of the Monitress, and traded it for the tight, strong manner of Buoso's cousin, Zita. Along with Gwynne Howell as Simone, Jeremy White as Betto di Signa, the senior members of the Donati family were vulturous in the best way. The younger generation, including Marco and Gherardo (sung respectively by David Kempster and Carlo Bosi) and their wives La Ciesca and Nella (Marie McLaughlin and Rebecca Evans) were ridiculous individuals in mesmerizing costumes and fantasti slapstick comedy.

Tenor Paolo Fanale and soprano Susanna Hurrell were a beautiful, adorable Rinuccio and Lauretta. They were melodramatic and funny, and both sang with a youthful brightness that never bordered on annoying. As Schicchi, Gallo had an honest relationship with the pair, and we believed his final monologue about spending money on young love.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457093337400/Schicchi%201.jpg.jpg)
<figcaption>Rebecca Evans as Nella, Lucio Gallo as Gianni Schicchi, Carlo Bosi as Gherardo, Marie McLaughlin as Nella. Copyright: ROH. Photographer: Bill Cooper.</figcaption>
</figure>

*Il trittico* runs at the Royal Opera House until March 15. It's a beautiful and exhausting night at the opera, and absolutely worth a visit. For details and ticket information, follow our box office links below.
