+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-05-30T08:42:00-04:00"
lastmod = "2017-05-30T08:49:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148209163/Square-Hipermestra-Glyndebourne-2493.jpg.jpg"
primary_image_credit = "Hipermestra (Emőke Baráth) in Hipermestra, Glyndebourne, 2017. Photo: Tristam Kenton."
publishDate = "2017-05-30T08:49:00-04:00"
related_articles = ["articles/in-review-a-midsummer-nights-dream-at-glyndebourne.md","articles/in-review-beatrice-et-benedict-at-glyndebourne.md","articles/in-review-hamlet-at-glyndebourne.md","articles/in-review-the-cradle-will-rock.md","articles/in-review-collision-at-grimeborn.md"]
related_companies = ["scene/companies/glyndebourne.md"]
short_description = "Fifty brides, a giant flying peacock, and appropriated costumes from the middle east are all present in Glyndebourne’s new production of Hipermestra by Cavalli. Long-established Glyndebourne veterans William Christie and Graham Vick collaborated to bring this opera to life for the first time since the seventeenth century."
slug = "in-review-hipermestra-at-glyndebourne"
title = "In review: Hipermestra at Glyndebourne"
+++

Fifty brides, a giant flying peacock, and appropriated costumes from the middle east are all present in Glyndebourne’s new production of *Hipermestra* by Cavalli. Long-established Glyndebourne veterans William Christie and Graham Vick collaborated to bring this opera to life for the first time since the seventeenth century.

There was stunningly vulnerable singing from the ensemble cast, with Hungarian soprano Emőke Baráth in the very demanding title role. Her glassy voice is perfect for this music, and she held our attention through hours of lamenting. Raffaele Pe’s countertenor voice is flexible and light, while not losing the strength required to sing the militant Linceo. The rest of the ensemble cast were just as much actors as they were singers, a characteristic which is absolutely vital to keep the music from this style alive.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148361043/Hipermestra-Glyndebourne-47.jpg.jpg)
<figcaption>Hipermestra (Emőke Baráth) in *Hipermestra*, Glyndebourne, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

The ten musicians in the pit were absolutely the highlight of this piece. The players from the Orchestra of the Age of Enlightenment provided some of the most innovative continuo playing we’ve heard recently, almost as if a new sound world was being born in East Sussex. One of the smallest ensembles Glyndebourne has ever seen, conductor William Christie and leader Kati Debretzeni prove that less is more when it comes to seventeenth century opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148382945/Hipermestra-Glyndebourne-1893.jpg.jpg)
<figcaption>Act II scene from *Hipermestra*, Glyndebourne, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

It was fascinating to see how far performance practice has come since Glyndebourne’s famous productions of Cavalli’s *L’Ormindo* and *La Calisto* in the 1960’s. When Raymond Leppard presented these two operas, musical and dramatic taste just wasn’t in the right position to allow for early Venetian opera to be performed as it would have been in Cavalli’s lifetime. Instrumentation was added, vocal lines were transposed, and the structure was cut and pasted dramatically to try to conform to post-Mozartean opera convention. Though cut down from its original state, Hipermestra is presented without added non-period instruments, with niche singers, and occupied a musical space foreign to modern ears.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148429103/Hipermestra-Glyndebourne-1759.jpg.jpg)
<figcaption>Linceo (Raffaele Pe) and Arbante (Benjamin Hulett) in *Hipermestra*, Glyndebourne, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

There are tons of reasons to see *Hipermestra* - this is the first professional staging of the work in more than three hundred years, the instrumentalists are making true musical magic, the singers give a masterclass in the art of performing recitative and in providing cadential ornaments - but something must be said about the orientalist nature of this opera, and as a consequence the racist nature of this production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148462769/Hipermestra-Glyndebourne-2645.jpg.jpg)
<figcaption>Hipermestra (Emőke Baráth), Linceo (Raffaele Pe), Elisa (Ana Quintans) and Arbante (Benjamin Hulett) in *Hipermestra*, Glyndebourne, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

Hipermestra tells the myth of an Egyptian king, who orders his fifty daughters to marry the fifty sons of his twin brother, after hearing a prophecy that one of those sons will kill him. Cavalli sets this story in a sensationalized Egypt, and Graham Vick has moved the action to a sensationalized version of any country in the modern middle east.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148486592/Hipermestra-Glyndebourne-844.jpg.jpg)
<figcaption>Berenice (Mark Wilde) in *Hipermestra*, Glyndebourne, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

While this feels like an insensitive move, it is hard to imagine a production of Hipermestra that wouldn’t have come out at least a little bit racist, unless names, pronouns, and key plot points were changed. However, if Vick’s intention was to make the audience uncomfortable, he achieved that by providing us with the sight of a white man wearing a hijab. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148507024/Hipermestra-Glyndebourne-321.jpg.jpg)
<figcaption>Hipermestra (Emőke Baráth) in *Hipermestra*, Glyndebourne, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

This is not to say that there haven’t been operas presented to us that challenge our notions of Arabic culture and make us question the morality of existing in a predominantly white art form. There are musical works being presented as of recent that bring attention to refugees and show light on the attainability of peace. Despite the inevitable racism that will occur from staging this opera, *Hipermestra* should see more performances - there should be more productions of this piece if it means the conversation will continue and we will grow as an art form to be more inclusive and willing to understand other cultures. Although Vick’s production is problematic by not giving a real voice to the people of the middle east, it will hopefully have gotten people talking about appropriation and orientalism in opera and in art.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496148520818/Hipermestra-Glyndebourne-2668.jpg.jpg)
<figcaption>inceo (Raffaele Pe) and Hipermestra (Emőke Baráth) in *Hipermestra*, Glyndebourne, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

*Hipermestra* plays at Glyndebourne through July 8th.

