+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-04-18T16:56:00-04:00"
lastmod = "2015-04-27T21:19:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429839149729/Alice-Hercules1-1024x643.jpg.jpg"
primary_image_credit = "All photos by Michael Cooper"
publishDate = "2014-04-18T16:56:00-04:00"
related_articles = []
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/alice-coote.md","scene/people/lucy-crowe.md","scene/people/eric-owens.md"]
short_description = "I went and saw Hercules at the Canadian Opera Company on Tuesday, and it was the jackpot of incredible talent onstage. It&#039;s directed by the one-of-a-kind Peter Sellars, conducted by the brilliant Harry Bicket, and Eric Owens and Alice Coote star as the soldier and soldier&#039;s wife. Beautiful. And it really was a stunning spectacle, one with an uncomfortably true message."
slug = "in-review-hercules"
title = "In review: Hercules"
+++

I went and saw [_Hercules_](http://www.coc.ca/PerformancesAndTickets/1314Season/Hercules.aspx) at the Canadian Opera Company on Tuesday, and it was the jackpot of incredible talent onstage. It's directed by the one-of-a-kind [Peter Sellars](http://en.wikipedia.org/wiki/Peter_Sellars), conducted by the brilliant [Harry Bicket](http://www.askonasholt.co.uk/artists/conductors/harry-bicket), and [Eric Owens](http://imgartists.com/artist/eric_owens) and [Alice Coote](http://imgartists.com/artist/alice_coote) star as the soldier and soldier's wife. Beautiful. And it really was a stunning spectacle, one with an uncomfortably true message. [I saw Sellars speak about this production](/peter-sellars-all-my-subtexts-were-understatements/), and what it tells us about the effect of war, absence and PTSD have on a solider and his family. Based on Sophocles' play _Women of Trachis_, Handel's _Hercules_ really is about the hero's family. It's clear that both Sophocles and Handel knew that as well; Hercules himself sings little in comparison with his wife Dejanira, his son Hyllus and his prisoner, Iöle.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429839218736/0437-Dejanira-Iole-Credit-Michael-Cooper-1024x681.jpg.jpg)
</figcaption>Alice Coote and Luce Crowe. Photo by Michael Cooper.</figcaption>
</figure>

I'll admit right away that I had seen the dress rehearsal of _Hercules_, and so it wasn't necessarily all new for me. But I'd sat in the orchestra level for the dress, and my tickets for the other night were on the third ring; I had a much better view of the set, and it illuminated a lot in Sellars' story that I hadn't caught upon my first look. With crumbling pillars, set designer [George Tsypin](http://georgetsypin.com/www/) made us thinking of ancient Greece; the pillars surrounded a big pit of what look like glowing embers, and a huge, transforming backdrop behind it all. The embers and backdrop turned different colours and textures, acting like a chameleon to the drama onstage. With lighting designer [James F. Ingalls](http://en.wikipedia.org/wiki/James_F._Ingalls), Tsypin's set became like a second chorus, telling the audience what the characters were feeling, even if they couldn't express it for themselves.

The cast was spectacular, with the unbelievable Alice Coote in the foreground. As Hercules' wife, Dejanira, she was stunning, heartbreaking, and with thirteen arias to sing, her vocal stamina was almost _herculean_ (had to). From her first "O, Hercules" to her final and extraordinary mad scene, Alice was the stuff of this opera. The whole theatre could empathize with Dejanira's story. We saw her miss her husband and finally see him at last, and we saw her realize he was not the same man. She was a beautiful actor who took us through a complicated dramatic arc, and I couldn't take my eyes off of her. She sang with weeping legato or determined coloratura, and she didn't shy away from making an ugly sound if the scene warranted it. Her mad scene was truly mad, and her final shrieking phrases terrified me. _She was so good_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429839272084/0585-Hyllus-Iole-Credit-Michael-Cooper-681x1024.jpg.jpg)
<figcaption>Richard Croft and Lucy Crowe. Photo by Michael Cooper.</figcaption>
</figure>

The second star of the evening was soprano [Lucy Crowe](http://www.askonasholt.co.uk/artists/singers/soprano/lucy-crowe) as Iöle, the foreign princess whose father was killed by Hercules, and was taken as "spoils of war". Lucy has one of the most honest and compelling voices I've heard in a long time. It's not the most perfectly polished voice, but she was enormously expressive in her singing. Her first aria was sung largely with her head covered by a black hood, and still I felt for her. From her hysterical first entrance (kind of like back-to-back mini mad scenes) to her final wise words of comfort to the widowed Dejanira, Lucy was a singing actor the whole time. Sellars made a lot out of this character that may have been missed in other productions, in particular Iöle's interactions with Hercules' family.

Grammy Award-winning bass-baritone Eric Owens made his COC debut in the title role, and I couldn't help noticing that Handel hadn't written Hercules to be chatty. The role was about demonstrating distance between him and his wife, and Eric succeeded in doing that; it was clear when he first stepped onstage that he was not someone with whom Dejanira had anything in common, and it was a painful realization for both of them. I got frustrated with Hercules' inability to communicate or emote, which I think means Eric did his job. Vocally, I was less sold on Eric than the rest of the cast. He had plenty of power, and he too risked ugly sounds for the sake of text; but he didn't seem to fit as easily into the Handel style as others in the cast. Eric's vibrato tended to get a bit wild and wide, and at times it made it hard for me to tell what pitch he was actually singing; it obscured the few moments of coloratura he had. I also wasn't sold on his audible sounds of pain during Hercules' death scene; I'm assuming Sellars asked for them, and Eric did so intelligently, without wrecking his throat for his last bit of singing. But the problem was that Eric's singing voice is so powerful that anything else sounds weak in comparison. I think Handel wrote the death scene with a few problems for directors, but I don't think that hearing audible screams actually added to the scene in this context.

As Hyllus, Hercules' son, [Richard Croft](http://imgartists.com/artist/richard_croft) was a total pro. His aria at the top of the second act, "From celestial seats descending" was simple and drew me towards him. He also had some brilliant moments of coloratura, which was like a machine-gun, healthily sung, and completely a Richard Croft-ism. Hyllus is a tricky, somewhat thankless role, but Richard sang it wisely and created an endearing character. In this production, Hyllus walks with the help of crutches; I didn't think it was a necessary detail, and it made him seem more pathetic than he needed to be, but Richard's great singing took most of my attention, and Sellars' take on the role of Hyllus didn't bug me.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429839324631/0802-Hercules-Credit-Michael-Cooper-719x1024.jpg.jpg)
<figcaption>Eric Owens in Peter Sellars' Hercules. Photo by Michael Cooper.</figcaption>
</figure>

American counter-tenor [David Daniels](http://www.danielssings.com/) sang the role of the herald Lichas, and it was treat for me to hear him sing live. He sang the first aria of the evening, and he truly set the bar for what this cast was able to do with the _da capo _form. Lichas spends most of his time onstage acting as a sympathetic friend to Dejanira, or as a dramatic liaison for the audience. Those are tricky dramatic intentions to play, but David wisely let his voice to the work. He sang with a career's worth of understanding of this music, and with a warm, empathetic sound. He was another Handel pro, and I hope this COC debut of his won't be his last visit to Toronto.

The music for the whole evening was stunning. Harry Bicket expertly led the COC orchestra like it was a chamber ensemble, finding hidden solo lines for us to hear and giving room for each singer to do what they do best. The COC Chorus really sounded fantastic. In _Hercules_, the chorus is used in the Greek-chorus style, commenting on the action by the leads, and telling the audience about the characters' true feelings. Sellars used gestures as a form of choreography with the chorus, associating a motion with a specific word, or even a syllable ("tyrant" had two separate gestures, eg.). I wasn't fully convinced by the execution, but the gestures definitely made me listen differently to the music. I could literally see the counterpoint in the chorus music, especially the "Jealousy" chorus right before intermission. It was really effective.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429839391127/0941-Scene-from-Hercules-Credit-Michael-Cooper-1024x595.jpg.jpg)
<figcaption>Photo by Michael Cooper.</figcaption>
</figure>

The chorus also brings up a final thought on this piece. Their costumes (by costume designer Dunya Ramicova) most clearly demonstrated Sellars' conception of time and place in his _Hercules_. Some of the chorus wore amy tee-shirts and camouflage pants, some of the women wore wore Grecian-style gowns, and some men wore retro-looking outfits that reminded me a little of Sellars' own fashion style. The span of associations with these symbolic costumes is telling us that this story of soldiers, returning home from war, hopelessly disconnected from their lives at home with their families, is a story that is timeless. I personally got that message despite a few of the details onstage that were very time-specific, like a barbecue-grill, or a coffin draped in an American flag. Those sights jarred me a little, because of the timeless feel of everything else; I get Sellars' point, however, and I think he said important things with this half-forgotten oratorio of Handel's.

_Hercules_ plays at the Four Seasons Centre plays until April 30th, with only a few shows left. For details and ticket information, click [here](http://www.coc.ca/PerformancesAndTickets/1314Season/Hercules.aspx).
