+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-10T23:06:00-04:00"
lastmod = "2015-04-10T23:06:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428721261112/16539825350_8740547eb0_k.jpg.jpg"
primary_image_credit = "Molly Parker in Harper Regan. David Hou"
publishDate = "2015-03-05T10:05:00-05:00"
short_description = "For a while, I’ve been itching for a change: I wanted to see more non-musical theatre. Maybe it’s because opera lets me hear fantastic singers regularly, but there’s rarely a person onstage who started their training in drama, rather than music. I was really thrilled to be able to catch Simon Stephens‘ play Harper Regan at Canadian Stage, which premiered in 2008 at the Royal National Theatre. I figured it would quell my straight theatre bug, and I was clearly curious to see Molly Parker (House of Cards, Deadwood) in the title role. Harper Regan is inspired by the Greek plays surrounding the House of Atreus, and the stories of a cursed family"
slug = "in-review-harper-regan"
title = "In review: Harper Regan"
+++

<p>
	For a while, I've been itching for a change: I wanted to see more non-musical theatre. Maybe it's because opera lets me hear fantastic singers regularly, but there's rarely a person onstage who started their training in drama, rather than music. I was really thrilled to be able to catch <a href="https://twitter.com/stephenssimon" target="_blank">Simon Stephens</a>' play <a href="https://www.canadianstage.com/Online/" target="_blank"><em>Harper Regan</em> at Canadian Stage</a>, which premiered in 2008 at the Royal National Theatre. I figured it would quell my straight theatre bug, and I was clearly curious to see <a href="http://www.imdb.com/name/nm0662504/" target="_blank">Molly Parker</a> (<em>House of Cards</em>, <em>Deadwood</em>) in the title role. <em>Harper Regan</em> is inspired by the Greek plays surrounding the <a href="http://ancienthistory.about.com/od/houseofatreus/a/houseofatreus.htm" target="_blank">House of Atreus</a>, and the stories of a cursed family. "The lesson the Greeks passed down to us is that consciousness – recognizing and articulating the seed of a problem – can provoke change," writes director <a href="https://www.canadianstage.com/Online/default.asp?doWork::WScontent::loadArticle=Load&amp;BOparam::WScontent::loadArticle::article_id=7C4503FD-70D1-460E-A2F6-006F96045BD8" target="_blank">Matthew Jocelyn</a>in his notes. Harper Regan learns that her father is dying, and after getting denied time off from work to visit him, she decides to secretly leave anyway. She arrives at the hospital too late to see her dad, and spends the leftover time on her illicit trip doing what she can't in front of her family. Jocelyn, who is also the Canadian Stage's Artistic &amp; General Director, says, "Harper adorns a new identity, a leather jacket she steals from a bar, and throws herself into a series of unforeseen encounters which, accumulatively, will enable her to recognise and articulate."
</p>
<p>
	There is something powerfully satisfying about the way Stephens writes. His characters have conversations so densely packed with meaning that they really stay with you. The dialogue always cuts to the point of the scene quickly, but never seems to lack an organic progression between the characters. They spoke with almost imperceptible oddities, like complimenting one's skin or shoulders; the British-isms (bollocks, etc.) even sounded as though they were the mannerisms of the people in Harper's world.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428721368975/16104925294_e2c0b963e6_k.jpg"><img data-resize-src="http://lh3.googleusercontent.com/H2dEquVS-Vwnat6bfe9WpWAeCDL41UIKTpo4nPcswXq8_Ta1b93uVfVdDM102qB-y6wxfIT-2DLnBQVhlEGsbl54G4yLvQ" src="http://lh3.googleusercontent.com/H2dEquVS-Vwnat6bfe9WpWAeCDL41UIKTpo4nPcswXq8_Ta1b93uVfVdDM102qB-y6wxfIT-2DLnBQVhlEGsbl54G4yLvQ=s1200"></a><figcaption>Vivien Endicott-Douglas and Molly Parker. Photo: David Hou</figcaption></figure>
<p>
	In the title role, <a href="https://twitter.com/themollyparker" target="_blank">Molly Parker</a> was extraordinary. Her Harper had all the sides of a real human being, beginning with meek and agreeable in front of her boss (Parker's frailty was so realistic that I was momentarily worried), to placating and subordinate at home with her family, and finally as a deeply curious, unashamed woman fighting responsibilities and circumstances. For me, Harper was one of those characters that I really grew to understand over two hours. I loved that Stephens wrote a character with "faces", open for interpretation over which one is the real deal.
</p>
<p>
	I was excited to see Parker, of course, but the entire cast gave fantastic performances.<a href="http://www.imdb.com/name/nm1659389/" target="_blank">Vivien Endicott-Douglas</a> played Sarah Regan, Harper's daughter, a sullen, frustratingly smart teenaged girl. She was a beautiful mix of a teenager's poor foresight, and a young adult who is sick of having her thoughts ignored. Vivien was also cast as Justine Ross, a nurse at the hospital where Harper's father died. I loved the choice of casting these roles together; in both characters, Vivien was a confusing, somehow wise, daughter-like figure, one around which Harper doesn't really know how to act.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428721391965/16726170592_06e80f8143_k.jpg"><img data-resize-src="http://lh3.googleusercontent.com/cUz7KDuWUs1CecYxcpdT4dc44R8potKX30shjtZus6Ej2aYYBxSRqsv3p43Mp6Yv6PxgyrNyCvQsQLJhuGm_Oefje3bd" src="http://lh3.googleusercontent.com/cUz7KDuWUs1CecYxcpdT4dc44R8potKX30shjtZus6Ej2aYYBxSRqsv3p43Mp6Yv6PxgyrNyCvQsQLJhuGm_Oefje3bd=s1200"></a><figcaption>Izaak Smith and Molly Parker. Photo: David Hou</figcaption></figure>
<p>
	<a href="http://www.imdb.com/name/nm0687843/" target="_blank">Alex Poch-Goldin</a> played both Seth Regan, Harper's husband, and James Fortune, a married man with whom Harper has an Internet hookup. As Seth, Poch-Goldin establishes a cool, tongue-bitten marriage, in which he plays the role of the apologetic. I loved how Harper's fling, James, appeared to be a more confident version of Seth; by the end of <em>Harper Regan</em>, we can see that Seth was really just a more troubled version of James. Poch-Goldin had a beautiful monologue in the final scene, which reminded me of <a href="http://www.philadelphiaweekly.com/news-and-opinion/savage-love/Lets-Say-Im-A-Pedophile-83404047.html" target="_blank">this piece heartbreaking piece by advice columnist Dan Savage</a>.
</p>
<p>
	As both Harper's boss, Mr. Barnes, and her mother's new husband, Duncan, <a href="http://www.imdb.com/name/nm0512620/" target="_blank">Hardee T. Lineham</a> left a huge impression on me, beginning with his great, ornery rant about how "there's always the Internet!"<a href="http://www.imdb.com/name/nm0341289/" target="_blank"> Lynne Griffin</a> was a refreshing dose of reality and frankness as Harper's mother, Alison. Hers was an incredibly real scene, in which a daughter is exasperated with her mother, and the mother is done caring; it's beautifully written, and Lynne is really stunning. I absolutely adored <a href="http://www.imdb.com/name/nm3575328/" target="_blank">Izaak Smith</a> as Tobias and Mahesh, both teenaged characters who have charmingly awkward encounters with the cougar-like Harper. Honestly, the scenes between Tobias and Harper were moments of genius; Stephens managed to write down that unsure and unpredictable way that teenagers act, when they're talking to adults who aren't their parents or their teacher. Cringe-worthy and endearing at the same time. <a href="http://companytheatre.ca/ensemble/philip-riccio/" target="_blank">Philip Riccio</a> packed a huge punch in his short scene as Mickey, the morning drunk who does drugs in a bar. He had that charisma that seems to outweigh all his bad habits, and so I understood when Harper started to get tempted. Riccio had some of those moments of dense dialogue, and his character was one that stuck with me.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428721492828/16519963387_803f016cc3_k.jpg"><img data-resize-src="http://lh3.googleusercontent.com/f2ruwAO_q6v3QDlrLyozu9kmfBhefA7va9yuz-EO_UcB_QbUFCqfvDYKjGFCxq58c1vBhnKhkmkpREmG4woLcOASOhmr" src="http://lh3.googleusercontent.com/f2ruwAO_q6v3QDlrLyozu9kmfBhefA7va9yuz-EO_UcB_QbUFCqfvDYKjGFCxq58c1vBhnKhkmkpREmG4woLcOASOhmr=s1200"></a><figcaption>Molly Parker and Philip Riccio. Photo: David Hou</figcaption></figure>
<p>
	I loved how director Matthew Jocelyn tells this story, with slightly meta-theatrical elements in place before it begins. The minimal design by <a href="http://www.abouttheartists.com/artists/287497-debra-hanson" target="_blank">Debra Hanson</a> was suggestive and versatile, and allowed us to focus entirely on the characters and what they were saying. The cast were seated upstage and dimly lit, almost entirely throughout, reminding the audience that they, like Harper, couldn't ignore the people in her life. Sound Designer<a href="http://ttdb.ca/people/thomas-ryder-payne/" target="_blank"> Thomas Ryder Payne</a>'s scene transitions were overwhelming, and often startlingly loud; I loved, though, how they went from being oppressive to feeling like white noise, like a much-needed scream after a tensely quiet moment. Two powerful and opposing tableaus closed each of the acts, the first was Harper smoking in a leather jacket, and the last was the Regan family at the breakfast table. It gave a film-like quality to the closing of the piece.
</p>
<p>
	<em>Harper Regan</em> was a totally successful experiment in the hunt for non-musical theatre fixes. The cast is stunning, and the production serves the story beautifully, so do try to see it this month. It plays until March 22nd at the Bluma Appel Theatre, 27 Front St. E. <a href="https://www.canadianstage.com/Online/default.asp?BOparam::WScontent::loadArticle::permalink=harper#tickets" target="_blank">Click here for details and to purchase tickets</a>.
</p>
