+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-06-22T09:11:00-06:00"
lastmod = "2017-06-22T09:49:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498144664682/2017-06-22---Hamlet_050617photoRichardHubertSmith-7071-copy.jpg.jpg"
primary_image_credit = "Allan Clayton as Hamlet in Brett Dean's Hamlet, Glyndebourne Festival 2017. Photographer Richard Hubert Smith "
publishDate = "2017-06-22T09:23:00-06:00"
related_articles = ["articles/in-review-hipermestra-at-glyndebourne.md","articles/in-review-beatrice-et-benedict-at-glyndebourne.md","articles/magic-high-standards-midsummer-at-glyndebourne.md","articles/in-review-the-cradle-will-rock.md","articles/in-review-the-merchant-of-venice.md","articles/in-review-collision-at-grimeborn.md"]
related_companies = ["scene/companies/glyndebourne.md"]
related_people = ["scene/people/allan-clayton.md","scene/people/barbara-hannigan.md","scene/people/sir-john-tomlinson.md"]
short_description = "Allan Clayton was sensational in the title role. From the first scene we get a sense that he is a black sheep to the rest of the royal family, and in the two acts of the opera he is in a constant state of unhinge - sometimes he is laughing and enjoying life with Horatio, but one comment from Gertrude can set him off into a frenzy. Clayton played Hamlet on the brink of a breakdown without sacrificing the beauty in his vocal production."
slug = "in-review-hamlet-at-glyndebourne"
title = "In review: Hamlet at Glyndebourne"
+++

This season is turning out to be pretty groundbreaking at Glyndebourne - the summer festival has already brought us an [unearthed opera by Cavalli](/in-review-hipermestra-at-glyndebourne/), and in addition we are getting their first commission since Peter Eötvös' *Love and Other Demons* in 2008. Brett Dean's operatic adaptation of *Hamlet* certainly gave us what we expect from a commission of Glyndebourne: exciting music, captivating storytelling, and tons of moments for the ensemble cast to shine vocally and dramatically.
 
Conductor Vladimir Jurowski led the orchestra through two acts of exceedingly difficult and effect-driven music. While the singers were given long lines that very effectively did service to Shakespeare's text, the orchestra's impetus was rhythm, often with electronic effects of what sounding like glasses breaking or water dripping. The electronics and percussion were very cleverly placed on opposite sides of the stage, giving a surround-sound effect that added a dimension to our perception of the music. Dean's constant use of a semi-chorus from the pit added to the psychological drama of the story - these eight voices became whispers during Ophelia's mad scene, repeated turning point moments of text from Hamlet, giving insight into what was going on in the minds of the main characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498144751303/2017-06-22---Hamlet_050617photoRichardHubertSmith-8799.jpg.jpg)
<figcaption>Act II scene. Centre: Hamlet (Allan Clayton) and Laertes (David Butt Philip) in *Hamlet*, Glyndebourne Festival 2017. Photographer Richard Hubert Smith.</figcaption>
</figure>
 
Between the libretto adapted by Matthew Jocelyn from the original Shakespeare and the stage direction of Neil Armfield, the focal point of this opera was clearly the psychological state of not just Hamlet but all of the characters. In the two acts of the opera none of the characters really develop - they arrive to the lavish dinner party of the first scene in the same way they will die at the end of the opera. At the beginning we see Ophelia as reserved and fully clothed but clearly tormented by the uncertainty of Hamlet's love for her. Gertrude and Claudius never give up their poise and regal air until it is physically impossible for them to hold it together as Gertrude very dramatically projectile vomits across the stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498144762333/2017-06-22---Hamlet_050617photoRichardHubertSmith-8138-copy.jpg.jpg)
<figcaption>Ghost of Old Hamlet (John Tomlinson) and Hamlet (Allan Clayton) in *Hamlet*, Glyndebourne Festival 2017. Photographer Richard Hubert Smith.</figcaption>
</figure>

This lack of development in the characters paired with virtually the entire audience's prior knowledge of the plot, there was quite little to be shocked about during the evening. Yes, there were captivating moments from the performers and from the new music, but to an extent it was very easy to predict how the show would go. This is bound to be a problem in any adaptation, and it was fortunate that there was such an incredible cast to maintain interest in the piece.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498144771362/2017-06-22---Hamlet_050617photoRichardHubertSmith-8508-copy.jpg.jpg)
<figcaption>Hamlet (Allan Clayton) and Horatio (Jacques Imbrailo) in *Hamlet*, Glyndebourne Festival 2017. Photographer Richard Hubert Smith.</figcaption>
</figure>
 
[Barbara Hannigan](/scene/people/barbara-hannigan/) proved to be a highlight of the evening, using virtuosic extended techniques that heightened Ophelia's madness in a way that is only possible in opera. Hannigan clearly has a deep understanding of her character's tormented nature, which being mixed with her unrivaled musicality was a recipe for true artistry during her Glyndebourne debut. The powerful voice of [Sir John Tomlinson](/talking-with-singers-sir-john-tomlinson/) was lended to three small roles in the opera, from Hamlet's dead father to a stage player and finally to a grave digger.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498144779659/2017-06-22---Hamlet_050617photoRichardHubertSmith-8397-copy.jpg.jpg)
<figcaption>Ophelia (Barbara Hannigan) in *Hamlet*, Glyndebourne Festival 2017. Photographer Richard Hubert Smith.</figcaption>
</figure>

[Allan Clayton](/scene/people/allan-clayton/) was sensational in the title role. From the first scene we get a sense that he is a black sheep to the rest of the royal family, and in the two acts of the opera he is in a constant state of unhinge - sometimes he is laughing and enjoying life with Horatio, but one comment from Gertrude can set him off into a frenzy. Clayton played Hamlet on the brink of a breakdown without sacrificing the beauty in his vocal production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498144919861/2017-06-22---Hamlet_050617photoRichardHubertSmith-8202-copy.jpg.jpg)
<figcaption>Act I, scene 1 of *Hamlet*, Glyndebourne Festival 2017. Photographer Richard Hubert Smith.</figcaption>
</figure>
 
As always, we are grateful for big companies for commissioning new operas. Adapting Shakespeare is an immense task, with no guarantee of creating a successful piece of theatre after cutting up what many in Britain consider to be sacred text. Brett Dean and Matthew Jocelyn certainly undertook this effort successfully. As this was only Dean's second opera, we can't wait to see his third.
 
Hamlet runs at the Glyndebourne Festival in Lewes until July 6th; production will resume this autumn for the company's 2017 tour.

