+++
author = ["authors/greg.md"]
categories = "Review"
date = "2017-02-03T12:30:00+00:00"
lastmod = "2017-02-03T17:54:00+00:00"
preamble = "Image: The Rhinemaidens: (l-r) Lauren Eberwein as Wellgunde, Danika Lorèn as Woglinde and Lindsay Ammann as Flosshilde in the Canadian Opera Company's production of *Götterdämmerung*, 2017, photo: Michael Cooper."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486125295809/2017-02-03---Gotterdammerung-MC-2169.jpg.jpg"
publishDate = "2017-02-03T17:54:00+00:00"
related_articles = ["articles/talking-with-singers-christine-goerke.md","articles/in-review-die-walkre-at-the-coc.md","articles/aviva-fortunata-it-was-a-total-blur.md","articles/kinder-schafft-neues-die-meistersinger-von-nrnberg.md","articles/review-arabella-or-poor-little-rich-girl.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/andreas-schager.md","scene/people/christine-goerke.md","scene/people/ain-anger.md","scene/people/lauren-eberwein.md","scene/people/danika-lorn.md","scene/people/karen-cargill.md"]
short_description = "Thursday night, I blew into the Four Seasons Centre for the Performing Arts almost immediately after work - even planning all week I still just made the 5 minute call before the early curtain at 6pm. As is said before, this is my virgin Wagner (it was so hard not to write &quot;Wirgin Wagner&quot; just now) but I&#039;m not unfamiliar with the Ring Cycle, and being the huge Tolkien junkie I am, I love me a good epic."
slug = "in-review-gotterdammerung-at-the-coc"
title = "In review: Götterdämmerung at the COC"
+++

I've been around a while. I've sung a lot of music. I've teched (worked backstage) for even more. Due to the way performing and rehearsal schedules have always worked out in the past, I found myself, at this late juncture, *finally* witnessing my first full, fully-staged Wagner opera.

When you're in university or college and you're taking your survey history course, you reach the German Romantic monolith that is Wagner, and you learn the terms *gesamkunstwerk* (the "total art") and *leitmotif* (for the sake of expediency - "theme music for a character"). You listen, you look at clips, you talk about it to great extent using a whole host of delicious words like "harmonic variance" and "through composition" - but it's not until you actual *see it* done, and in this case done very well, before you realize the depth and complexity of all these terms. 

Thursday night, I blew into the Four Seasons Centre for the Performing Arts almost immediately after work - even planning all week I still just made the 5 minute call before the early curtain at 6pm. As is said before, this is my virgin Wagner (it was so hard not to write "Wirgin Wagner" just now) but I'm not unfamiliar with the *Ring Cycle*, and being the huge Tolkien junkie I am, I love me a good epic.

A full work consisting of four massive operas (*Das Rheingold*, *Die Walküre*, and *Siegfried* being parts I, II, and III), [*Götterdämmerung*](http://www.coc.ca/PerformancesAndTickets/1617Season/Gotterdammerung.aspx) (stunningly directed here by Tim Albery) is the final volume in *Der Ring des Nibelungen*, and tells the tale of the reckoning of the Norse gods and how they meet their fiery end. It starts with the three Norns reaching the end of their powers (think the Fates in Disney's animated film *Hercules*). Kindly, they provide us with all the exposition that's happened in the last three volumes. Then we're dropped into the bower of Brünnhilde, rejoicing in and with her love Siegfried who rescued her from Wotan's ring of fire. The Gibichung characters Gunther and Gutrune, along with their half brother Hagen, plot to get the ring for themselves by enchanting the impulsive Siegfried. Chaos ensues.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486125264806/2017-02-03---Gotterdammerung-MC-2028.jpg.jpg)
<figcaption>(l-r, foreground) Christine Goerke as Brünnhilde, Andreas Schager as Siegfried and Ileana Montalbetti as Gutrune in the Canadian Opera Company's production of *Götterdämmerung*, 2017, photo: Michael Cooper.</figcaption>
</figure>

The design by Michael Levine and lighting  by David Finn were both simple and cutting-edge. The use of fluorescent lights to mark the starkness of the Gibichungs against the warm tones used in Brünnhilde's bower was incredibly effective. It was, at times, equal parts *Game of Thrones* and *House of Cards*.

The singing is flawless. I'll state that upfront. It was so flawless that more often than not, I forgot that the cast was singing some incredibly difficult music and not just passing time in casual conversation with me. This is no easy task, and there wasn't a single performer on that stage who didn't deliver. So let's talk about this dream cast, shall we? 

[Christine. Goerke.](/talking-with-singers-christine-goerke/)

Just her name can be a paragraph on its own. Her Brünnhilde is astounding and flawlessly sung and "Bedruckt" is still giving me the chills. From the moment you see her in the arms of Siegfried, you know exactly who's show this is. A massive, but in no way overbearing, voice issues from, dare I say, a rather Glamazonian physique - the design for Brünnhilde made me think of a bed-headed Sophia Loren. She was beautiful, sexy, and powerful. Ms. Goerke managed to juggle the brilliant passions of the Valkyrie like a pro. Quick to love and even quicker to anger, the fire that flashed in her eyes was visible from space. Every time she left the stage, I felt like I could watch 5 more *Ring Cycles* - consecutively. As far as Brünnhildes are concerned, I think I'm pretty darn lucky to say that Christine Goerke was my first - and we as a city are lucky to have her here for these roles. Please come back - even better, please never leave. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486125286202/2017-02-03---Gotterdammerung-MC-0646.jpg.jpg)
<figcaption>Christine Goerke as Brünnhilde in the Canadian Opera Company's production of *Götterdämmerung*, 2017, photo: Michael Cooper.</figcaption>
</figure>

Tenor [Andreas Schager](/scene/people/andreas-schager/) made his COC debut in the role of Siegfried. A bright, steely sound that sailed over the massive orchestra coming from the pit, Schager's bright eyes and naive smile were a perfect match for the impetuous hero. I felt like I was watching a Wagnerian version of Hugh Grant fly about the stage. His first duet with Brünnhilde was breathtaking, and watching him work as a spellbound Siegfried to hand his wife off to Gunther was pure theatre. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486125238258/2017-02-03---Gotterdammerung-CH-208.jpg.jpg)
<figcaption>Andreas Schager as Siegfried in the Canadian Opera Company's production of *Götterdämmerung*, 2017, photo: Chris Hutcheson.</figcaption>
</figure>

As the half-Nibelung vengeance-seeker Hagen, Estonian bass [Ain Anger](/scene/people/ain-anger/) made a remarkable COC Debut. (#TripleSwoonTimesInfinity) This tall, dark, and dreamy yet brutish hunk prowled powerfully across the stage with all the *Sturm und Drang* you could ask for. His portrayal of duplicity was a masterclass for the singing actor. The hardest part in portraying a role like this is making it believable that he is right in seeking his vengeance. I found myself, more than once, wholly on his side - you completely forget that the only reason Siegfried is unfatihful to anyone is due to Hagen's machinations. It was brilliant. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486125245533/2017-02-03---Gotterdammerung-CH-152.jpg.jpg)
<figcaption>Ain Anger (kneeling, right) as Hagen in a scene from the Canadian Opera Company's production of *Götterdämmerung*, 2017, photo: Chris Hutcheson.</figcaption>
</figure>

Marin Gantner, doing double-duty as "The Speaker" in #COCMagicFlute, brings us a vulnerable, fallible, and totally endearing Gunther. His work with Anger was top-notch. Used as a pawn by his half-brother, you get to watch him to come to this realization in an incredibly nuanced performance. Gantner shows us a Gunther who's so driven by notoriety and greed that he completely forgets who and what he is in its pursuit. His one redeeming moment of nobility costs him his life, and I sort of felt as if, overall, he may have been the most tragic figure on the stage.  

[Ileana Montalbetti](/scene/people/ileana-montalbetti/), one of many of the ladies singing double roles in this production, brought us a strong-willed Third Norn and a delicate and feiminine Gutrune. Drawing less sympathy from the audience during most of the show, you see her world come crashing down around her in her final interaction with Brünnhilde. Her dramatic journey was a rollercoaster ride of emotion from start to finish - never once did she give us the impression that she wouldn't be with Siegfried forever. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486125229877/2017-02-03---Gotterdammerung-CH-114.jpg.jpg)
<figcaption>(l-r) Karen Cargill as Waltraute and Christine Goerke as Brünnhilde in the Canadian Opera Company's production of *Götterdämmerung*, 2017, photo: Chris Hutcheson.</figcaption>
</figure>

As the Second Norn and Brünnhilde's sister Waltraute, [Karen Cargill](/scene/people/karen-cargill/) cut an impressive figure across the stage and was a perfect foil for Goerke's noble and fiery Valkyrie. In Act I when she arrives and begs Brünnhilde to return the ring to the Rhinemaidens, we were given an amazing and palpable power struggle between two powerful sisters who are both steeled in their resolve to see their own ends met. Waltraute's distress at her sister's refusal to help was devastating to experience (in the best possible way). 

[Robert Pomakov](/talking-with-singers-robert-pomakov/) brings us a creepy, eerie, and doom-filled Alberich, the ghost who shows up to egg Hagen on to bring the ring back to the Nibelungs; it's one of the best treatments of a haunting I've seen onstage in a while. Lindsay Ammann as Flosshilde and the First Norn sang with a surprisingly huge tone - especially over the bottom of her range and was thrilling. As Wellgunde and Woglinde, COC Ensemble Studio members [Lauren Eberwein](/scene/people/lauren-eberwein/) and [Danika Lorèn](/scene/people/danika-loren/) sang beautifully with Ammann and brought a real Greek nymph-like quality the three Rheinmaidens. Seeing them work together made me want to see *Das Rheingold* immediately. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486125275908/2017-02-03---Gotterdammerung-MC-1488.jpg.jpg)<figcaption>Andreas Schager as Siegfried (left) with the Rhinemaidens (l-r: Lauren Eberwein as Wellgunde, Lindsay Ammann as Flosshilde and Danika Lorèn as Woglinde) in the Canadian Opera Company's production of *Götterdämmerung*, 2017, photo: Michael Cooper.</figcaption>
</figure>

Despite my suspicion that I may have been the only male singer *not* in the COC Chorus for this production, I had no choice but to pocket my bruised ego as the Chorus sang so splendidly. Clean, clear diction and beautiful mastery of dynamics, Chorus Master Sandra Horst brought out some amazing ensemble singing - which is probably pretty easy to do when you have a group of a calibre as high as the COC Chorus.

I would be remiss if I didn't pay special attention to another major character in Wagner's work: the orchestra. 

Under [Johannes Debus](/scene/people/johannes-debus/)'s baton, the COC Orchestra played a long, difficult, and intricate score flawlessly. From downbeat to curtain the wash of sound was beautifully manipulated. This orchestra had one of the best understandings of dramatic music writing. So much of this play's emotion is found in Wagner's orchestra and they were equal if not far superior to the task. This is one of the best musical ensembles I've ever heard in person. Time and time again, their skill and versatility leave me floored. 
 
This is a remount of the original production mounted to open the Four Seasons Centre 11 years ago, and is one of those complete works of theatre that feels like it will stand the test of time. I can see this being remounted over and over again, and why wouldn't you with a house like this one and an orchestra like THAT.  The show runs selected dates until **February 25th**, and [tickets are available here](http://www.coc.ca/PerformancesAndTickets/1617Season/Gotterdammerung.aspx). It's a long show, but you don't see the time go by - if you liked *The Lord of the Rings* or *Game of Thrones* go see this show. 

And bring a snack.
