+++
author = ["authors/tracy-monaghan.md"]
categories = "Review"
date = "2016-11-15T13:21:00+00:00"
lastmod = "2016-11-15T15:42:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479218221951/2016-11-16---Square-GDDuo.jpg.jpg"
primary_image_credit = "Photo courtesy of Nashville Opera."
publishDate = "2016-11-15T15:42:00+00:00"
related_articles = ["articles/an-extended-mad-scene-glory-denied.md"]
related_companies = ["scene/companies/nashville-opera.md"]
short_description = "The work questions the perspective of emotional trauma, and whose is the most devastating? Is it enduring a prison camp for years only to return to an unrecognizable life? Is it enduring a different kind of prison-like solitude, guilt when one&#039;s life&#039;s work isn&#039;t enough? Nashville Opera&#039;s production of Glory Denied, fittingly opened on Veterans&#039; Day, is now one of only five or six full productions of the opera."
slug = "in-review-glory-denied"
title = "In review: Glory Denied"
+++

"May the faith and hope that have sustained you in the past continue in the days that follow."

It's impossible for Nashville Opera to have predicted how poignant this line, sung first by baritone Michael Mayes as Older Thompson in Tom Cipullo’s minimalist chamber opera *Glory Denied*, really is. There's an almost physical laceration that many of us are feeling right now.  It's divisive, it's tragic, it's devastating. 

And I think, when feeling such strong things, it’s easy to forget that devastation depends entirely on perspective. Devastation is subjective. Some aren't devastated at all. So last Friday, when I saw *Glory Denied* at the Noah Liff Opera Center in Nashville, I felt an emotional resonance in the parallels between the struggle of those characters and the struggle of citizens of the world brought about by current events. I sensed that my fellow audeience members felt it, too.

Some background: *Glory Denied*, written in 2007, is an opera based on the oral history (written by journalist Tom Philpott) of Vietnam veteran Colonel Jim Thompson, the United States' longest-held prisoner of war, and the family to which he returns after his release from captivity. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479218976117/2016-11-16---DGCast.jpg.jpg)
<figcaption>Photo courtesy of Nashville Opera.</figcaption>
</figure>

Its non-linear plot braids its four characters' narratives together: pre-/at war Jim and Alyce (his young wife), and post-war, older Jim and Alyce. At times, the arcs and plot points were almost too complicated – particularly as the opera's music lacks really easily-listenable, melodic themes. It's balanced in its thorniness and accessibility, though not perfectly, erring just slightly on the side of sonic discomfort. Though, it's clear that this is intentional, allowing the opera's few hymn-like melodies to stand defiant in dramatic contrast. 

The work questions the perspective of emotional trauma, and whose is the most devastating? Is it enduring a prison camp for years only to return to an unrecognizable life? Is it enduring a different kind of prison-like solitude, guilt when one's life's work isn't enough? Nashville Opera's production of *Glory Denied*, fittingly opened on Veterans' Day, is now one of only five or six full productions of the opera.  

John Hoomes' stage direction had each of the four characters onstage (at Noah Liff Opera Center's black box Opera Studio) simultaneously for most of the opera: Young Thompson, sung by tenor Eric Neuville, Young Alyce, sung by soprano Emma Grimsley, Older Thompson, and Older Alyce, sung by Rebecca Sjöwall. With such a small cast and a difficult score, singing *Glory Denied* is a tall order, exposing any weakness of the performers. Fortunately for Nashville's opera-goers, cast and orchestra lended themselves to a strong performance.


Dr. Neuville, who had the difficult task of crawling/reacting to physical pain/being injured and retaining a bunch of tension in his body, impressively sang floaty high notes with articulation and depth. His bright, but not metallic, and pleasing timbre rounded the edges of an oft-angular melodic line. Ms. Grimsley, a soprano, was very clearly the greenest of the cast. She sang with enduring control, and while some of the dense complexity of Young Alyce was slow to develop in her portrayal, Ms. Grimsley’s extended vocal range sounds how pale pink sequins look: pretty and light, with brillance and clarity.

We are lucky to have a singer with so clear a vocal affinity to new music as Rebecca Sjöwall. Her voice just takes to it so easily, I forget she’s singing. That's not just because of her several patter passages in *Glory Denied*, but the natural ease in her vocal precision and her voice' richness give a relatable life to the character. She made me feel for Alyce in a way that the set-up of the narrative discourages.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1479218999869/2016-11-16---Jims2.jpg.jpg)
<figcaption>Photo courtesy of Nashville Opera.</figcaption>
</figure>

Baritone Michael Mayes as Older Jim sucked the breath out of the room. More than once. Older Jim's character is the most complex, having endured physical and emotional torture as a POW only to return home for a emotional torture on a different plane. Although Older Jim does not expressly sing, at any point, "Why did I go through all of that? What am I going to do now? If I got through nine years of torture, why can’t I get through this?" Michael Mays gives us all of that subtext in his performance. He sings fearlessly, his voice velvety, vivid, and lush. Vocally, he gets out of his character's way in favor of revealing the range of emotions that Older Jim (or any of us, really) bears at any moment.

When uncertainty in our own strength and fear of the unknown creep in, questions arise: how can we trust each other? Is what I'm willing to surrender worth the risk? How do we ever move past the anger? At these moments, we can use opera to identify pain, to feel it, and hopefully transcend it. Catharsis is unplanned, but I think it can be gently nudged along.

>Nashville Opera next presents Three Way, a curious trio of one-act operas, January 27-29, 2017. To find out more, [click here.](http://www.nashvilleopera.org/three-way)
