+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-01-22T13:31:00+00:00"
lastmod = "2017-01-23T13:43:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485110015809/2017-01-22---Square---N68A0098.jpg.jpg"
primary_image_credit = "Robert Dean Smith (Florestan) in Fidelio with the LPO, 2017. Photo: Simon Jay Price"
publishDate = "2017-01-23T13:22:00+00:00"
related_articles = ["articles/wendy-bryn-harmer-leads-sensitive-inspirational-fidelio.md"]
related_people = ["scene/people/robert-dean-smith.md","scene/people/sofia-fomina.md","scene/people/kristinn-sigmundsson.md","scene/people/christopher-purves.md","scene/people/michael-konig.md"]
short_description = "Yet it&#039;s a fascinating, almost humanizing thing, to hear Beethoven struggle with how to really write for the voice. It&#039;s a bit like listening to Verdi&#039;s Stiffelio, which was written after Nabucco and Macbeth and Ernani, but before Rigoletto and La traviata; one couldn&#039;t argue with Verdi&#039;s skills as a composer, but even he, the opera expert, found his slow and steady way to effortless vocal writing."
slug = "in-review-fidelio-other-first-operas"
title = "In review: Fidelio &amp; other first operas"
+++

Hopefully, we're not the only opera fans that feel a vague sensation of riding an emotional rollercoaster when we hear Beethoven's *Fidelio*. On the one hand, the jabs and swells and surprises in that infamous [overture](https://en.wikipedia.org/wiki/Fidelio#The_overtures_to_Fidelio) prove that there's a reason Beethoven is a household name; when it comes to writing exciting music, Ludwig knows what's up. 

On the other hand, it's easy to hear that *Fidelio* is Beethoven's first opera; it's certainly correct that it was also his only opera. Christopher Hitchens once said that religion was our first attempts at literature, cosmology, and medicine, and that "it is the worst attempt, but partly because it was the first." Perhaps Beethoven's first opera was like those early years of blending religion and science, and perhaps if he had written more operas, *Fidelio* may enjoy the same kind of obscure status as, say, Verdi's *Alzira* or Mozart's *Il sogno di Scipione*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485177385157/2017-01-22---N68A0124.jpg.jpg)
<figcaption>Vladminir Jurowski conducting the London Philharmonic Orchestra. Photo by Simon Jay Price.</figcaption>
</figure>

To move from the overture into the first sung lines of *Fidelio* is to hear Beethoven, the expert, become Beethoven, the man who is learning how the voice works. Before *Fidelio*, Beethoven had already written 6 symphonies, over 20 piano sonatas, his Violin Concerto, and the famous "Kreuzer" Sonata. His hearing loss has progressed significantly during the years he spent writing *Fidelio* and other works, and by the time of its 1814 premiere, it is said that he could no longer hear music or speech clearly.

*Fidelio* has the same Germanic squareness that we hear in Mozart's *Die Entführung aus dem Serail* or even *Die Zauberflöte*; ironically for a revolutionary composer like Beethoven, his opera seems to lack the unashamed imagination of Weber's *Der Freischütz*. Instead, Beethoven's score is predictably intricate and always moving; it's in those relentless rhythmic subdivisions where singers can feel as though they're being stuffed in a box, without the space to settle their instrument and - most importantly - breathe.

Yet it's a fascinating, almost humanizing thing, to hear Beethoven struggle with how to really write for the voice. It's a bit like listening to Verdi's *Stiffelio*, which was written after *Nabucco* and *Macbeth* and *Ernani*, but before *Rigoletto* and *La traviata*; one couldn't argue with Verdi's skills as a composer, but even he, the opera expert, found his slow and steady way to effortless vocal writing.

The duet with Marzelline and Jaquino has the conversational life of that first scene in Mozart's *Le nozze di Figaro*, yet with more crowding. The gigantic, marathon-like arias for Leonore and Florestan have the great climactic affect of a Verdi *scena*, but with a merciless tessitura and picky details that beg the singer to overwork.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485177425308/2017-01-22---N68A0042.jpg.jpg)
<figcaption>Sofia Fomina (Marzelline), Kristinn Sigmundsson (Rocco), and Anja Kampe (Leonore). Photo by Simon Jay Price.</figcaption>
</figure>

But like much of Beethoven's infamous works, the line between the human and the divine seems just blurry enough for listeners across the spectrum of spirituality to map onto it what they like. "It's about the human being, not about the abstract idea," says conductor [Vladimir Jurowski](/scene/people/vladimir-jurowski/), who was passionate about including *Fidelio* in the London Philharmonic Orchestra's 2017 festival, *Belief and Beyond Belief*. "Above all, it's about us as humans and how we act when we are carried by hope. *Fidelio* is an ideal piece to demonstrate that hope, when put into action, can change reality for the better. Hope is the actual subject matter, and also the object of adoration in this piece."

Jurowski and the LPO worked with director Daniel Slater to present a mostly-in-concert performance of *Fidelio*, with the exciting [Anja Kampe](https://en.wikipedia.org/wiki/Anja_Kampe) as Leonore. Both [Michael König](/scene/people/michael-konig/) and [Christopher Purves](/talking-with-singers-christopher-purves/) withdrew from their performances as Florestan and Don Pizarro due to illness; [Robert Dean Smith](/scene/people/robert-dean-smith/) stepped in for König, and [Pavlo Hunka](http://www.artistsman.com/home/artist_list/baritonebass/pavlo-hunka/biography/) for Purves. Kampe's powerful instrument was a believable trouser-role soprano as "Fidelio", with enough womanly warmth to remind us that she was Leonore, who missed her husband. [Sofia Fomina](/scene/people/sofia-fomina/) was a clear, ringing Marzelline, beautifully paired both with Kampe as "Fidelio" and with tenor [Ben Johnson](/scene/people/ben-johnson/)'s Jaquino. [Kristinn Sigmundsson](/scene/people/kristinn-sigmundsson/) seemed Rocco incarnate, and Smith broke hearts with his first wailing "Gott!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485177469150/2017-01-22---N68A0031.jpg.jpg)
<figcaption>Sofia Fomina (Marzelline). Photo by Simon Jay Price.</figcaption>
</figure>

David Slater's direction was a creative approach to the in-concert performance setting. For the first act, Jurowski and the LPO were in casual dress; the singers were seated upstage, next to a stage management table and a rehearsal room coffee-and-water station. Mock-ups of set and costume designs were posted on the wall, opposite a rack of costumes. Essentially, the first act straddled the line between a sitzprobe and a staging rehearsal, all visible to the audience; the second act had Jurowski and the LPO in orchestra blacks, as though Act I had been a precursor to "the show".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485177539919/2017-01-22---N68A0191.jpg.jpg)
<figcaption>Anja Kampe (Leonore). Photo by Simon Jay Price.</figcaption>
</figure>

In lieu of German dialogue, narrators Helen Ryan and Simon Williams summed up the story of *Fidelio* between musical numbers, with newly-wrtten English text; they acted as unbiased observers, in and out of the scene. A bit jarring, sure, but it kept the story compact and digestable.

And throughout it all, we couldn't help but mourn the lost chance of hearing a second attempt at Beethoven's operatic writing.

>Jurowski and the London Philharmonic Orchestra continue their *Belief and Beyond Belief* Festival throughout 2017. [Find out more here.](https://www.lpo.org.uk/belief-and-beyond-belief.html)
