+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-11-05T14:46:00+00:00"
lastmod = "2016-11-05T16:55:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478359648739/2016-11-05---Madeleine-Pierard-Shadwell-Opera-photoNick-Rutter2.jpg.jpg"
primary_image_credit = "Madeleine Pierard in Shadwell Opera's Erwartung, 2016. Photo by Nick Rutter."
publishDate = "2016-11-05T16:50:00+00:00"
related_articles = ["articles/ghost-stories-true-stories-the-lighthouse.md","articles/murky-works-shadwell-opera-presents-the-lighthouse.md"]
related_companies = ["scene/companies/shadwell-opera.md"]
related_people = ["scene/people/madeleine-pierard.md","scene/people/kate-howden.md"]
short_description = "Erwartung and Twice Through the Heart both hurl listeners directly into the action. We are presented with questions: are these women killers? Are they crazy? Are they liars? Are their memories to be trusted? Sitting above the immediate curiosity with these women are larger questions about how women in particular are pushed to violence."
slug = "in-review-erwartungtwice-through-the-heart"
title = "In review: Erwartung/Twice Through the Heart"
+++

Shadwell Opera's double-bill, pairing Schoenberg's *Erwartung* with Turnage's *Twice Through the Heart*, is one of those combinations which is glaringly obvious in hindsight. They're both short pieces with texts by women, scored for one female singer and orchestra; more interestingly, we meet two women dealing with what happened on the worst day of their lives (so far).

Under the baton of Musical Director Finnegan Downie Dear - who led a skilled orchestra through two very subtle, tricky pieces - *Erwartung* and *Twice Through the Heart* both hurl listeners directly into the action. We are presented with questions: are these women killers? Are they crazy? Are they liars? Are their memories to be trusted? Sitting above the immediate curiosity with these women are larger questions about how women in particular are pushed to violence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478362448753/2016-11-05---Madeleine-Pierard-Shadwell-Opera-photoNick-Rutter.jpg.jpg)
<figcaption>Madeleine Pierard in Shadwell Operas's *Erwartung*, 2015. Photo by Nick Rutter.</figcaption>
</figure>

The Woman in *Erwartung* appears almost immediately beyond help, and perhaps beyond sympathy. Soprano [Madeleine Pierard](/scene/people/madeleine-pierard/) achieved the kind of earnestness that made us believe that *she believed* her version of the story, in which she discovers her lover, dead. Jack Furness' direction and Georgia De Grey's set design alluded to both a forest and a jail, to both a bedroom and a graveyard; actor Simeon John-Wake played the silent role of the lover, and Furness achieved a smart balance of the symbolic and the practical. The blood and splayed body mixed with the imagination and shadows in Schoenberg's score, and the affect leaves one leaning forward, breathless.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478362504116/2016-11-05---Kate-Howden-Shadwell-Opera-photoNick-Rutter.jpg.jpg)
<figcaption>Kate Howden in Shadwell Opera's *Twice Through the Heart*, 2016. Photo by Nick Rutter.</figcaption>
</figure>

Where *Erwartung* questions the vagueness of reciprocal love, jealousy, and one-sided obsession, *Twice Through the Heart* lives in a world that is familiar and tangible for contemporary audiences. Mezzo-soprano [Kate Howden](/scene/people/kate-howden/) portrays a woman who idealized the concept of marriage, dealt with domestic violence and neglect, and perhaps earned herself the last word in her most recent argument with her now-dead husband. Turnage's score feels like an old American film score, peppered with his notoriously eclectic, sound-effect-like colour palette. This woman seemed to earn more sympathy and benefit of the doubt, yet director Celine Lowenthal kept reminding us that she was telling her story from inside a jail cell - perhaps for a reason. Lowenthal made use of the graveyard-like dirt covering the floor of her apartment/backyard/jail cell, each site distinguished by simple and effective lighting design by Zoe Spurr.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478362431228/2016-11-05---Kate-Howden-2Shadwell-Opera-photoNick-Rutter.jpg.jpg)
<figcaption>Kate Howden in Shadwell Opera's *Twice Through the Heart*, 2016. Photo by Nick Rutter.</figcaption>
</figure>

For all the detail work and impressive musicianship by both Pierard and Howden, there was something lost in the flow of the evening. The two pieces likely could have been presented with a minimal break (perhaps a merciful few minutes to move sets), to make the shared qualities of *Erwartung* and *Twice Through the Heart* ring louder. The interval seemed too long for two short pieces, and it was made longer by a bonus working session with artist Sergei Zinchuck before the second piece began (it's quite a bold move, to give each member of an audience a 6-foot-long wooden stick). What could have been a very compact, very impressive evening of theatre became, unfortunately, diffused.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478364267822/2016-11-05---Finnegan-Downie-Dear-Shadwell-Opera-photoNick-Rutter.jpg.jpg)
<figcaption>Finnegan Downie Dear, Musial Director of Shadwell Opera. Photo by Nick Rutter.</figcaption>
</figure>

Still, our first introduction to Shadwell Opera's work is exciting and ambitious, and they're absolutely worth checking out. Their double-bill plays once more [this evening at Hackney Showroom](/killer-women-shadwell-operas-double-bill/), or you can stay in touch with Shadwell via [Twitter.](https://twitter.com/shadwellopera)
