+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-03-31T09:52:00+01:00"
lastmod = "2017-04-08T16:27:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490950206738/2017-03-31---Wigmore.jpg.jpg"
publishDate = "2017-03-31T09:57:00+01:00"
related_articles = ["articles/polish-composers-take-the-stage-at-wigmore-hall.md"]
short_description = "For a group that plays so much with singers, it was shocking to see how little sensitivity they had towards Bevan and Hulett. We were watching the classy soprano try to make elegant choices in all of her arias, but those five violins were not responding to her well. While they reveled in their long flowing legato lines, they played without breathing or reacting to the singer."
slug = "in-review-early-opera-company-at-wigmore-hall"
title = "In review: Early Opera Company at Wigmore Hall"
+++

One of the best things about Handel’s music is also one of the most confusing things: its power to sound like it could have come from anywhere. There are moments when listening to a Handel opera when, if listened in isolation, we could easily say, "Oh, that music is definitely by Lully," or, "Vivaldi had to have written this aria."

The Early Opera Company opened their concert at Wigmore Hall with a Concerto grosso by Handel that could have been inspired by the amazing op. 6 of Corelli. The ensemble played with a great energy, making the repetitive harmonic rhythm exciting and interesting. We love the ensemble’s playing together, especially their unison trills and virtuosic scales. 

They then changed gears to play excerpts from William Boyce's *Solomon*. From the Early Opera Company's performance, it was hard to discern what genre this piece fit into. There are just two roles - He and She - yet the performance lacked any kind of dramatization from the singers themselves. The tenor [Benjamin Hulett](/scene/people/benjamin-hulett/) sang well, but without any expression on his face for almost the entire evening. It was a strong contrast with soprano [Mary Bevan](/scene/people/mary-bevan/), who while during a duet, was trying to engage Hulett in her expression and playful nature of singing through legato lines, but the tenor didn’t bite.

Listening to Bevan, and the moments when she was overpowered by the band in a big way, we became aware of a big problem in early eighteenth century music. For both roles of He and She, Boyce's writing sits in the middle voice and is almost always accompanied by strings. For someone like Hulett, this did not pose a problem because he was so resonant on the staff. But Bevan had the odds against her, because after all, there was no "mezzo-soprano" *Fach* in the early eighteenth century, there was only "soprano" and "contralto," so a voice that would have been considered a soprano we would probably now put in mezzo roles. It was not completely inaudible, and we commend Bevan for never pushing against the five violins, two of which could have easily been tacit for her singing.

And finally we get to the meat of this evening - Handel’s incidental music to the play *Alceste*, by Tobias Smollett. Here we heard the contrasting and dramatic writing that makes Handel so effective. We hear Handel’s French influence in the swung inégal chorus movement, "Thrice happy who in life excel," put up against some very German-sounding contrapuntal action in "All hail, thou mighty son of Jove!"

For a group that plays so much with singers, it was shocking to see how little sensitivity they had towards Bevan and Hulett.  We were watching the classy soprano try to make elegant choices in all of her arias, but those five violins were not responding to her well. While they reveled in their long flowing legato lines, they played without breathing or reacting to the singer. In the beautiful soprano aria, "Gentle Morpheus, son of night," Bevan tried to draw us in with her subtle tone but the violins seemed to be playing at the exact wrong dynamic. During "Ye swift minutes as ye fly," we could hear Hulett struggling with the tempo but instead of allowing room for him they pushed forward and seemed to rush when the singer had long coloratura phrases.

Moments when the singers were accompanied by only the continuo section fared much better. In all of the recitatives we felt like the accompaniment grew out of the singer naturally and all parties were able to flow together beautifully. As Bevan sang the aria, "Still caressing, and caress'd," she and the continuo team were able to make more dynamic contrast within phrases, and Hulett felt more than at home in the style of this music for "Enjoy the sweet Elysian grove." 

Apart from Bevan and Hulett, Early Opera Company's chorus sang exceedingly well, and for one aria, we got to hear James Platt singing with a powerful voice that made sense of the archaic text in "Ye fleeting shades, I come." 

After hearing a work like *Alceste*, we found ourselves asking: which country can claim ownership of the music of Handel? Is it Germany, the place of his birth? Or maybe Italy, where he studied. We hear so much French influence in his music, as well, and his English music can be seen as defining in this time period for Great Britain. It's clear evidence of Handel's skill that his style, so adaptive to the language of the text, seems constantly native; perhaps it's a bit of sad irony that the Early Opera Company did not quite follow Handel's singer-friendly lead.
