+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-05-12T17:47:00-04:00"
lastmod = "2015-04-27T18:04:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429834655460/DonQuichotte-MC-1062-1024x704.jpg.jpg"
primary_image_credit = "Ferruccio Furlanetto and Anita Rachvelishvili. Photo by Michael Cooper."
publishDate = "2014-05-12T17:47:00-04:00"
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/anita-rachvelishvili.md","scene/people/ferruccio-furlanetto.md"]
short_description = "Massenet&#039;s Don Quichotte has opened at the Canadian Opera Company, the final in the three spring shows of the 2013/14 season. I&#039;m glad I saw it last, since there was something bittersweet about ending a season with comedy and charm. I&#039;ll admit I have a strange personal tendency to get annoyed by everyone&#039;s favourite bumbling knight; but perhaps I&#039;m coveting Don Quixote&#039;s unwavering pursuit of goodness."
slug = "in-review-don-quichotte"
title = "In review: Don Quichotte"
+++

Massenet's [_Don Quichotte_](http://www.coc.ca/PerformancesAndTickets/1314Season/DonQuichotte.aspx) has opened at the Canadian Opera Company, the final in the three spring shows of the 2013/14 season. I'm glad I saw it last, since there was something bittersweet about ending a season with comedy and charm. I'll admit I have a strange personal tendency to get annoyed by everyone's favourite bumbling knight; but perhaps I'm coveting Don Quixote's unwavering pursuit of goodness. Philosophical thoughts quickly vanished when I saw the live horse and mule onstage.

I thought the cast of _Quichotte_ was fantastic across the board. It was, of course, a memorable experience to see legendary bass [Ferruccio Furlanetto](http://www.ferrucciofurlanetto.com/) perform in the title role. He's in his 60s, and the role demands a lot, and he was pretty darn impressive. He really did sing _as Don Quixote_, showing off with risky soft singing and expansive, exaggeratedly grand lines. It was a true display of an entire career's worth of experience and comfort onstage. He had moments of physical impulses that truly were spontaneous, and I have no doubt that if I went to the next show of _Quichotte_, Ferruccio's performance would be noticeably different. He was the embodiment of Don Quixote, all legs and wild hair, and he moved around the stage with surprising agility.  His belaboured sword fights, his stubborn guitar-strumming, his ridiculous lunges at windmill panels, they were all brilliant physical comedy that made Quixote an honest, vulnerable character that everyone could see.

As Sancho Panza, Quixote's faithful servant, baritone [Quinn Kelsey](http://www.quinnkelsey.com/) nearly broke my heart. Quinn is busy these days with roles like Rigoletto, Germont, Conte de Luna, etc., so it was great to see Quinn in a (partially) comedic role. When he first rode in on that mule with an ear-to-ear grin on his face, I nearly died. Live-animal brownie-points aside, Quinn really did portray Sancho in a way that made us love him. His voice was warm and agile, like a younger man with an old soul; his sound was grounded and frank, a perfect fit for Sancho's role as foil to Quixote. Quinn has a funny habit of singing in straight-tone once in a while, and I think the chatty, comedic elements of this role brought that habit out. It didn't affect his intonation or anything, but Quinn's relaxed, natural voice is so much more desirable. He [spoke to Schmopera](/talking-with-singers-quinn-kelsey/) earlier, talking about his professional relationship with Ferruccio, and how it had some similarities to Sancho's relationship with Quixote. I think I saw some of that between the two singers.

Georgian mezzo-soprano [Anita Rachvelishvili](http://www.anitarachvelishvili.com/default.html) sang the role of Dulcinée, Quixote's idolized object of his affection. I loved her warm sound that seemed to smoothly wind around her full range. She had huge power, filling the Four Seasons Centre with her enormous sound. Then, she surprised me with her fluid coloratura, focusing her sound so that it became easy to move. The best part of Anita's performance was that she _sang every note_. The dips and dives from low to high registers didn't faze her, and she took the time to make sure we heard her technical prowess. The role of Dulcinée seemed like it demands plenty of a singer, in several bursts over the course of the show. Anita's first appearance was like a more universally-accepted Carmen, happy to be the centre of attention, but no game-player.

Dulcinée's four suitors was fantastic. [Sasha Djihanian](https://twitter.com/SashaDjihanian) (Pedro), [Ariana Chris](http://www.robert-gilder.com/ArtistDetail.aspx?artist_id=2305&category_id=1010) (Garcias), [Andrew Haji](http://www.andrewhaji.com/) (Rodriguez) and [Owen McCausland](/tag/owen-mccausland/) (Juan) sounded beautiful together. Their ensemble singing was some of my favourite music of the show, and they all had charming moments of interaction with Dulcinée. Andrew's voice rang easily through the hall, and Owen sang with an ever-growing sound that's exciting to hear. Ariana and Sasha were both great in their pants roles; Sasha has a surprising knack for playing male characters, and her Pedro was the cutest thing I ever did see.

The COC Chorus was great as usual, staying crisp in what seemed like tricky patter and wordy chorus parts. Canadian tenor [Michel Corbeil](http://www.micartists.com/micbio_MC.htm) lead the team of bandits that Quixote encounters, and he showed off some great acting chops. Individual members of the chorus were featured as well, in small lines, often spoken.

I thought this production, by director [Linda Brovsky](http://www.robert-gilder.com/ArtistDetail.aspx?artist_id=2366&category_id=1019&location_id=3001), was an appropriate mix of alluding to the significance of the story of Don Quixote, and staying present in the action. At times, I struggled to figure out what I was supposed to be looking at. In the first scene, the chorus blended visually with the cast so much that I wouldn't have known to follow the four suitors if I didn't already know three of them.

The sets and costumes, by [Donald Eastman](http://www.linkedin.com/pub/donald-eastman/44/816/675) and [Christina Poddubiuk](http://www.catalysttcm.com/christinapoddubiuk.html), worked well with each other. The sets consisted of oversized stacks of books and writing quills, nodding to the historicity of the story of Don Quixote. By contrast, the costumes were all time-specific, setting it in the 16th century, when the Cervantes wrote the [original novel](http://en.wikipedia.org/wiki/Don_Quixote). I thought the combination made for a beautiful picture that allowed for suspended disbelief; at times, though, the sets didn't quite cut it for the drama. In the scene when Quixote attacks a windmill, the surrounding sets (oversize feather pens) were too frail to really stand for the chaotic attack that the story recounts. It was sort of anticlimactic.

The music was fantastic from the COC Orchestra, under the baton of the COC's Music Director, [Johannes Debus](http://www.coc.ca/aboutthecoc/companymembers/Orchestra/JohannesDebus.aspx). The music was a lush mix of Massenet's usual soaring phrases and Spanish party music. In fact, five fantastic dancers were featured throughout the show, and I thought it was a really organic use of dance in modern(ish) opera.

I left _Don Quichotte_ with a tug at my heartstrings, and you should really make the time to go and see this production. It's a treat to see a major artist like Ferruccio Furlanetto on the Four Seasons Centre stage, and the piece itself is a gem that's done infrequently. It runs until May 24th; for tickets and more info, click [here](http://www.coc.ca/PerformancesAndTickets/1314Season/DonQuichotte.aspx).
