+++
author = ["authors/tracy-monaghan.md"]
categories = "Review"
date = "2016-10-10T09:18:00+01:00"
lastmod = "2016-10-11T14:09:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476087676278/2016-10-10---Giovanni-Art.jpg.jpg"
publishDate = "2016-10-11T14:02:00+01:00"
related_articles = ["articles/in-review-don-giovanni-at-eno.md","articles/in-review-tcherniakovs-don-giovanni.md"]
related_companies = ["scene/companies/nashville-opera.md"]
short_description = "Commendations go to stage director John Hoomes. We were promised a &quot;visually striking&quot; production, and that promise was fulfilled. Mr. Hoomes, whose choice to juxtapose the classic opera with modern, minimalist (yet effective) set design, action that ebbed and flowed between pleasing camp and very human, and innovative color schemes, used exciting visual symbolism to highlight the thematic duality of the story."
slug = "in-review-don-giovanni-at-nashville-opera"
title = "In review: Don Giovanni at Nashville Opera"
+++

Writing this review is a challenge, because there were lots of good things about Nashville Opera’s season opener, a production of everyone’s old fave, Mozart’s *Don Giovanni*, but there were also some things that made me think, *what is actually happening right now?* And not in a really good way.

Commendations go to stage director John Hoomes. We were promised a "visually striking" production, and that promise was fulfilled. Mr. Hoomes, whose choice to juxtapose the classic opera with modern, minimalist (yet effective) set design, action that ebbed and flowed between pleasing camp and very human, and innovative color schemes, used exciting visual symbolism to highlight the thematic duality of the story.  That choice was also meant to highlight the strength of the singers, and unfortunately, that strength was lacking. I also appreciate a director who allows his cast some creative room to develop their characters, but that only works when the entire cast takes that opportunity, and they did not.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476118863864/08Giovanni_07.jpg.jpg)
<figcaption>A scene from Nashville Opera's *Don Giovanni*. Photo by Reed Hummell.
</figure>

I’ll give them the benefit of the doubt, here: the hall (while full of state-of-the-art theater technology) was probably too large, and an inappropriate venue for these singers, to the point where I couldn’t hear some of them sing – and I had really good seats (thanks, Nashville Opera, appreciate you).  Straining to hear became distracting.  That aside, the cast, while sonically unbalanced, showed some sparkly moments. 

David Adam Moore, a real barihunk, was mostly irresistible as the titular Don Giovanni.  His richly charismatic and effortless baritone made me somehow trust D.G., who is, at best: a D-bag, and at worst: a murderer.  Mr. Moore's characterization drew me in, and set up his fellow cast mates to draw me in as well.  Donovan Singletary as Leporello was likeable – played with a theatre-kid, dorky familiarity – but so much of Leporello’s exciting patter was lost.  There were occasionally clear moments, but I was mostly just trying to hear him.  Mozart really exposes technical weaknesses in singers, and I wondered if that was part of the trouble with Mr. Singletary’s Leporello.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476118884445/08Giovanni_14.jpg.jpg)
<figcaption>A scene from Nashville Opera's *Don Giovanni*. Photo by Reed Hummell.
</figure>

Alyson Cambridge as Donna Elvira had a particularly beautiful moment in act two in "Ah taci, ingiusto core".  Her thick, even tone, tinged with melancholy, was relatable to anyone who has loved a boy they shouldn't have loved.  Ms. Cambridge largely interpreted the role with "opera acting", which I don’t mind, but many of her cast mates did not match her energy.  Laura Krumm as Zerlina was perhaps my favorite, with her technically solid, beautiful sound and excellent acting skills giving Zerlina the most human, natural arc of the night.  Her performance also exacerbated some of her cast mates’ lackluster performances.

Yi Li as Don Ottavio, Karen Slack as Donna Anna, and Jose Rubio as Masetto were fine.  None were particularly dynamic.  While Ms. Slack's big, lyrical voice was clear and vibrant, her portrayal of Donna Anna was not.  Jose Rubio's Masetto was small and flat (not in pitch, in interpretation).  I actually did quite enjoy Yi Li singing Don Ottavio's Act Two aria, "Il mio tesoro".  His voice is an exciting mix of bright, tenor placement with baritone heft, but again: the characterization wasn't there.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476118905817/DG--Anthony-Popolo.jpg.jpg)
<figcaption>A scene from Nashville Opera's *Don Giovanni*. Photo by Anthony Popolo.
</figure>

Performed in the Tennessee Performing Arts Center's Andrew Jackson Hall – I believe it’s the biggest hall in the area, frequently hosting Broadway national tours, country musical acts, TED talks, etc. – on October 6 and 8, this production of *Don Giovanni* seemed extra-poignant if we view it alongside the current (and upsetting) landscape of "White Guys That Get Away with Everything".  It holds an umbrella of solemnity over the comedy.  Because, I guess, if we don’t laugh, we cry.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476119006872/08Giovanni_03crop.jpg.jpg)
<figcaption>A scene from Nashville Opera's *Don Giovanni*. Photo by Reed Hummell.
</figure>

Nashville Opera’s seeming commitment to (or at least strong preference for) producing new or newish operas has me looking forward to the [rest of its season](http://www.nashvilleopera.org/season-1/).
