+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-02-22T09:55:00-05:00"
lastmod = "2016-02-22T11:10:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456155167180/2016-02-22---Dmitri-Hvorostovsky---Pavel-Antonov"
primary_image_credit = "Photo by Pavel Antonov."
publishDate = "2016-02-22T10:30:00-05:00"
related_articles = ["articles/in-review-sondra-radvanovsky-at-koerner-hall.md","articles/in-review-anne-sofie-von-otter-and-angela-hewitt.md","articles/in-review-paul-appleby-at-wigmore-hall.md","articles/in-review-juan-diego-florezs-rosenblatt-recital.md","articles/in-review-bryn-terfel-at-koerner-hall.md","articles/renee-fleming-tso.md","articles/hibla-gerzmava-danielle-akta-with-the-moscow-virtuosi.md"]
related_companies = ["scene/companies/royal-conservatory-of-music.md"]
related_people = ["scene/people/dmitri-hvorostovsky.md"]
short_description = "He sang with that delicious, velvety focus in his sound, and it struck me how rare it is to hear a baritone sing as consistently lyrically as he does. At 53, Hvorostovsky still has that enormous breath control, and the unfailing legato we all love; there was youth and fitness in his sound, and it was thrilling to watch."
slug = "in-review-dmitri-hvorostovsky-at-koerner-hall"
title = "In review: Dmitri Hvorostovsky at Koerner Hall"
+++

Last night's recital at Koerner Hall, presented by [Show One Productions](http://www.showoneproductions.ca/), was arguable one of the most anticipated events of Toronto's music scene this season. Star baritone [Dmitri Hvorostovsky](/scene/people/dmitri-hvorostovsky/) returned to Toronto after his 2014 recital in the same venue, which, predictably, sold out quickly. A full house gathered once again to hear Hvorostovsky and stellar pianist Ivari Ilya, including a few rows of onstage seating for some very lucky listeners.

When the pair appeared onstage, the applause was intense and heartfelt. Hvorostovsky has had a difficult year, with health concerns resulting in cancelled performances and understandable concern from his fans. This audience emitted an extra layer of celebration for the famed baritone, showing an excitement both for his voice and his solid return to the stage.

Hvorostovsky's program was divided into four sets of songs, by Mikhail Glinka, Nikolai Rimsky-Korsakov, Pyotr Ilyich Tchaikovsky, and Richard Strauss. I was a little surprised that there were no reserved spots for some operatic arias, considering Hvorostovsky's recent performances in baritone-friendly operas like *Il trovatore*, *Un ballo in maschera* and *Eugene Onegin*. Perhaps they were reserved for encore slots - I'll admit, unfortunately, that an unhappy stomach and persistently nasty headache kept me from seeing the second half of his recital.

It was my first time hearing Hvorostovsky live. The usual goosebumps appeared when he strode onstage, and the first few moments of "that voice" were a really special experience. He sang with that delicious, velvety focus in his sound, and it struck me how rare it is to hear a baritone sing as consistently lyrically as he does. At 53, Hvorostovsky still has that enormous breath control, and the unfailing legato we all love; there was youth and fitness in his sound, and it was thrilling to watch. His is a perfect example of what it means for a voice to "mature".

It's an interesting example of how "the voice" is indeed the singer's primary tool for expression; yet, there was something divisive about the recital programme and Hvorostovsky' onstage demeanour. After his gleaming smile in response to the deafening applause, he showed very little awareness or reaction to his audience. Sure, there was a lemming-like tendency of the audience's to clap loudly and proudly between each song (even in the middle of a set, to my picky irritation); perhaps Hvorostovsky was trying to stay "in the moment" between songs, and that's what I misread as aloofness. Yet, after the third burst of applause in the first Glinka set, I found it off-putting that he insisted on remaining untouchable, in a performance bubble of his own. It just felt a bit robotic rather than human.

The programme was full of repertoire that I anticipated we'd hear from him, yet it was a lot of the same. In fairness, I did miss the second half; yet I didn't anticipate too much contrast with Tchaikovsky and Strauss than I had with Glinka and Rimsky-Korsakov. Of course, it was beautifully sung, and the poetry was as tortured and bittersweet as we expect from Russian repertoire; yet there was an air of taking oneself too seriously. The love for Hvorostovsky was completely clear throughout Koerner Hall, and it seemed as though he was trying to maintain the professionalism that we already know he had. I was looking forward to seeing a bit of "Hvorostovsky the person", yet he kept it all business.

It was a stark contrast to soprano [Sondra Radvanovsky's Koerner Hall appearance](/in-review-sondra-radvanovsky-at-koerner-hall/) last year; she brought personality and even a bit of stand-up comedy to her stellar recital, and the pairing of incredible technique and amiable personality made us love her even more. With Hvorostovsky, the voice was unarguably in great shape, yet the uniform choice of repertoire and the non-reciprocal vibe I got seemed to keep us at arm's length. 

Still, his recital was an incredibly special experience, and one that we were all lucky to hear. Hvorostovsky's schedule is still packed with concert tours, and productions of *Un ballo in maschera* and *Simon Boccanegra* at the Vienna State Opera, and his notorious *Eugene Onegin* at the Metropolitan Opera. Like the rest of his enthusiastic listeners, I wish him a busy and healthy season to come.

> [Click here](http://www.showoneproductions.ca/upcoming-events.aspx) to check out the Show One Productions line-up for the rest of the season. Plus, lovers of singers will want to check out [*Le travail du peintre*](http://performance.rcmusic.ca/event/songmasters_2) on March 6th, featuring soprano [Mireille Asselin](/scene/people/mireille-asselin/) at the Royal Conservatory's Mazzoleni Hall.
