+++
author = ["authors/greg.md"]
categories = "Review"
date = "2015-08-19T19:30:00+02:00"
lastmod = "2015-08-20T15:08:00+02:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1440006863808/Hagerman-photo-by-Rachel-McCaigSquare.jpg.jpg"
primary_image_credit = "Beth Hagerman as Maggie in LooseTEA's Dissociative Me. Photo by Racheal McCaig."
publishDate = "2015-08-19T20:10:00+02:00"
related_articles = ["articles/check-out-loose-tea-music-theatre.md","articles/in-review-love-in-the-age-of-autocorrect.md","articles/alainas-autocorrect.md"]
related_companies = ["scene/companies/loose-tea-music-theatre.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/johnathon-kirby.md","scene/people/beth-hagerman.md"]
short_description = " I walked into RED Nightclub to catch LooseTea Music Theatre&#039;s latest offering, &quot;Dissociative Me&quot;. A new transladaptation of Gounod&#039;s Faust, in which we find the devious relationship with the malevolent spirit Mephistopheles has evolved into a dissociative personality disorder, where he inhabits the other part of John Faustus&#039;s psyche."
slug = "in-review-dissociative-me"
title = "In review: Dissociative Me"
+++

With my friend, mezzo-soprano [Christina Campsall](/scene/people/christina-campsall/), on my arm, I walked into [RED Nightclub](http://www.rednightclub.ca/) to catch [LooseTea Music Theatre](/scene/companies/loose-tea-music-theatre/)'s latest offering, "Dissociative Me". A new translapdatation of Gounod's *Faust*, in which we find the devious relationship with the malevolent spirit Mephistopheles has evolved into a dissociative personality disorder, where he inhabits the other part of John Faustus's psyche. 

With a cold Stella Artois (or two) in hand, we selected our seats. I thought the dark space of the Liberty Village club lent itself wonderfully to the dark material Gounod tackles in this work. The ceiling is lined with tubes of LED coloured lights, that can alter and dance at a whim creating moments of stark dreariness as well as a psychedelic discotheque.

Sung by [Kijong Wi](https://ca.linkedin.com/pub/kijong-wi/34/730/a70), the title role is a long haul for a tenor. He managed the role quite well considering the challenges he faced. His opening aria, although a little pinched over the top, set the stage for a night of some really good singing. A lovely Italianate sound with a solid line, I felt at times there was a bit too much "muscling" to create size in the voice. His was one of the lighter voices on stage, never a bad thing, so sometimes he could get lost in ensemble singing. His characterization of the socially awkward astrophysicist was equal parts cringeworthy awkwardness and the devastatingly adorable - a balance I enjoyed a great deal. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1440007063540/York-Wi%20-%20by%20Rachel%20McCaig.jpg.jpg)
<figcaption>Michael York and Kijong Wi. Photo by Racheal McCaig.</figcaption>
</figure>

This serves as a great contrast to Michael York's characterization of the his alter-ego Lee. York's ringing, full baritone was a great match for Faust's score. Fluid and liquid throughout his range, it's always a delight hearing Michael sing in English. His diction is never overwrought or artificial. I particularly enjoyed his few interactions with [Johnathon Kirby](/scene/people/johnathon-kirby/)'s character, Stephen, to be some of my favourite singing from the boys.  

Speaking of Kirby, his heroic baritone sounded great in the space and on the score. A handsome man with an equally handsome voice. I highly recommend hearing him at your next opportunity (oh look, they have [2 more shows!](http://www.eventbrite.ca/e/dissociative-me-tickets-17700064369?ref=ebtnebtckt)).

The standout for me on this one has to be soprano [Beth Hagerman](/scene/people/beth-hagerman/). Her Maggie was probably the best singing of the night and some of the best I've heard from her. A clear, strong lyric with a wonderful bloom in her upper register, she is one to watch! Her acting is also on point. She rose to the challenge of Maggie's character arc easily, and her Act III opening aria was breathtaking. 

Ably supported by comprimario tenors Fabián Arcineagas and Jonathan Sandberg as bar patrons and friends, their characters brought a little levity to an otherwise heavy play. I did have issues with their work as transvestites. It was hard to believe that they had spent any time in heels, and their discomfort really pulled you out of one of the most important scenes. It's a great juxtaposition, but the portrayal of the "ladies" of the night came off comical, and I don't think (in fact I hope that it wasn't) the intent. One must be very careful and specific anytime you put a man in a dress. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1440007219299/11013544_866140513462382_6655606665544232109_n.jpg%3Foh%3Dce4beff96a3dda6f379e667d2fc19211%26oe%3D567E488C)
<figcaption>Michael York, Fabian Acineagas, super Carl Lyon, Johnathon Kirby, and Johnathan Sandberg. Photo via LooseTEA on [Facebook](https://www.facebook.com/LooseTEAMusicTheatre/photos/pcb.866140703462363/866140513462382/?type=1&theater).</figcaption>
</figure>

Pianist Jennifer Tung's playing was spectacular as always. Finally getting to strut her stuff on a proper piano for LooseTea, the production was sponsored in part by [Steinway Piano Gallery Toronto](http://www.steinwaytoronto.ca/). Her musicality is always a joy to experience. She brought the colours of Gounod's lovely French orchestrations to life. 

The space was lit by Oz Weaver mixing standard theatre lighting with the existing light fixtures of the nightclub itself. His work definitely kept you in the dark psychological world that these poor unfortunate souls live in. Maureen Russell's costumes were appropriately contemporary, and included a t-shirt that sported one of my favourite science puns ("Particle physics gives me a Hadron"). 

The translation worked well and I liked that the demon is actually part of John Faustus's psyche, but the spoken dialogue was clunky and felt under-rehearsed. There were moments where I felt the cast was slipping into improv for what was clearly a scripted scene. This disrupted the pace of the whole thing and pulled me out of my suspension of disbelief and made me wonder if the actors were losing their track or if it was on purpose. This was unfortunate because I really did enjoy the concept of Faustus/Lee inhabiting the same body and the group scenes had some great energy. I feel like the set may have contributed to these issues as well. With the brilliant idea to sell sofas to the show (you can book tickets [here](http://www.eventbrite.ca/e/dissociative-me-tickets-17700064369?ref=ebtnebtckt)) with bottle service and the like, it forced the playing area to be pretty much flush against the "proscenium". It sort of forced the actors into a face-on, presentational style of acting, which at times can be effective, but I think the space could have used a little more dimension and breathing room so the characters could explore their arcs even further. 

Overall, it's a great night out with some really fantastic singing. I've worked with this company before and they're a delight all around. There are two more shows, and you won't be disappointed: Thursday August 20 and Saturday August 22 both at 7:30PM. This is really a great chance to hear some hot talent in a cool, trendy locale. For details and ticket information, follow the box office links below.
