+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-11T20:42:00-04:00"
lastmod = "2015-04-11T21:17:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428798942950/Walkure-MC-1808_Fotor.jpg.jpg"
primary_image_credit = "Michael Cooper"
publishDate = "2015-02-05T09:41:00-05:00"
related_articles = ["articles/in-review-siegfried.md","articles/in-review-gotterdammerung-at-the-coc.md","articles/die-walkure.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/heidi-melton.md","scene/people/christine-goerke.md","scene/people/aviva-fortunata.md","scene/people/atom-egoyan.md","scene/people/johannes-debus.md"]
short_description = "Last night I finally got the chance to satisfy my curiosity, by seeing the Canadian Opera Company’s current production of Die Walküre, directed by Atom Egoyan (and running until Feb. 22). Since the 2014/15 season was announced, I had been eager to see Egoyan’s take on Wagner, and to hear Christine Goerke as Brünnhilde. "
slug = "in-review-die-walkre-at-the-coc"
title = "In review: Die Walküre at the COC"
+++

<p>
	Last night I finally got the chance to satisfy my curiosity, by seeing the <a href="http://www.coc.ca/PerformancesAndTickets/1415Season/DieWalkure.aspx" target="_blank">Canadian Opera Company's current production of <i>Die Walküre</i></a>, directed by Atom Egoyan (and running until Feb. 22). Since the 2014/15 season was announced, I had been eager to see Egoyan's take on Wagner, and to hear <a href="http://www.christinegoerke.com/" target="_blank">Christine Goerke</a> as Brünnhilde. The women singing the Valkyries themselves included a few friends and colleagues of mine, which always adds a new level of anticipation. I missed the earlier runs of this production, in 2004 and 2006, making me feel slightly out of some <em>Ring Cycle</em> loop. Maybe it's surprising that Wagner isn't my go-to choice for opera listening, but I've learned never to doubt the mesmerizing effect on me. <em>Die Walküre</em> certainly drew me in; now that I'm one quarter into the <em>Ring Cycle</em> loop, I kind of can't wait to see <em>Siegfried</em>.
</p>
<p>
	As Brünnhilde, <a href="http://www.christinegoerke.com/" target="_blank">Christine Goerke</a> was an obvious standout performance. She had a grounded, steely sound that was still agile and light on the top. Her first entrance, with those fantastic "ho-ho-to-ho" cries gave me shivers; her entire first scene was sung with such confident energy that it gave her almost spunky strength. Christine was an incredibly sympathetic Brünnhilde, which, in a female character is hard to balance with such power.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428799021232/Walkure-MC-1138_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/2ujXxdaZyM7KLgYtUeB9wc73saz-dxaF6zO3iXKSk_uAHOCGa03K0W0QsJFrWCjhPQigJ4eNyXrwalCq9rAUtdrHTJNB" src="http://lh3.googleusercontent.com/2ujXxdaZyM7KLgYtUeB9wc73saz-dxaF6zO3iXKSk_uAHOCGa03K0W0QsJFrWCjhPQigJ4eNyXrwalCq9rAUtdrHTJNB=s1200"></a><figcaption>Christine Goerke (Brünnhilde) and Clifton Forbis (Siegmung). Photo: Michael Cooper</figcaption></figure>
<p>
	<a href="http://en.wikipedia.org/wiki/Johan_Reuter" target="_blank">Johan Reuter</a> as Wotan was another deeply moving performance. He sang with an open and frank sound that held gorgeous power, and he had a gorgeous, dark tone in his low register. Johan was a notable actor, too; ironically, his Wotan was one of the most human characters onstage. His struggles with duty and responsibility were incredibly real, and led towards Wotan's final moments with Brünnhilde. Johan sings that final scene so, <em>so</em>beautifully. Together, Johan and Christine created a picture of love and respect between Wotan and his daughter.
</p>
<p>
	<a href="http://www.heidimeltonsoprano.com/" target="_blank">Heidi Melton</a> was touching as Sieglinde. She sang an enormous arc of colour, starting with frightened, shy small talk with Siegmund, and ending with an enormously thrilling final scene with Brünnhilde. I thought her voice sounded clear and easy, with a great mix of fragility and personality. Heidi sang a little wildly at the larger emotional spikes throughout the show, but it was always backed by solid singing of a role she knows very well. She also made beautiful use of the German language, I noticed.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428799184929/Walkure-MC-1004_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/a2t4lzaZ92nLySYpJUIKohqHZMwE5DF7tPlHVFTlnzqcW6TMD5Df8CdN4bcUNVUHWbOJ3-Ngn2tJprHpW6I7Na0O0uNmUQ" src="http://lh3.googleusercontent.com/a2t4lzaZ92nLySYpJUIKohqHZMwE5DF7tPlHVFTlnzqcW6TMD5Df8CdN4bcUNVUHWbOJ3-Ngn2tJprHpW6I7Na0O0uNmUQ=s1200"></a><figcaption>Clifton Forbis (Siegmund) and Heidi Melton (Sieglinde). Photo: Michael Cooper</figcaption></figure>
<p>
	Prior to downbeat, an announcement was made that tenor <a href="http://www.cami.com/?webid=157" target="_blank">Clifton Forbis</a> was feeling under the weather, but would still the role of Siegmund. I don't know Clifton's voice, and so I can't compare to his healthy sound, but I'll attest to his singing some of the most musically exciting moments of the night. I might have heard signs of Clifton's not feeling 100% in Act I, where the role had more call for <em>sprechstimme</em> and his sound was a bit heavy. His heroic and desperate singing in Act II really grabbed me, though, with his metallic sound that seemed to grow larger without limit.
</p>
<p>
	As Sieglinde's mean husband, Hunding, <a href="http://dimitry-ivashchenko.de/Dimitry_Ivashchenko/Willkommen_Welcome.html" target="_blank">Dimitry Ivashchenko </a>sounded like a cannon, exactly what you want with this character. When he sang, he sounded immediately menacing and cruel. Cruelty aside, he still sang with exciting ring, making me want to hear him as a less-bad guy. As Fricka, Wotan's wife, <a href="http://www.janinabaechle.com/?page_id=481" target="_blank">Janina Baechle</a> was fantastic. She had a voice to match her strong presence, and I believed that she could convince Wotan to change his mind.
</p>
<p>
	It never fails: the Act III entrance of the Valkyries gave me instant goosebumps. The terrifying music got my heart rate up, and one by one the eight singers got me more and more giddy. Soprano <a href="https://twitter.com/avivafortunata" target="_blank">Aviva Fortunata</a>, as Helmwige, started off the "ho-jo-to-ho" sequence with what were the most solid and satisfying octaves I've ever heard sung. It didn't stop as<a href="https://twitter.com/rihabchaieb" target="_blank">Rihab Chaieb</a> (Waltraute), <a href="http://www.lindsayammann.com/" target="_blank">Lindsay Ammann</a> (Schwertleite), <a href="http://www.monasomm.com/biographie/" target="_blank">Mona Somm</a> (Ortlinde), Laura Tucker (Siegrune), <a href="http://deanartists.com/artist/megan-latham/" target="_blank">Megan Latham</a> (Rossweisse) and <a href="https://twitter.com/burragec" target="_blank">Charlotte Burrage</a> (Grimgerde) piled onstage in hot dresses and big boots. Musically, it was full of gonads (ironically, I guess), and these Valkyries both intimidated me and made me want to be their friend. All the Valkyries were fantastic at establishing their strong, sisterly bond between each other, earning our sympathy when they were asked to disobey Wotan and protect Brünnhilde. They all deserve credit for negotiating a sketchy-looking set, with long dress trains, carrying dead bodies and fire. Brave, ladies.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428799233371/Walkure-MC-0127_Fotor_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/kHcS1fPui7Mdfbk9rupCnVvo4bXdgCGoCSIxB4xTrpTMsfSdf2ItZU9m_hI3aRodLUILU79XI55x7O31CXjG_LNHynjYWA" src="http://lh3.googleusercontent.com/kHcS1fPui7Mdfbk9rupCnVvo4bXdgCGoCSIxB4xTrpTMsfSdf2ItZU9m_hI3aRodLUILU79XI55x7O31CXjG_LNHynjYWA=s1200"></a><figcaption>Dimitry Ivashchenko (Hunding) and Heidi Melton (Sieglinde)</figcaption></figure>
<p>
	The COC Orchestra under Music Director <a href="http://www.coc.ca/AboutTheCOC/CompanyMembers/Orchestra/JohannesDebus.aspx" target="_blank">Johannes Debus</a> played thrillingly all night, starting with those relentless and throbbing tremolos, and finishing with my beloved Ring of Fire music. The orchestra played as one when necessary, and as a chamber group of soloists at other times. I couldn't stop looking at the crowded pit and all the novelty instruments (four Wagner tubas!), and I got a small sense of the hugeness that is this score. In other exciting news, maestro Debus became a father for the first time, just hours before conducting <em>Die Walküre</em>. Congratulations, maestro! #Champ.
</p>
<p>
	The production was all about lighting. There was a single set, designed by <a href="http://www.thecanadianencyclopedia.ca/en/article/michael-levine/" target="_blank">Michael Levine</a>, very post-apocalypse and vaguely meta. I was a little worried by the consistent darkness and static staging in Act I, but when I saw the first major shift in lighting, I realized how versatile the singular set really was. <a href="http://www.dfinndesign.com/www.dfinndesign.com/home.html" target="_blank">David Finn</a>'s lighting design created different worlds for mortals and gods, bringing the two together wisely when the worlds intersected (a bright spot on the Siegfried's sword, embedded in the tree). As for the static staging, I do always wonder with Wagner if more can be done with all that glorious music between lines of text. I understand that the orchestra's role is a spectacle in itself when it comes to Wagner, and the COC Orchestra and its open pit certainly did that last night. Wagner's music is so film-like at times, definitely with a slow pace, but there were moments where I thought the music specifically called for a character to move, or react.
</p>
<p>
	Details aside, I was still dragged into the story, and I found myself mesmerized by the pacing of the piece. This <em>Die Walküre</em> confirms once again that Wagner just kind of gets you, whether you like it or not. <em>Die Walküre </em>runs until February 22nd; <a href="http://www.coc.ca/PerformancesAndTickets/1415Season/DieWalkure.aspx" target="_blank">click here for details and tickets</a>.
</p>
