+++
author = ["authors/greg.md"]
categories = "Review"
date = "2016-10-21T21:10:00+01:00"
lastmod = "2016-10-25T18:58:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477087752506/2016-10-22---Square---161018_40985.jpg.jpg"
primary_image_credit = "Christopher Enns (back), Meghan Lindsay and Wallis Giunta in Opera Atelier's Dido and Aeneas, 2016. Photo by Bruce Zinger."
publishDate = "2016-10-21T23:51:00+01:00"
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/wallis-giunta.md","scene/people/meghan-lindsay.md","scene/people/christopher-enns.md"]
short_description = "Speaking of the Ballet, this is some of the most athletic dancing I&#039;ve seen them do yet. An actor friend of mine once described period dancing as &quot;just fancy walking&quot;. This is proof of the opposite. The lines, shapes and footwork were energetic, clean, and emotionally executed. For once I found the ladies large skirts accented and enhanced their choreography, rather than getting the way of me enjoying their fancy footwork. "
slug = "in-review-dido-and-aeneas"
title = "In review: Dido and Aeneas"
+++

Hi, Schmop-Tops!

There's something about seeing Baroque opera at the Elgin Theatre that is just so very right. The upper lobby with its mirrors, mosaic floor, and gold-leaf moulding really do make you feel like you've been transported back in time. 

That's exactly what Opera Atelier do with their productions, and this season's opener, Purcell's [*Dido and Aeneas*](http://operaatelier.com/season/16-17-season/dido-and-aeneas/), is no exception. #OADido was a treat for the senses and, I felt, a bit of a departure from what you expect at an OA show. Yes, there were the delightful period costumes, fit dancers and singers in various states of undress, and the standard staging conventions we're used to, but there was a freneticism and a vitality in this production I hadn't really felt from this company in the past. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477089299462/2016-10-22---161018_40377.jpg.jpg)
<figcaption>Ellen McAteer (left), Laura Pudwell (centre), and Karine White (far right) with artists of Atelier Ballet in Opera Atelier's *Dido and Aeneas*, 2016. Photo by Bruce Zinger.</figcaption>
</figure>

To flesh out the rather short-ish score of Purcell's masterwork, the OA team inserted various other pieces of music from Purcell (and one from his contemporaries, Marin Marais) to set dances to, and they started the show with a prologue of texts from Virgil's *Aeneid* - Purcell and Tate's source material for *Dido and Aeneas* - which I thought was a very smart move. It brought to light a lot of necessary exposition that an audience who didn't know Virgil's work wouldn't (but was expected) to know. It was a smart move. This made the production feel much more like a masque with musical and dance interludes breaking up the narrative of the Dido tragedy. 

Introducing the show - with help from the Opera Atelier Ballet, and the show's stars [Wallis Giunta](/talking-with-singers-wallis-giunta/) and [Christopher Enns](/scene/people/christopher-enns/) - was a prologue in Virgil's own words, performed by actress Irene Poole. She able portrayed several of the gods/goddesses expressing their views on what's taking place with the queen of Carthage. Her booming voice and control of dynamics were marvellous. Captivating and mystifying I could have watched her all night.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477089367689/2016-10-22---161018_40747.jpg.jpg)
<figcaption>Wallis Giunta and Christopher Enns in Opera Atelier's *Dido and Aeneas*, 2016. Photo by Bruce Zinger.</figcaption>
</figure>

As the Queen of Carthage, Dido, mezzo-soprano Wallis Giunta lights up the stage. In this outing you really see why she's so in demand around the world. While I did find the staging frenetic as a whole, it lent a sense of urgency to the narrative that I often find missing in this opera. It made it easier to reconcile Dido's decision to take her own life. Giunta's skill and stage presence are on full display. Obviously, everyone wants to know how the lament went - and it was stunning. I really appreciate the singer and/or the conductor's decision to keep a quicker tempo on the aria. It gave Giunta a chance to use her full (and wide) range of dramatic expression and let the bright colour and quick action of her voice show off a longer line and more grounded delivery. 

As the future founder of Rome, Aeneas, tenor [Christopher Enns](/chris-enns-rags-to-reasonable/) was every bit the Medieval hero. Tall, handsome, and graceful his chemistry with Giunta was palpable. He sang the role well, although I found it sat a bit low for him and maybe we lost some of the brilliance in his tone (which I love) due to that. I'm used to hearing Aeneas sung by baritones, although it's often cast with tenors. 

As Belinda, Dido's faithful handmaiden, soprano [Meghan Lindsay](/spotlight-on-meghan-lindsay/) brings her characteristic twinkly voice to the spritely melisma Purcell set out of her. She was so appealing in this role. There was a youthful vitality in her demeanour and voice that made Belinda one of the most lovable characters on the stage. I think the earlier the music Lindsay sings, the more we really get to see the beauty of her instrument shine. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477089404376/2016-10-22---161018_40566.jpg.jpg)
<figcaption>Laura Pudwell, Christopher Enns, Ellen McAteer and Karine White in Opera Atelier's *Dido and Aeneas*, 2016. Photo by Bruce Zinger.</figcaption>
</figure>

As the bearded Sorceress, mezzo Laura Pudwell stole the show. Stalking around the stage in a menacing crown (that kind of invoked an image of Ursula the sea witch from Disney's *The Little Mermaid*) she brought a menace and underlying power to her singing that elevated her beyond simple comic relief, which often happens with the Sorceress due to the bizarre scoring the commonplace use of a character voice. Ms. Pudwell shone every time she came on stage and you were hard-pressed to be able to look away from her. 

As her two witches, sopranos [Ellen McAteer](/scene/people/ellen-mcateer/) and Karine White stole the show. Their sparkling, yet sizeable voices, blended seamlessly and their physicalizations were top-notch. Funny, but not distracting and set you up perfectly for the doom of Dido to come shortly after. I was particularly taken with McAteer onstage. She managed to add a small bit of contemporary flair into her stylized physicality that both heightened the humour and her position next to the Sorceress. Brava. Also, that laughing duet where they sing "Eliza's ruined," was possibly the best I've ever heard it sung. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477089514680/2016-10-22---161018_40616.jpg.jpg)<figcaption>Cory Knight (wearing hat), Ellen McAteer, Laura Pudwell and Karine White in Opera Atelier's Dido and Aeneas, 2016. Photo by Bruce Zinger.</figcaption>
</figure>

As the drunken sailor - a role dear to my heart - tenor Cory Knight was charming, affable, and in great voice. His portrayal of the Sailor was comical and heartfelt. The drinking song number, where he's dressed as a British admiral with a giant 4-masted schooner in place of his tricorner hat, was the wonderful pause in the spiral of the second half of the opera's narrative. On top of singing the role very well, he was also a dab hand at dancing alongside the artists of the Atelier Ballet. 

Speaking of the Ballet, this is some of the most athletic dancing I've seen them do yet. An actor friend of mine once described period dancing as "just fancy walking". This is proof of the opposite. The lines, shapes and footwork were energetic, clean, and emotionally executed. For once I found the ladies large skirts accented and enhanced their choreography, rather than getting the way of me enjoying their fancy footwork. 

The first production on record of Dido was performed at a finishing school for girls, run by Josias Priest, with hired professionals coming in to play the roles of the men. In a gracious nod to the original, OA enlisted the services of the Toronto Children's Chorus Choral Scholars. The decision to mix them with the choristers from the OA Chorus gave the choral numbers a mystical almost nymph-like, otherworldly quality. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477089656474/2016-10-22---161018_39848.jpg.jpg)
<figcaption>Wallis Giunta (centre) with artists of Atelier Ballet in Opera Atelier's *Dido and Aeneas*, 2016. Photo by Bruce Zinger.</figcaption>
</figure>

The Tafelmusik Baroque Orchestra, under David Fallis, brought us a lively score full of nuance and texture. The featuring of the guitarist in one of the ballets was a nice touch, elevating him out of the pit to interact with the dancers really carried the conceit of the "Masque" even further. 

I have to say, overall this is one of my favourite OA shows I've seen. They're sticking to their artistic guns but finding some room to try new things, express themselves more.

>[Dido and Aeneas](http://operaatelier.com/season/16-17-season/dido-and-aeneas/) runs until October 29 at the Elgin Theatre. For details and tickets, [click here.](http://operaatelier.com/season/16-17-season/)
