+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-10T23:00:00-04:00"
lastmod = "2015-04-10T23:00:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428720890950/Jennifer-Enns-Modolo.jpg.jpg"
primary_image_credit = "Mezzo-soprano Jennifer Ens Modolo"
publishDate = "2015-03-07T10:14:00-05:00"
short_description = "Capella Intima showed off some incredible solo and ensemble singing, supported by the exciting chamber ensemble of the Gallery Players of Niagara (Rona Goldensher and Julie Baumgartel, violins, Brandon Chui, viola, Margaret Gay, cello, Borys Medicky, harpsichord)."
slug = "in-review-dido-and-aeneas-with-capella-intima"
title = "In review: Dido and Aeneas with Capella Intima"
+++

<p>
	Yesterday I went to Trinity-St. Paul's Centre to hear <a href="http://capellaintima.com/" target="_blank">Capella Intima</a> team up with the <a href="http://www.galleryplayers.ca/" target="_blank">Gallery Players of Niagara</a> for a night of Baroque tunes, including an in-concert performance of Purcell's <em>Dido and Aeneas</em>. I admit to feeling like an outsider in Toronto's Early Music scene, and besides an <a href="http://schmopera.com/bud-roach-on-capella-intima/" target="_blank">articulate and enthusiastic interview</a> given by Capella Intima founder Bud Roach, I had few expectations for the evening. Roach prefaced the concert by telling us that Italian Baroque was the usual repertoire for Capella Intima, and that a night of English music was a departure from the norm. I think it should become the norm, since the collaboration between the Gallery Players and Capella Intima was one of the more satisfying musical experiences I've had in a while.
</p>
<p>
	The first half was made up of <a href="http://en.wikipedia.org/wiki/Concerts_of_Antient_Music" target="_blank">"Antient Music"</a>, a term that was new for me; glees, catches, and rounds come from the 17th-century tradition of singing clubs (which strike me as the original Glee Club). Here, Capella Intima showed off some incredible solo and ensemble singing, supported by the exciting chamber ensemble of the <a href="http://www.galleryplayers.ca/about_performers_0607.htm" target="_blank">Gallery Players of Niagara</a> (<a href="http://windermere.braveform.com/docs/rona.html" target="_blank">Rona Goldensher</a> and <a href="http://legacy.wlu.ca/page.php?grp_id=160&amp;p=19368" target="_blank">Julie Baumgartel</a>, violins, <a href="http://www.innerchamber.ca/#!brandon-chui/cc0e" target="_blank">Brandon Chui</a>, viola, <a href="http://vancouveracademyofmusic.com/vam-alumni/gay/" target="_blank">Margaret Gay</a>, cello, <a href="http://www.borysmedicky.com/" target="_blank">Borys Medicky</a>, harpsichord). Bud Roach was the first to sing in his bright and agile tenor voice, starting with Purcell's "Strike the Viol". I loved how he sounded, full of energy and intent, with a heady sound that filled Trinity-St. Paul's. The singers of Capella Intima carried the first half with amazingly tight ensemble moments and lots of subtle musical gestures that sounded as one. Together with the Gallery Players, the performers always managed to find the big picture, the reason behind all the details in the score. The best part of the evening was the fact that everyone onstage looked to be having fun. There was a serious chamber music vibe, with lots of eye contact and passing off of phrases. It struck me that these are still rare things onstage, and I think it speaks volumes about the skill among these two groups.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428721025442/EmilyHeadshot-768x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/bzGEqr9k9oe_9n3bysf_ivsiodbghDG5AvcfQd2Bl3T_0hPz8LoBnKEV__1tZK0z2QRhqG0LqrjkJaonphk6fWjQyQo" src="http://lh3.googleusercontent.com/bzGEqr9k9oe_9n3bysf_ivsiodbghDG5AvcfQd2Bl3T_0hPz8LoBnKEV__1tZK0z2QRhqG0LqrjkJaonphk6fWjQyQo=s1200"></a><figcaption>Soprano Emily Klassen</figcaption></figure>
<p>
	Choosing English repertoire allowed the audience to hear Capella Intima's great connection to the text; they took all possible chances for word-painting, dramatic impulse, and comedy. I'm sure it's there too in their Italian rep, but it was so clear in English. I kept marvelling at how much great music exists that we rarely get to hear, like Purcell's duet for tenor and baritone, "Sound the Trumpet", which was impressively sung by Bud Roach and baritone David Roth. The trios sung by Shiela Dietrich, <a href="http://emilyklassen.com/bio.html" target="_blank" data-mce-href="http://emilyklassen.com/bio.html">Emily Klassen</a>, and <a href="http://www.naxos.com/person/Jennifer_Ens_Modolo/11806.htm" target="_blank" data-mce-href="http://www.naxos.com/person/Jennifer_Ens_Modolo/11806.htm">Jennifer Ens Modolo</a>, like the stunning "On a Musician's Tomb" by W. Harington, were like precursors to Mozart's <em>drei Damen</em>. On the more ridiculous side, there was Benjamin Cooke's "The Longitude", in which the phrases "be pissed on" and "be shit on" were repeated ad nauseam, like insane babbling or jazz scatting (sorry) gone wild. All that Baroque music wasn't so precious after all, it seems.<br>
</p>
<p>
	<br>
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428721094574/David-headshot.jpg"><img data-resize-src="http://lh3.googleusercontent.com/O_lR2FeLdqnRyHyrFMS5JJOcP7Tmw5E0co8QS175ExtFTaDk4D-7Rkq6IrzT-68UF326GVV0F8ldAOLXBczqCcapny_6" src="http://lh3.googleusercontent.com/O_lR2FeLdqnRyHyrFMS5JJOcP7Tmw5E0co8QS175ExtFTaDk4D-7Rkq6IrzT-68UF326GVV0F8ldAOLXBczqCcapny_6=s1200"></a></figure>
<p>
	The second half was a beautiful reading of <em>Dido and Aeneas</em>. Jennifer Ens Modolo was subtle and easy in the title role, never superimposing sadness onto Purcell's already melancholy score; she let the music do the work, and the result was really quite touching. David Roth was strong as Aeneas, and Sheila Dietrich and Emily Klassen were gorgeous both as Dido's maids, and as the Witches. Bud Roach sang the roles of the Sorcerer and the Sailor; I've never seen anyone have so much fun with a role as with Roach's Sorcerer. He let the comedy of <em>Dido </em> exist, and risked a less beautiful sound for the sake of an otherworldly character. This is the kind of thing I mean when I say that Capella Intima saw the big picture, the gesture in all the details.<br>
</p>
<p>
	<br>
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428721123802/SheilaDietrich.jpg"><img data-resize-src="http://lh3.googleusercontent.com/BisEpuu6Xy3xL859WB67S7-7RAVU7ouVxnhaePUtvuehPqXKaVaIZ6lfkeDHxc3VnXDn-5aXl3_9uaiJ35gUsvAB1XFtog" src="http://lh3.googleusercontent.com/BisEpuu6Xy3xL859WB67S7-7RAVU7ouVxnhaePUtvuehPqXKaVaIZ6lfkeDHxc3VnXDn-5aXl3_9uaiJ35gUsvAB1XFtog=s1200"></a><figcaption>Soprano Sheila Dietrich</figcaption></figure>
<p>
	It was a real musical treat to hear Capella Intima and the Gallery Players share a stage. There's something about the Early Music sound that is refreshing, like an Italian soda or orange sorbet. These artists are delivering the real deal, with no need for Baroque-era homework in order to enjoy what they're doing. Be sure to check <a href="http://capellaintima.com/" target="_blank" data-mce-href="http://capellaintima.com/">Capella Intima</a>'s website in order to catch their upcoming performances; I think they're a strong part of the Early Music whole in Toronto, and more people should head out to hear them. Bravi, everyone.<br>
</p>
